<?xml version="1.0" encoding="UTF-8"?>
<!--UNCLASSIFIED--><xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:src="urn:us:gov:ic:src"
                xmlns:icid="urn:us:gov:ic:id"
                xmlns:tdf="urn:us:gov:ic:tdf"
                xmlns:intdis="urn:us:gov:ic:intdis"
                xmlns:ism="urn:us:gov:ic:ism"
                xmlns:cve="urn:us:gov:ic:cve"
                xmlns:edh="urn:us:gov:ic:edh"
                xmlns:virt="urn:us:gov:ic:virt"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" title="" schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:src" prefix="src"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:id" prefix="icid"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:tdf" prefix="tdf"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:intdis" prefix="intdis"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:ism" prefix="ism"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:cve" prefix="cve"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:edh" prefix="edh"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:virt" prefix="virt"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00002</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00002</xsl:attribute>
            <svrl:text>
        [SRC-ID-00002][Error] The SourceID values within a TDO are unique.
        
        Human Readable: The SourceID values within a TDO are unique.
    </svrl:text>
            <svrl:text>
        For each tdf:TrustedDataObject, check to make sure that the total number of src:SourceID/src:DocumentID
        and src:SourceID/icid:Identifier values equal the total number of distinct src:SourceID/src:DocumentID
        and src:SourceID/icid:Identifier values.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M10"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00003</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00003</xsl:attribute>
            <svrl:text>
        [SRC-ID-00003][Error] src:SourceCitations element must have ancestor that is a tdf:TrustedDataObject.
        
        Human Readable: SRC assertions must live within a TDO.</svrl:text>
            <svrl:text>
        The ancestor of each src:SourceCitations element must be some tdf:TrustedDataObject.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00004</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00004</xsl:attribute>
            <svrl:text>
        [SRC-ID-00004][Error] Each TDO can have at most 1 src:SourceCitations element.
        
        Human Readable: There can only be one Source Citation Root Element per TDO.
    </svrl:text>
            <svrl:text>
        For each tdf:TrustedDataObject, this rule ensures that the count of src:SourceCitations
        element lesser than or equal to 1.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00007</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00007</xsl:attribute>
            <svrl:text>
        [SRC-ID-00007][Error]
        If the DateInformation element exists, at least one of its child 
        elements DateString, ApproximableDateTime, or SearchableDateTime must be present.
        
        Human Readable: Element DateInformation must have a value for one of its child elements.
    </svrl:text>
            <svrl:text> 
        For element src:DateInformation, this rule ensures that one or more of the
        child elements DateString, ApproximableDateTime,
        SearchableDateTime/EarliestStartDate or SearchableDateTime/LatestEndDate
        is specified with a non-white space value.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M13"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00010</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00010</xsl:attribute>
            <svrl:text>
        [SRC-ID-00010][Error]
        For elements: PersonalProfileGroup 
        at least one of the following child elements must have non-whitespace content: 
        Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
        
        Human Readable: PersonalProfileGroup must have a value for at least one of the following
        child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic. It
        normalizes the space of the value of the specified child elements
        and makes sure that the length of the resulting string is 
        greater than zero, which indicates non-whitespace content.
        
        Element PostalAddress cannot contain text content, so the rule counts the 
        number of its child elements that contain non-white space and makes sure
        that the count is great than 0.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M14"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00001</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00001</xsl:attribute>
            <svrl:text>
        This abstract pattern checks to see if the validation environment has at least the version / revision of the
        CVE as of the writing of this specification. 
        The calling rule must pass in '202111', 'ISM', '../../CVE/ISM/CVEnumISMClassificationAll.xml', 'SRC-ID-00001'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M15"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00011</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00011</xsl:attribute>
            <svrl:text> 
        [SRC-ID-00011][Error] For SRC elements with INTDIS attributes or containing
        INTDIS elements, the INTDIS CESVersion must exist somewhere in the instance. 
        
        Human Readable: If SRC is using INTDIS in any way, the INTDIS CESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For SRC elements with INTDIS attributes or containing INTDIS elements, the
        INTDIS CESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M16"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00012</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00012</xsl:attribute>
            <svrl:text>
        This abstract pattern checks to see if the validation environment has at least the version / revision of the
        CVE as of the writing of this specification. 
        The calling rule must pass in '201707', 'INTDIS', '../../CVE/INTDIS/CVEnumIntelDiscipline.xml', 'SRC-ID-00012'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M17"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00013</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00013</xsl:attribute>
            <svrl:text>
        This abstract pattern checks to see if the validation environment has at least the version / revision of the
        Schema as of the writing of this specification. 
        The calling rule must pass in '202010', 'VIRT', '../../Schema/VIRT/VIRT.xsd', 'SRC-ID-00013'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M18"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00014</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00014</xsl:attribute>
            <svrl:text>
        This abstract pattern checks to see if the validation environment has at least the version / revision of the
        Schema as of the writing of this specification. 
        The calling rule must pass in '1', 'IC-ID', '../../Schema/IC-ID/IC-ID.xsd', 'SRC-ID-00014'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M19"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00015</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00015</xsl:attribute>
            <svrl:text>
        This abstract pattern checks to see if the validation environment has at least the version / revision of the
        Schema as of the writing of this specification. 
        The calling rule must pass in '201903', 'IC-EDH', '../../Schema/IC-EDH/IC-EDH.xsd', 'SRC-ID-00015'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M20"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00016</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00016</xsl:attribute>
            <svrl:text> 
        [SRC-ID-00016][Error] For SRC elements with IC-EDH attributes or containing
        IC-EDH elements, the IC-EDH DESVersion must exist somewhere in the instance. 
        
        Human Readable: If SRC is using IC-EDH in any way, the IC-EDH DESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For SRC elements with IC-EDH attributes or containing IC-EDH elements, the
        IC-EDH DESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M21"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00017</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00017</xsl:attribute>
            <svrl:text> 
        [SRC-ID-00017][Error] For SRC elements with VIRT attributes or containing
        VIRT elements, the VIRT DESVersion must exist somewhere in the instance. 
        
        Human Readable: If SRC is using VIRT in any way, the VIRT DESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For SRC elements with VIRT attributes or containing VIRT elements, the
        VIRT DESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M22"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00018</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00018</xsl:attribute>
            <svrl:text> 
        [SRC-ID-00018][Error] For SRC elements with IC-ID attributes or containing
        IC-ID elements, the IC-ID DESVersion must exist somewhere in the instance. 
        
        Human Readable: If SRC is using IC-ID in any way, the IC-ID DESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For SRC elements with IC-ID attributes or containing IC-ID elements, the
        IC-ID DESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M23"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00019</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00019</xsl:attribute>
            <svrl:text> 
        [SRC-ID-00019][Error] For SRC elements with ISM attributes or containing
        ISM elements, the ISM DESVersion must exist somewhere in the instance. 
        
        Human Readable: If SRC is using ISM in any way, the ISM DESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For SRC elements with ISM attributes or containing ISM elements, the
        ISM DESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M24"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00020</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00020</xsl:attribute>
            <svrl:text>
        [SRC-ID-00020][Warning] src:DESVersion attribute SHOULD be specified
        as version 201508.202205 (Version:2015-AUG Revision: 2022-MAY) with an optional extension. 
    </svrl:text>
            <svrl:text>
        This rule supports extending the version identifier with an optional
        trailing hyphen and up to 23 additional characters. The version must match the regular
        expression “^201508.202205(-.{1,23})?$".
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M25"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00009</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00009</xsl:attribute>
            <svrl:text>
        [SRC-ID-00009][Warning] For every optional element that exists in the 
        document and can have text content, the element should have non-null, 
        non-whitespace value.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic. The abstract rule
        first concatenates the text values within the given element, separated by a single 
        space. The resultant string is then normalized with leading and trailing 
        whitespace removed, and the length of the string is determined to be greater 
        than zero, which indicates non-whitespace content. The abstract rule is extended 
        once for each optional element in the SRC schema.  
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M26"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">SRC-ID-00006</xsl:attribute>
            <xsl:attribute name="name">SRC-ID-00006</xsl:attribute>
            <svrl:text>
        [SRC-ID-00006][Warning]
        For elements ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate, 
        if the time designator (T) is specified, it is recommended that time zone be specified.
        
        Human Readable: It is recommended that time zone be specified if time designator (T) is specified for the following elements:
        ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic.
        If the value of the context contains the time zone designator (T),
        then it makes sure that the value of the context matches the 
        regular expression for a date with a time zone specified.
        The abstract rule is extended once for each required element
        listed in rule SRC-ID-00006.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M27"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
<xsl:param name="timeZoneRegEx" select="'Z|[\+-]\d{2}:\d{2}'"/>
   <xsl:param name="endsWithTimeZoneRegEx" select="concat('^.*',$timeZoneRegEx,'$')"/>

   <!--PATTERN SRC-ID-00002-->


	<!--RULE SRC-ID-00002-R1-->
<xsl:template match="tdf:TrustedDataObject" priority="1000" mode="M10">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject"
                       id="SRC-ID-00002-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(count(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/src:DocumentID)                           + count(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/icid:Identifier)) =                           (count(distinct-values(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/src:DocumentID))                           + count(distinct-values(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/icid:Identifier)))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(count(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/src:DocumentID) + count(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/icid:Identifier)) = (count(distinct-values(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/src:DocumentID)) + count(distinct-values(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/icid:Identifier)))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00002][Error] The SourceID values within a TDO are unique.
            
            Human Readable: The SourceID values within a TDO are unique.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M10"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00003-->


	<!--RULE SRC-ID-00003-R1-->
<xsl:template match="src:SourceCitations" priority="1000" mode="M11">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:SourceCitations"
                       id="SRC-ID-00003-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="ancestor::tdf:TrustedDataObject"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::tdf:TrustedDataObject">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00003][Error] src:SourceCitations element must have ancestor that is a tdf:TrustedDataObject.
            
            Human Readable: SRC assertions must live within a TDO.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M11"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00004-->


	<!--RULE SRC-ID-00004-R1-->
<xsl:template match="tdf:TrustedDataObject" priority="1000" mode="M12">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject"
                       id="SRC-ID-00004-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(child::tdf:Assertion/tdf:StructuredStatement/src:SourceCitations)&lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(child::tdf:Assertion/tdf:StructuredStatement/src:SourceCitations)&lt;= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00004][Error] Each TDO can have at most 1 src:SourceCitations element.
            
            Human Readable: There can only be one Source Citation Root Element per TDO.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M12"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00007-->


	<!--RULE SRC-ID-00007-R1-->
<xsl:template match="src:DateInformation" priority="1000" mode="M13">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:DateInformation"
                       id="SRC-ID-00007-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(src:DateString)) or normalize-space(string(src:ApproximableDateTime)) or normalize-space(string(src:SearchableDateTime/src:EarliestStartDate)) or normalize-space(string(src:SearchableDateTime/src:LatestEndDate))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(src:DateString)) or normalize-space(string(src:ApproximableDateTime)) or normalize-space(string(src:SearchableDateTime/src:EarliestStartDate)) or normalize-space(string(src:SearchableDateTime/src:LatestEndDate))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00007][Error]
            If the DateInformation element exists, at least one of its child 
            elements DateString, ApproximableDateTime, or SearchableDateTime must be present.
            
            Human Readable: Element DateInformation must have a value for one of its child elements.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M13"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M13"/>
   <xsl:template match="@*|node()" priority="-2" mode="M13">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M13"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00010-->


	<!--RULE SRC-ID-00010-R2-->
<xsl:template match="src:AuthorInfo" priority="1001" mode="M14">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:AuthorInfo"
                       id="SRC-ID-00010-R2"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="src:Surname[normalize-space(string(text()))]             or src:UserID[normalize-space(string(text()))]             or src:JobTitle[normalize-space(string(text()))]             or src:Affiliation[normalize-space(string(text()))]             or src:OfficeName[normalize-space(string(text()))]             or src:PhoneNumber[normalize-space(string(text()))]             or src:FaxNumber[normalize-space(string(text()))]             or src:EmailAddress[normalize-space(string(text()))]             or src:WebPageAddress[normalize-space(string(text()))]             or src:FormattedSignatureBlock[normalize-space(string(text()))]             or (some $token in src:PostalAddress/*/text() satisfies normalize-space(string($token)))             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="src:Surname[normalize-space(string(text()))] or src:UserID[normalize-space(string(text()))] or src:JobTitle[normalize-space(string(text()))] or src:Affiliation[normalize-space(string(text()))] or src:OfficeName[normalize-space(string(text()))] or src:PhoneNumber[normalize-space(string(text()))] or src:FaxNumber[normalize-space(string(text()))] or src:EmailAddress[normalize-space(string(text()))] or src:WebPageAddress[normalize-space(string(text()))] or src:FormattedSignatureBlock[normalize-space(string(text()))] or (some $token in src:PostalAddress/*/text() satisfies normalize-space(string($token)))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00010][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> at least one of the following child elements must have non-whitespace content:  
            Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
            
            Human Readable: Elements PersonalProfileGroup must have a value for at least one of the following
            child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M14"/>
   </xsl:template>

	  <!--RULE SRC-ID-00010-R3-->
<xsl:template match="src:POCinfo" priority="1000" mode="M14">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:POCinfo"
                       id="SRC-ID-00010-R3"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="src:Surname[normalize-space(string(text()))]             or src:UserID[normalize-space(string(text()))]             or src:JobTitle[normalize-space(string(text()))]             or src:Affiliation[normalize-space(string(text()))]             or src:OfficeName[normalize-space(string(text()))]             or src:PhoneNumber[normalize-space(string(text()))]             or src:FaxNumber[normalize-space(string(text()))]             or src:EmailAddress[normalize-space(string(text()))]             or src:WebPageAddress[normalize-space(string(text()))]             or src:FormattedSignatureBlock[normalize-space(string(text()))]             or (some $token in src:PostalAddress/*/text() satisfies normalize-space(string($token)))             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="src:Surname[normalize-space(string(text()))] or src:UserID[normalize-space(string(text()))] or src:JobTitle[normalize-space(string(text()))] or src:Affiliation[normalize-space(string(text()))] or src:OfficeName[normalize-space(string(text()))] or src:PhoneNumber[normalize-space(string(text()))] or src:FaxNumber[normalize-space(string(text()))] or src:EmailAddress[normalize-space(string(text()))] or src:WebPageAddress[normalize-space(string(text()))] or src:FormattedSignatureBlock[normalize-space(string(text()))] or (some $token in src:PostalAddress/*/text() satisfies normalize-space(string($token)))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00010][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> at least one of the following child elements must have non-whitespace content:  
            Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
            
            Human Readable: Elements PersonalProfileGroup must have a value for at least one of the following
            child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M14"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M14"/>
   <xsl:template match="@*|node()" priority="-2" mode="M14">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M14"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00001-->


	<!--RULE ValidateValidationEnvCVE-R1-->
<xsl:template match="/" priority="1000" mode="M15">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvCVE-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion castable as xs:double              and document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion &gt;= '202111'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion castable as xs:double and document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion &gt;= '202111'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [<xsl:text/>
                  <xsl:value-of select="'SRC-ID-00001'"/>
                  <xsl:text/>][Error] Version [ <xsl:text/>
                  <xsl:value-of select="document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion"/>
                  <xsl:text/> ] of <xsl:text/>
                  <xsl:value-of select="'ISM'"/>
                  <xsl:text/> found; 
            Version [<xsl:text/>
                  <xsl:value-of select="'202111'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'ISM'"/>
                  <xsl:text/> 
            is not being used in the validation infrastructure. Regardless of the version indicated on the instance document, 
            the validation infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'ISM'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'202111'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of the instance
            document but of the validation environment itself. The incorrect value was found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../CVE/ISM/CVEnumISMClassificationAll.xml'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M15"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M15"/>
   <xsl:template match="@*|node()" priority="-2" mode="M15">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M15"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00011-->


	<!--RULE SRC-ID-00011-R1-->
<xsl:template match="//src:*[@intdis:* or .//intdis:*]"
                 priority="1000"
                 mode="M16">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//src:*[@intdis:* or .//intdis:*]"
                       id="SRC-ID-00011-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@intdis:CESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@intdis:CESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [SRC-ID-00011][Error] For SRC elements with INTDIS attributes or containing INTDIS elements, the INTDIS CESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If SRC is using INTDIS in any way, the INTDIS CESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M16"/>
   <xsl:template match="@*|node()" priority="-2" mode="M16">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M16"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00012-->


	<!--RULE ValidateValidationEnvCVE-R1-->
<xsl:template match="/" priority="1000" mode="M17">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvCVE-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion castable as xs:double              and document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion &gt;= '201707'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion castable as xs:double and document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion &gt;= '201707'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [<xsl:text/>
                  <xsl:value-of select="'SRC-ID-00012'"/>
                  <xsl:text/>][Error] Version [ <xsl:text/>
                  <xsl:value-of select="document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion"/>
                  <xsl:text/> ] of <xsl:text/>
                  <xsl:value-of select="'INTDIS'"/>
                  <xsl:text/> found; 
            Version [<xsl:text/>
                  <xsl:value-of select="'201707'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'INTDIS'"/>
                  <xsl:text/> 
            is not being used in the validation infrastructure. Regardless of the version indicated on the instance document, 
            the validation infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'INTDIS'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'201707'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of the instance
            document but of the validation environment itself. The incorrect value was found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M17"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M17"/>
   <xsl:template match="@*|node()" priority="-2" mode="M17">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M17"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00013-->


	<!--RULE ValidateValidationEnvSchema-R1-->
<xsl:template match="/" priority="1000" mode="M18">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvSchema-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version castable as xs:double              and document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version &gt;= '202010'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version castable as xs:double and document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version &gt;= '202010'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [<xsl:text/>
                  <xsl:value-of select="'SRC-ID-00013'"/>
                  <xsl:text/>][Error] Version [ <xsl:text/>
                  <xsl:value-of select="document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version"/>
                  <xsl:text/> ] of <xsl:text/>
                  <xsl:value-of select="'VIRT'"/>
                  <xsl:text/> found; 
            Version [<xsl:text/>
                  <xsl:value-of select="'202010'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'VIRT'"/>
                  <xsl:text/> 
            is not being used in the validation infrastructure. Regardless of the version indicated on the instance document, 
            the validation infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'VIRT'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'202010'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of the instance
            document but of the validation environment itself. The incorrect value was found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../Schema/VIRT/VIRT.xsd'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M18"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M18"/>
   <xsl:template match="@*|node()" priority="-2" mode="M18">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M18"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00014-->


	<!--RULE ValidateValidationEnvSchema-R1-->
<xsl:template match="/" priority="1000" mode="M19">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvSchema-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document('../../Schema/IC-ID/IC-ID.xsd')//xsd:schema//@version castable as xs:double              and document('../../Schema/IC-ID/IC-ID.xsd')//xsd:schema//@version &gt;= '1'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../Schema/IC-ID/IC-ID.xsd')//xsd:schema//@version castable as xs:double and document('../../Schema/IC-ID/IC-ID.xsd')//xsd:schema//@version &gt;= '1'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [<xsl:text/>
                  <xsl:value-of select="'SRC-ID-00014'"/>
                  <xsl:text/>][Error] Version [ <xsl:text/>
                  <xsl:value-of select="document('../../Schema/IC-ID/IC-ID.xsd')//xsd:schema//@version"/>
                  <xsl:text/> ] of <xsl:text/>
                  <xsl:value-of select="'IC-ID'"/>
                  <xsl:text/> found; 
            Version [<xsl:text/>
                  <xsl:value-of select="'1'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'IC-ID'"/>
                  <xsl:text/> 
            is not being used in the validation infrastructure. Regardless of the version indicated on the instance document, 
            the validation infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'IC-ID'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'1'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of the instance
            document but of the validation environment itself. The incorrect value was found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../Schema/IC-ID/IC-ID.xsd'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M19"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M19"/>
   <xsl:template match="@*|node()" priority="-2" mode="M19">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M19"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00015-->


	<!--RULE ValidateValidationEnvSchema-R1-->
<xsl:template match="/" priority="1000" mode="M20">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvSchema-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version castable as xs:double              and document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version &gt;= '201903'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version castable as xs:double and document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version &gt;= '201903'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [<xsl:text/>
                  <xsl:value-of select="'SRC-ID-00015'"/>
                  <xsl:text/>][Error] Version [ <xsl:text/>
                  <xsl:value-of select="document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version"/>
                  <xsl:text/> ] of <xsl:text/>
                  <xsl:value-of select="'IC-EDH'"/>
                  <xsl:text/> found; 
            Version [<xsl:text/>
                  <xsl:value-of select="'201903'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'IC-EDH'"/>
                  <xsl:text/> 
            is not being used in the validation infrastructure. Regardless of the version indicated on the instance document, 
            the validation infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'IC-EDH'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'201903'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of the instance
            document but of the validation environment itself. The incorrect value was found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../Schema/IC-EDH/IC-EDH.xsd'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M20"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M20"/>
   <xsl:template match="@*|node()" priority="-2" mode="M20">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M20"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00016-->


	<!--RULE SRC-ID-00016-R1-->
<xsl:template match="//src:*[@edh:* or .//edh:*]" priority="1000" mode="M21">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//src:*[@edh:* or .//edh:*]"
                       id="SRC-ID-00016-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@edh:DESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@edh:DESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [SRC-ID-00016][Error] For SRC elements with IC-EDH attributes or containing IC-EDH elements, the IC-EDH DESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If SRC is using IC-EDH in any way, the IC-EDH DESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M21"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M21"/>
   <xsl:template match="@*|node()" priority="-2" mode="M21">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M21"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00017-->


	<!--RULE SRC-ID-00017-R1-->
<xsl:template match="//src:*[@virt:* or .//virt:*]" priority="1000" mode="M22">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//src:*[@virt:* or .//virt:*]"
                       id="SRC-ID-00017-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@virt:DESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@virt:DESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [SRC-ID-00017][Error] For SRC elements with VIRT attributes or containing VIRT elements, the VIRT DESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If SRC is using VIRT in any way, the VIRT DESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M22"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M22"/>
   <xsl:template match="@*|node()" priority="-2" mode="M22">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M22"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00018-->


	<!--RULE SRC-ID-00018-R1-->
<xsl:template match="//src:*[@icid:* or .//icid:*]" priority="1000" mode="M23">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//src:*[@icid:* or .//icid:*]"
                       id="SRC-ID-00018-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@icid:DESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@icid:DESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [SRC-ID-00018][Error] For SRC elements with IC-ID attributes or containing IC-ID elements, the IC-ID DESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If SRC is using IC-ID in any way, the IC-ID DESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M23"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M23"/>
   <xsl:template match="@*|node()" priority="-2" mode="M23">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M23"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00019-->


	<!--RULE SRC-ID-00019-R1-->
<xsl:template match="//src:*[@ism:* or .//ism:*]" priority="1000" mode="M24">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//src:*[@ism:* or .//ism:*]"
                       id="SRC-ID-00019-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@ism:DESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@ism:DESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [SRC-ID-00019][Error] For SRC elements with ISM attributes or containing ISM elements, the ISM DESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If SRC is using ISM in any way, the ISM DESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M24"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M24"/>
   <xsl:template match="@*|node()" priority="-2" mode="M24">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M24"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00020-->


	<!--RULE SRC-ID-00020-R1-->
<xsl:template match="*[@src:DESVersion]" priority="1000" mode="M25">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="*[@src:DESVersion]"
                       id="SRC-ID-00020-R1"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="matches(@src:DESVersion, '^201508.202205(\-.{1,23})?$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="matches(@src:DESVersion, '^201508.202205(\-.{1,23})?$')">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00020][Warning] src:DESVersion attribute SHOULD be specified 
            as version 201508.202205 (Version:2015-AUG Revision: 2022-MAY) with an optional extension. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M25"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M25"/>
   <xsl:template match="@*|node()" priority="-2" mode="M25">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M25"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00009-->


	<!--RULE SRC-ID-00009-R2-->
<xsl:template match="src:InformationOriginator" priority="1026" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:InformationOriginator"
                       id="SRC-ID-00009-R2"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R3-->
<xsl:template match="src:ARCList" priority="1025" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:ARCList"
                       id="SRC-ID-00009-R3"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R4-->
<xsl:template match="src:SourceSummaryStatement" priority="1024" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:SourceSummaryStatement"
                       id="SRC-ID-00009-R4"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R5-->
<xsl:template match="src:AlternateSourceID" priority="1023" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:AlternateSourceID"
                       id="SRC-ID-00009-R5"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R6-->
<xsl:template match="src:SourceDescriptor" priority="1022" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:SourceDescriptor"
                       id="SRC-ID-00009-R6"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R7-->
<xsl:template match="src:Language" priority="1021" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:Language"
                       id="SRC-ID-00009-R7"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R8-->
<xsl:template match="src:DatePublished" priority="1020" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:DatePublished"
                       id="SRC-ID-00009-R8"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R9-->
<xsl:template match="src:DateTimeReferenced" priority="1019" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:DateTimeReferenced"
                       id="SRC-ID-00009-R9"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R10-->
<xsl:template match="src:DateInformation" priority="1018" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:DateInformation"
                       id="SRC-ID-00009-R10"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R11-->
<xsl:template match="src:Title" priority="1017" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:Title"
                       id="SRC-ID-00009-R11"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R12-->
<xsl:template match="src:SubTitle" priority="1016" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:SubTitle"
                       id="SRC-ID-00009-R12"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R13-->
<xsl:template match="src:CompilationTitle" priority="1015" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:CompilationTitle"
                       id="SRC-ID-00009-R13"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R14-->
<xsl:template match="src:EditionNumber" priority="1014" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:EditionNumber"
                       id="SRC-ID-00009-R14"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R15-->
<xsl:template match="src:VolumeNumber" priority="1013" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:VolumeNumber"
                       id="SRC-ID-00009-R15"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R16-->
<xsl:template match="src:IssueNumber" priority="1012" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:IssueNumber"
                       id="SRC-ID-00009-R16"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R17-->
<xsl:template match="src:SegmentReferenced" priority="1011" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:SegmentReferenced"
                       id="SRC-ID-00009-R17"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R18-->
<xsl:template match="src:Link" priority="1010" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:Link"
                       id="SRC-ID-00009-R18"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R19-->
<xsl:template match="src:InclusionReason" priority="1009" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:InclusionReason"
                       id="SRC-ID-00009-R19"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R20-->
<xsl:template match="src:Agency" priority="1008" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:Agency"
                       id="SRC-ID-00009-R20"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R21-->
<xsl:template match="src:AuthorInfo" priority="1007" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:AuthorInfo"
                       id="SRC-ID-00009-R21"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R22-->
<xsl:template match="src:EditorInfo" priority="1006" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:EditorInfo"
                       id="SRC-ID-00009-R22"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R23-->
<xsl:template match="src:POCinfo" priority="1005" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:POCinfo"
                       id="SRC-ID-00009-R23"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R24-->
<xsl:template match="src:OriginalClassificationMarking"
                 priority="1004"
                 mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:OriginalClassificationMarking"
                       id="SRC-ID-00009-R24"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R25-->
<xsl:template match="src:DateString" priority="1003" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:DateString"
                       id="SRC-ID-00009-R25"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R26-->
<xsl:template match="src:ApproximableDateTime" priority="1002" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:ApproximableDateTime"
                       id="SRC-ID-00009-R26"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R27-->
<xsl:template match="src:SearchableDateTime" priority="1001" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:SearchableDateTime"
                       id="SRC-ID-00009-R27"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

	  <!--RULE SRC-ID-00009-R28-->
<xsl:template match="src:ContactFor" priority="1000" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:ContactFor"
                       id="SRC-ID-00009-R28"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M26"/>
   <xsl:template match="@*|node()" priority="-2" mode="M26">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M26"/>
   </xsl:template>

   <!--PATTERN SRC-ID-00006-->


	<!--RULE SRC-ID-00006-R3-->
<xsl:template match="src:ApproximableDateTime" priority="1005" mode="M27">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:ApproximableDateTime"
                       id="SRC-ID-00006-R3"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))              then matches(string($valueTest),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [SRC-ID-00006][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designtor (T) is specified for the following elements:
          ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M27"/>
   </xsl:template>

	  <!--RULE SRC-ID-00006-R4-->
<xsl:template match="src:DatePublished" priority="1004" mode="M27">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:DatePublished"
                       id="SRC-ID-00006-R4"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))              then matches(string($valueTest),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [SRC-ID-00006][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designtor (T) is specified for the following elements:
          ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M27"/>
   </xsl:template>

	  <!--RULE SRC-ID-00006-R5-->
<xsl:template match="src:DateTimeReferenced" priority="1003" mode="M27">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:DateTimeReferenced"
                       id="SRC-ID-00006-R5"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))              then matches(string($valueTest),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [SRC-ID-00006][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designtor (T) is specified for the following elements:
          ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M27"/>
   </xsl:template>

	  <!--RULE SRC-ID-00006-R6-->
<xsl:template match="src:DateString" priority="1002" mode="M27">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:DateString"
                       id="SRC-ID-00006-R6"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))              then matches(string($valueTest),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [SRC-ID-00006][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designtor (T) is specified for the following elements:
          ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M27"/>
   </xsl:template>

	  <!--RULE SRC-ID-00006-R7-->
<xsl:template match="src:EarliestStartDate" priority="1001" mode="M27">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:EarliestStartDate"
                       id="SRC-ID-00006-R7"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))              then matches(string($valueTest),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [SRC-ID-00006][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designtor (T) is specified for the following elements:
          ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M27"/>
   </xsl:template>

	  <!--RULE SRC-ID-00006-R8-->
<xsl:template match="src:LatestEndDate" priority="1000" mode="M27">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="src:LatestEndDate"
                       id="SRC-ID-00006-R8"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))              then matches(string($valueTest),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [SRC-ID-00006][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designtor (T) is specified for the following elements:
          ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M27"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M27"/>
   <xsl:template match="@*|node()" priority="-2" mode="M27">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M27"/>
   </xsl:template>
</xsl:stylesheet>
<!--UNCLASSIFIED-->
