<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="SRC-ID-00002">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [SRC-ID-00002][Error] The SourceID values within a TDO are unique.
        
        Human Readable: The SourceID values within a TDO are unique.
    </sch:p>
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        For each tdf:TrustedDataObject, check to make sure that the total number of src:SourceID/src:DocumentID
        and src:SourceID/icid:Identifier values equal the total number of distinct src:SourceID/src:DocumentID
        and src:SourceID/icid:Identifier values.
    </sch:p>
    
    <sch:rule id="SRC-ID-00002-R1" context="tdf:TrustedDataObject">
        <sch:assert test="(count(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/src:DocumentID) 
                         + count(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/icid:Identifier)) = 
                         (count(distinct-values(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/src:DocumentID)) 
                         + count(distinct-values(tdf:Assertion/tdf:StructuredStatement/src:SourceCitations//src:SourceID/icid:Identifier)))" 
                         flag="error" role="error">
            [SRC-ID-00002][Error] The SourceID values within a TDO are unique.
            
            Human Readable: The SourceID values within a TDO are unique.
        </sch:assert>
    </sch:rule>
</sch:pattern>