<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="SRC-ID-00009">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [SRC-ID-00009][Warning] For every optional element that exists in the 
        document and can have text content, the element should have non-null, 
        non-whitespace value.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic. The abstract rule
        first concatenates the text values within the given element, separated by a single 
        space. The resultant string is then normalized with leading and trailing 
        whitespace removed, and the length of the string is determined to be greater 
        than zero, which indicates non-whitespace content. The abstract rule is extended 
        once for each optional element in the SRC schema.  
    </sch:p>
    
    <sch:rule abstract="true" id="abs.rule00009">
        <sch:assert test="normalize-space(string())" flag="warning" role="warning">
            [SRC-ID-00009][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule on optional elements -->
    
    <sch:rule id="SRC-ID-00009-R2" context="src:InformationOriginator">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R3" context="src:ARCList">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R4" context="src:SourceSummaryStatement">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R5" context="src:AlternateSourceID">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R6" context="src:SourceDescriptor">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R7" context="src:Language">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R8" context="src:DatePublished">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R9" context="src:DateTimeReferenced">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R10" context="src:DateInformation">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R11" context="src:Title">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R12" context="src:SubTitle">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R13" context="src:CompilationTitle">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R14" context="src:EditionNumber">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R15" context="src:VolumeNumber">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R16" context="src:IssueNumber">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R17" context="src:SegmentReferenced">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R18" context="src:Link">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R19" context="src:InclusionReason">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R20" context="src:Agency">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R21" context="src:AuthorInfo">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R22" context="src:EditorInfo">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R23" context="src:POCinfo">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R24" context="src:OriginalClassificationMarking">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R25" context="src:DateString">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R26" context="src:ApproximableDateTime">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R27" context="src:SearchableDateTime">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00009-R28" context="src:ContactFor">
        <sch:extends rule="abs.rule00009"/>
    </sch:rule>
    
</sch:pattern>
