<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00100">
	  <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
		[PUBS-ID-00100][Error] For any element, if attribute xlink:type is specified
		with a value of [simple], then that element can only define the following
		attributes in the xlink namespace: xlink:type, xlink:href, xlink:role, xlink:arcrole,
		xlink:title, xlink:show, and xlink:actuate.
		
		Human Readable: If any element has attribute xlink:type with a value of [simple], then that element can only have values for the
		following in the xlink namespace: xlink:type, xlink:href, xlink:role, xlink:arcrole, xlink:title, xlink:show, and xlink:actuate.
	</sch:p>

	  <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
		Makes sure that for each element that has attribute xlink:type specified
		with a value of [extended] only defines the following attributes in the xlink namespace:
		xlink:type, xlink:role, and xlink:title.
	</sch:p>

	  <sch:rule id="PUBS-ID-00100-R1" context="pubs:*[@xlink:type='simple']">
		    <sch:let name="xlinkAttrLocalNames" value="for $attr in @xlink:* return $attr/local-name()"/>
		    <sch:let name="allowedXlinkLocalNamesList" value="('type', 'href', 'role', 'arcrole', 'title', 'show', 'actuate')"/>
		    <sch:assert test="     every $attrLocalName in $xlinkAttrLocalNames satisfies      index-of($allowedXlinkLocalNamesList, $attrLocalName)    " flag="error" role="error">
			[PUBS-ID-00100][Error] For any element, if attribute xlink:type is specified
			with a value of [simple], then that element can only define the following
			attributes in the xlink namespace: xlink:type, xlink:href, xlink:role, xlink:arcrole,
			xlink:title, xlink:show, and xlink:actuate.
			
			Human Readable: If any element has attribute xlink:type with a value of [simple], then that element can only have values for the
			following in the xlink namespace: xlink:type, xlink:href, xlink:role, xlink:arcrole, xlink:title, xlink:show, and xlink:actuate.
		</sch:assert>
	  </sch:rule>
</sch:pattern>