<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00053">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00053][Error]
        For any element PostalAddress, at least one of its child elements 
        AddressLine, City, State, Province, PostalCode, or CountryCode must 
        have element content.
        
        Human Readable: Element PostalAddress must have a value for at least one of its child elements.
    </sch:p>
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        For each child element of pubs:PostalAddress listed, this rule normalizes the
        space of its value and make sures that the length of the resulting string 
        is greater than zero, indicating non-whitespace content. 
    </sch:p>
    
    <sch:rule id="PUBS-ID-00053-R1" context="pubs:PostalAddress">
        <sch:assert test="some $child in (pubs:AddressLine | pubs:City | pubs:State | pubs:Province | pubs:PostalCode | pubs:CountryCode) satisfies                     normalize-space(string($child))" flag="error" role="error">
            [PUBS-ID-00053][Error]
            For any element PostalAddress, at least one of its child elements 
            AddressLine, City, State, Province, PostalCode, or CountryCode must 
            have element content.    
            
            Human Readable: Element PostalAddress must have a value for at least one of its child elements.
        </sch:assert>
    </sch:rule>
</sch:pattern>