<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00045">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText"> [PUBS-ID-00045][Warning] irm:dates/@approvedOn must
        be earlier than or equivalent to pubs:DatePublished and irm:dates/@posted.
        
        Human Readable: irm:dates/@approvedOn has to be less than or equal to pubs:DatePublished and irm:dates/@posted.    
    </sch:p>

    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        For each irm:dates element which specifies attribute @irm:approvedOn, 
        this rule ensures that the date specified in attribute @irm:approvedOn is
        earlier than or equivalent to the date specified in attribute 
        irm:dates/@posted and the date specified in pubs:DatePublished.
    </sch:p>

    <sch:rule id="PUBS-ID-00045-R1" context="irm:ICResourceMetadataPackage/irm:dates[@irm:approvedOn]">
        <sch:let name="secondaryDateList" value="(ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, @irm:posted)"/>
        <sch:assert test="             every $secondaryDate in $secondaryDateList satisfies                 dtf:compareDateTimeRanges(string(@irm:approvedOn), '&lt;=', string($secondaryDate))" flag="warning" role="warning">
            [PUBS-ID-00045][Warning][PUBS-ID-00045][Warning] irm:dates/@approvedOn must
        	be earlier than or equivalent to pubs:DatePublished and DatePosted.
        	
        	Human Readable: irm:dates/@approvedOn has to be less than or equal to pubs:DatePublished and DatePosted.
        </sch:assert>
    </sch:rule>
</sch:pattern>