<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00040">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00040][Error]
        The permissible values for the year range are 1901 through the current year
        for elements DatePublished, DateReviewed, and DateRevised.
        
        Human Readable: Year values for DatePublished, DateReviewed, and DateRevised have to fall within the range 1901 through the current year.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses abstract rules to consolidate logic. For elements, 
        this rule ensures that the date contained within $dateValue has a year
        value within the range $minYear and $maxYear, inclusive. For attributes, 
        this rule ensures that each date contained within $dateValues has a year value
        within the range $minYear and $maxYear, inclusive.
    </sch:p>
    
    <sch:let name="minYear" value="1901"/>
    <sch:let name="maxYear" value="$currentYear"/>
    
	  <sch:rule abstract="true" id="abs.rule00040">
		    <sch:let name="errMsg" value="    concat('[PUBS-ID-00040][Error]    The permissible values for the year range are 1901 through the current year     for element ', name())"/>
		    <sch:extends rule="abs.dateYearRangeRule"/>
	  </sch:rule>
    
    <sch:rule abstract="true" id="abs.rule00040attrs">
        <sch:let name="fails" value="             for $date in $dateValues return             if(dtf:compareDateTimeRanges(string($minYear), '&lt;', string($date)) and              dtf:compareDateTimeRanges(string($date), '&lt;', string($maxYear))) then null else name($date)"/>
        <sch:assert test="count($fails)=0" flag="error" role="error">
            [PUBS-ID-00040][Error] The permissible values for the year range are 1901 through the current year for 
            attribute(s):<sch:value-of select="for $each in $fails return concat(' ', string($each))"/>.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule to check required elements -->

    <sch:rule id="PUBS-ID-00040-R3" context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished">
        <sch:let name="dateValue" value="."/>
    	<sch:extends rule="abs.rule00040"/>
    </sch:rule>

    <sch:rule id="PUBS-ID-00040-R4" context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateReviewed">
        <sch:let name="dateValue" value="."/>
    	<sch:extends rule="abs.rule00040"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00040-R5" context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised">
        <sch:let name="dateValue" value="."/>
    	<sch:extends rule="abs.rule00040"/>
    </sch:rule>

</sch:pattern>