<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00028">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00028][Error]
        For elements AnimationExhibit, AudioExhibit, Interactive3DExhibit, OtherExhibit, 
        StillImageExhibit and VideoExhibit attribute xlink:href must be specified.
        
        Human Readable: Attribute xlink:href must be specified for elements AnimationExhibit, AudioExhibit, Interactive3DExhibit, OtherExhibit, 
        StillImageExhibit and VideoExhibit.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic. It makes sure
        that the attribute xlink:href is specified. The abstract rule is extended
        once for each required element in rule PUBS_ID_00028.
    </sch:p>
    
    <!-- Abstract rule, which asserts that attribute xlink:href must be specified in the current context -->

    <sch:rule abstract="true" id="abs.rule00028">
        <sch:assert test="@xlink:href" flag="error" role="error">
            [PUBS-ID-00028][Error]
            For element <sch:name/> attribute xlink:href must be specified.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule to check required elements -->

    <sch:rule id="PUBS-ID-00028-R2" context="pubs:AnimationExhibit">
        <sch:extends rule="abs.rule00028"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00028-R3" context="pubs:AudioExhibit">
        <sch:extends rule="abs.rule00028"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00028-R4" context="pubs:Interactive3DExhibit">
        <sch:extends rule="abs.rule00028"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00028-R5" context="pubs:OtherExhibit">
        <sch:extends rule="abs.rule00028"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00028-R6" context="pubs:StillImageExhibit">
        <sch:extends rule="abs.rule00028"/>
    </sch:rule>
        
    <sch:rule id="PUBS-ID-00028-R7" context="pubs:VideoExhibit">
        <sch:extends rule="abs.rule00028"/>
    </sch:rule>

</sch:pattern>