<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00027">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00027][Error]
        For element ImageArea attribute coordinates must be specified and the value 
        must be appropriate to the value of attribute shape as defined by the 
        PUBS.XML Data Element Dictionary.
        
        Human Readable: Element ImageArea attribute coordinates and shape must be specified.  The value for attribute coordinates has to 
        follow the format for the designated shape as defined by the PUBS.XML Data Element Dictionary.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        If attribute coordinates or attribute shape are not specified or are
        specified with an empty value, then return false. 
        
        If the attribute shape is specified, then this rule uses a regular expression
        to make sure that the attribute coordinates is specified with an appropriate
        value from the PUBS.XML Data Element Dictionary, reproduced below for
        convenience:

        The number and order of values depends on the shape being defined. Possible combinations:
        - rect: left-x, top-y, right-x, bottom-y.
        - circle: center-x, center-y, radius. Note: When the radius value is a percentage value, 
        user agents should calculate the final radius value based on the associated object's width and height.
        The radius should be the smaller value of the two.
        - poly: x1, y1, x2, y2, ..., xN, yN. The first x and y coordinate pair and the last should be the 
        same to close the polygon. When these coordinate values are not the same, user agents should infer
        an additional coordinate pair to close the polygon.
        
        Coordinates are relative to the top, left corner of the object. All values are lengths. All values are separated by commas.
    </sch:p>
    
    <sch:rule id="PUBS-ID-00027-R1" context="pubs:ImageArea">
        <sch:let name="coordinatesAttr" value="normalize-space(string(@coordinates))"/>
        <sch:let name="shapeAttr" value="normalize-space(string(@shape))"/>
        <sch:let name="rectRegEx" value="'(-?[0-9]+,){3}-?[0-9]+$'"/>
        <sch:let name="circCoordinatesRegEx" value="'^(-?[0-9]+,){2}-?[0-9]+$'"/>
        <sch:let name="circPercentageRegEx" value="'^(-?[0-9]+,){2}(0|[1-9][1-9]?|100)%$'"/>
        <sch:let name="polyRegEx" value="'^((-?[0-9]+,){2})*-?[0-9]+,-?[0-9]+$'"/>
        
        <sch:assert test="             if(string-length($coordinatesAttr) = 0 or string-length($shapeAttr) = 0)             then false()             else                 if($shapeAttr='rect')                 then matches(string($coordinatesAttr),$rectRegEx)                 else                     if($shapeAttr='circ')                     then matches(string($coordinatesAttr),$circCoordinatesRegEx) or matches($coordinatesAttr,$circPercentageRegEx)                     else                         if($shapeAttr='poly')                         then matches(string($coordinatesAttr),$polyRegEx)                         else                             false()             " flag="error" role="error">
            [PUBS-ID-00027][Error]
            For element ImageArea attribute coordinates must be specified and the value 
            must be appropriate to the value of attribute shape as defined by the 
            PUBS.XML Data Element Dictionary.
            
            Human Readable: Element ImageArea attribute coordinates and shape must be specified.  The value for attribute coordinates has to 
            follow the format for the designated shape as defined by the PUBS.XML Data Element Dictionary.
        </sch:assert>
    </sch:rule>
</sch:pattern>