<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00001">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00001][Warning] For every optional element that exists in the 
        document and can have text content, the element should have non-null, 
        non-whitespace value.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic. The abstract rule
        first concatenates the text values within the given element, separated by a single 
        space. The resultant string is then normalized with leading and trailing 
        whitespace removed, and the length of the string is determined to be greater 
        than zero, which indicates non-whitespace content. The abstract rule is extended 
        once for each optional element in the PUBS schema.  
    </sch:p>
    
    <sch:rule abstract="true" id="abs.rule00001">
        <sch:assert test="normalize-space(string())" flag="warning" role="warning">
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule on optional elements -->

    
    <!-- mixed='true' -->

    <sch:rule id="PUBS-ID-00001-R2" context="pubs:AbbreviatedTitle">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R3" context="pubs:AttributionText">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R4" context="pubs:BiographicalSketch">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R5" context="pubs:Caption">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R6" context="pubs:CompilationTitle">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R7" context="pubs:Description">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R8" context="pubs:EmphasizedText">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R9" context="pubs:Footnote">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R10" context="pubs:Legend">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R11" context="pubs:Link">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R12" context="pubs:ListItem">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R13" context="pubs:Para">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R14" context="pubs:PreformattedText">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R15" context="pubs:SourceDescriptor">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R16" context="pubs:SourcedText">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R17" context="pubs:Subtitle">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R18" context="pubs:TextBox">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R19" context="pubs:Title">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R20" context="pubs:entry">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <!-- Extensions of RunningTextType -->

    <sch:rule id="PUBS-ID-00001-R21" context="pubs:NoteInline">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R22" context="pubs:Quote">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <!-- Things with Strings -->

    <sch:rule id="PUBS-ID-00001-R23" context="pubs:Abbreviation">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R24" context="pubs:Acronym">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R25" context="pubs:AddressLine">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R26" context="pubs:BibliographyEntry">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R27" context="pubs:City">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R28" context="pubs:ContactFor">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R29" context="pubs:CopyrightAttribution">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R30" context="pubs:DocumentID">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R31" context="pubs:EditionNumber">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R32" context="pubs:GenerationalQualifier">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R33" context="pubs:GivenName">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R34" context="pubs:GlossaryTerm">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R35" context="pubs:Honorific">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R36" context="pubs:IndexEntry">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R37" context="pubs:IssueNumber">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R38" context="pubs:JobTitle">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R39" context="pubs:MediaExtent">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R40" context="pubs:MilitaryRank">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R41" context="pubs:OfficeName">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R42" context="pubs:OriginalClassificationMarking">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R43" context="pubs:PersonalTitle">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R44" context="pubs:PostalCode">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R45" context="pubs:Province">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R46" context="pubs:SegmentLabel">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R47" context="pubs:SourceID">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R48" context="pubs:State">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R49" context="pubs:Subscript">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R50" context="pubs:Superscript">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R51" context="pubs:Surname">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R52" context="pubs:UUID">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R53" context="pubs:VolumeNumber">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R54" context="pubs:locatorLink">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <!-- extension of xsd:string -->

    <sch:rule id="PUBS-ID-00001-R55" context="pubs:Affiliation">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R56" context="pubs:AlternateFormat">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R57" context="pubs:CountryCode">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R58" context="pubs:EmailAddress">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R59" context="pubs:FaxNumber">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R60" context="pubs:FormattedSignatureBlock">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R61" context="pubs:InternalID">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R62" context="pubs:NetworkAddress">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R63" context="pubs:OtherProperty">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R64" context="pubs:PhoneNumber">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R65" context="pubs:PlaceName">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R66" context="pubs:ProductLine">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R67" context="pubs:Region">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R68" context="pubs:SubjectCategory">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R69" context="pubs:SubjectCode">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R70" context="pubs:UserID">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00001-R71" context="pubs:WebPageAddress">
        <sch:extends rule="abs.rule00001"/>
    </sch:rule>
    

    
</sch:pattern>