<?xml version="1.0" encoding="UTF-8"?>
<?ICEA abstractPattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<!--
    This abstract pattern checks to see if an attribute of an element exists in a list.

    $context     := the context in which the searchValue exists
    $searchTerm  := the value which you want to verify is in the list
    $list        := the list in which to search for the searchValue
    $errMsg      := the error message text to display when the assertion fails
    
    Example usage:
    <sch:pattern is-a="ValidateAttributeValueExistenceInList" id="PUBS_ID_00063" xmlns:sch="http://purl.oclc.org/dsdl/schematron">  
        <sch:param name="context" value="pubs:QuantityReference[@unitOfMeasureVocabulary='ISO4217-3']"/>
        <sch:param name="searchTerm" value="@unitOfMeasure"/>
        <sch:param name="list" value="$iso4217TrigraphList"/>
        <sch:param name="errMsg" value="'
            [PUBS-ID-00063][Error]
            If the element QuantityReference has the attribute unitOfMeasureVocabulary 
            with a value of ISO4217-3 the value of attribute unitOfMeasure must be 
            in CVEnumISO4217Trigraph.xml.
        '"/>
    </sch:pattern>
    
    Note: $iso4217TrigraphList is defined in the main document, PUBS_XML.xml.
-->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" abstract="true"
    id="ValidateValueExistenceInList">

    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc"> This abstract pattern checks to see if an attribute of an element
        exists in a list. $context := the context in which the searchValue exists. $searchTerm :=
        the value which should be verified is in the list. $list := the list in which to search for
        the searchValue. $errMsg := the error message text to display when the assertion
        fails.</sch:p>

    <sch:rule context="$context">
        <sch:assert
            test="             some $token in $list satisfies              compare($token,normalize-space($searchTerm)) = 0             "
            flag="error">
            <sch:value-of select="$errMsg"/>
        </sch:assert>
    </sch:rule>
</sch:pattern>
