<?xml version="1.0" encoding="UTF-8"?>
<?ICEA abstractPattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<!-- 
    $context := an xpath to an element containing a date
    $secondaryDateList := a list of dates in which the first entry is the date to compare to all other entries in the list
    $operator := the equality operator to use for comparing the dateTimes
    
    This abstract pattern compares the date contained within the param $context to each date 
    contained within the param $secondaryDateList (using the comparison operator 
    contained in param $operator) and makes sure that each comparison returns 
    true.

-->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" abstract="true" id="CompareDateTimes">

    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">This abstract pattern compares the date contained within the param
        $context to each date contained within the param $secondaryDateList (using the comparison
        operator contained in param $operator) and makes sure that each comparison returns
        true.</sch:p>

    <sch:rule context="$context">
        <sch:assert
            test="             if ($flag = 'warning')             then every $secondaryDate in $secondaryDateList satisfies                     dtf:compareDateTimeRanges(string(.), $operator, string($secondaryDate))             else true()             "
            flag="warning">
            <sch:value-of select="$ruleText"/>
        </sch:assert>
        <sch:assert
            test="             if ($flag = 'error')             then every $secondaryDate in $secondaryDateList satisfies                     dtf:compareDateTimeRanges(string(.), $operator, string($secondaryDate))                 else true()                 "
            flag="error">
            <sch:value-of select="$ruleText"/>
        </sch:assert>
    </sch:rule>
</sch:pattern>
