<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="SRC-ID-00006">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [SRC-ID-00006][Warning]
        For elements ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate, 
        if the time designator (T) is specified, it is recommended that time zone be specified.
        
        Human Readable: It is recommended that time zone be specified if time designator (T) is specified for the following elements:
        ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic.
        If the value of the context contains the time zone designator (T),
        then it makes sure that the value of the context matches the 
        regular expression for a date with a time zone specified.
        The abstract rule is extended once for each required element
        listed in rule SRC-ID-00006.
    </sch:p>
    
    <!-- Abstract rule for elements, which asserts that if the time designator (T) is specified, then the timezone is specified -->
    <sch:rule abstract="true" id="abs.rule00006">
      <sch:assert test="if (contains(string($valueTest),'T'))              then matches(string($valueTest),$endsWithTimeZoneRegEx)                 else true()"
          flag="warning" role="warning">
          [SRC-ID-00006][Warning]
          For element <sch:name/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designtor (T) is specified for the following elements:
          ApproximableDateTime, DatePublished, DateTimeReferenced, DateString, EarliestStartDate, LatestEndDate.
      </sch:assert>
    </sch:rule>
    
    <!-- Abstract rule for attributes, which asserts that if the time designator (T) is specified, then the timezone is specified -->
    <sch:rule abstract="true" id="abs.rule00006attrs">
        <sch:let name="fails"
               value="             for $date in $dateValues return             if(if (contains(string($date),'T'))             then matches(string($date),$endsWithTimeZoneRegEx)             else true()) then null else name($date)"/>
        <sch:assert test="count($fails)=0" flag="warning" role="warning">
            [SRC-ID-00006][Warning] For attribute(s):<sch:value-of select="for $each in $fails return concat(' ', string($each))"/> 
            if the time designator (T) is specified, it is recommended that the time zone be specified.
        </sch:assert>
    </sch:rule>
    

    <!-- Begin using abstract rule on required elements -->
    <sch:rule id="SRC-ID-00006-R3" context="src:ApproximableDateTime">
        <sch:let name="valueTest" value="."/>
        <sch:extends rule="abs.rule00006"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00006-R4" context="src:DatePublished">
        <sch:let name="valueTest" value="."/>
        <sch:extends rule="abs.rule00006"/>
    </sch:rule>
   
    <sch:rule id="SRC-ID-00006-R5" context="src:DateTimeReferenced">
        <sch:let name="valueTest" value="."/>
        <sch:extends rule="abs.rule00006"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00006-R6" context="src:DateString">
        <sch:let name="valueTest" value="."/>
        <sch:extends rule="abs.rule00006"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00006-R7" context="src:EarliestStartDate">
        <sch:let name="valueTest" value="."/>
        <sch:extends rule="abs.rule00006"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00006-R8" context="src:LatestEndDate">
        <sch:let name="valueTest" value="."/>
        <sch:extends rule="abs.rule00006"/>
    </sch:rule>
        
</sch:pattern>
