<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="SRC-ID-00010">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [SRC-ID-00010][Error]
        For elements: PersonalProfileGroup 
        at least one of the following child elements must have non-whitespace content: 
        Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
        
        Human Readable: PersonalProfileGroup must have a value for at least one of the following
        child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic. It
        normalizes the space of the value of the specified child elements
        and makes sure that the length of the resulting string is 
        greater than zero, which indicates non-whitespace content.
        
        Element PostalAddress cannot contain text content, so the rule counts the 
        number of its child elements that contain non-white space and makes sure
        that the count is great than 0.
    </sch:p>

    <!-- Abstract rule, which asserts that at least one of the listed child elements has non-whitespace content -->
    <sch:rule abstract="true" id="abs.rule00010">
        <sch:assert test="src:Surname[normalize-space(string(text()))]
            or src:UserID[normalize-space(string(text()))]
            or src:JobTitle[normalize-space(string(text()))]
            or src:Affiliation[normalize-space(string(text()))]
            or src:OfficeName[normalize-space(string(text()))]
            or src:PhoneNumber[normalize-space(string(text()))]
            or src:FaxNumber[normalize-space(string(text()))]
            or src:EmailAddress[normalize-space(string(text()))]
            or src:WebPageAddress[normalize-space(string(text()))]
            or src:FormattedSignatureBlock[normalize-space(string(text()))]
            or (some $token in src:PostalAddress/*/text() satisfies normalize-space(string($token)))             "
            flag="error" role="error">
            [SRC-ID-00010][Error]
            For element <sch:name/> at least one of the following child elements must have non-whitespace content:  
            Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
            
            Human Readable: Elements PersonalProfileGroup must have a value for at least one of the following
            child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, EmailAddress, WebPageAddress, FormattedSignatureBlock.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule to check required elements -->
    <sch:rule id="SRC-ID-00010-R2" context="src:AuthorInfo">
        <sch:extends rule="abs.rule00010"/>
    </sch:rule>
    
    <sch:rule id="SRC-ID-00010-R3" context="src:POCinfo">
        <sch:extends rule="abs.rule00010"/>
    </sch:rule>
    
</sch:pattern>
