<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00135">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00135][Error] DateInfoCutoff must be earlier than or equivalent to DateApproved and DatePublished.        
        
        Human Readable: DateInfoCutoff has to be less than or equal to DateApproved and DatePublished.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        For each irm:dates element which specifies attribute @irm:infoCutOff, 
        this rule ensures that the date specified in attribute @irm:infoCutOff is
        earlier than or equivalent to the date specified in attributes 
        irm:dates/@approvedOn and pubs:DatePublished.
    </sch:p>
    
    <sch:rule id="PUBS-ID-00135-R1" context="irm:ICResourceMetadataPackage/irm:dates[@irm:infoCutOff]">
        <sch:let name="secondaryDateList" value="(ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, @irm:approvedOn)"/>
        <sch:assert test="             every $secondaryDate in $secondaryDateList satisfies dtf:compareDateTimeRanges(string(@irm:infoCutOff), 
            '&lt;=', string($secondaryDate))" flag="warning" role="warning">
            [PUBS-ID-00135][Warning] irm:dates/@irm:infoCutOff must
            be earlier than or equivalent to irm:dates/@irm:approvedOn.
            
            Human Readable: DateInfoCutoff has to be less than or equal to DateApproved.
        </sch:assert>
    </sch:rule>
    
</sch:pattern>