<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00087">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00087][Error]
        If the DateInformation element exists, at least one of its child 
        elements DateString, ApproximableDateTime, or SearchableDateTime must be present.
        
        Human Readable: Element DateInformation must have a value for one of its child elements.
    </sch:p>

    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc"> 
        For element pubs:DateInformation, this rule ensures that one or more of the
        child elements DateString, ApproximableDateTime,
        SearchableDateTime/EarliestStartDate or SearchableDateTime/LatestEndDate
        is specified with a non-white space value.
    </sch:p>
    
    <sch:rule id="PUBS-ID-00087-R1" context="pubs:DateInformation">
        <sch:assert test="normalize-space(string(pubs:DateString)) or normalize-space(string(pubs:ApproximableDateTime)) or normalize-space(string(pubs:SearchableDateTime/pubs:EarliestStartDate)) or normalize-space(string(pubs:SearchableDateTime/pubs:LatestEndDate))" flag="error" role="error">
            [PUBS-ID-00087][Error]
            If the DateInformation element exists, at least one of its child 
            elements DateString, ApproximableDateTime, or SearchableDateTime must be present.
            
            Human Readable: Element DateInformation must have a value for one of its child elements.
        </sch:assert>
    </sch:rule>
</sch:pattern>