<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00065">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00065][Error]
        For elements: AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo 
        at least one of the following child elements must have non-whitespace content: 
        Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
        EmailAddress, WebPageAddress, FormattedSignatureBlock.
        
        Human Readable: Elements AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo must have a value for at least one of the following
        child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
        EmailAddress, WebPageAddress, FormattedSignatureBlock.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic. It
        normalizes the space of the value of the specified child elements
        and makes sure that the length of the resulting string is 
        greater than zero, which indicates non-whitespace content.
        
        Element PostalAddress cannot contain text content, so the rule counts the 
        number of its child elements that contain non-white space and makes sure
        that the count is great than 0.
        
        The abstract rule is extended once for each required element in 
        rule PUBS_ID_00065.
    </sch:p>

    <!-- Abstract rule, which asserts that at least one of the listed child elements has non-whitespace content -->

    <sch:rule abstract="true" id="abs.rule00065">
        <sch:assert test="pubs:Surname[normalize-space(string(text()))]             or pubs:UserID[normalize-space(string(text()))]             or pubs:JobTitle[normalize-space(string(text()))]             or pubs:Affiliation[normalize-space(string(text()))]             or pubs:OfficeName[normalize-space(string(text()))]             or pubs:PhoneNumber[normalize-space(string(text()))]             or pubs:FaxNumber[normalize-space(string(text()))]             or pubs:EmailAddress[normalize-space(string(text()))]             or pubs:WebPageAddress[normalize-space(string(text()))]             or pubs:FormattedSignatureBlock[normalize-space(string(text()))]                   or (some $token in pubs:PostalAddress/*/text() satisfies                      normalize-space(string($token)))             " flag="error" role="error">
            [PUBS-ID-00065][Error]
            For element <sch:name/> at least one of the following child elements must have non-whitespace content:  
            Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
            
            Human Readable: Elements AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo must have a value for at least one of the following
            child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule to check required elements -->

    <sch:rule id="PUBS-ID-00065-R2" context="pubs:AuthorInfo">
        <sch:extends rule="abs.rule00065"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00065-R3" context="pubs:CoauthorInfo">
        <sch:extends rule="abs.rule00065"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00065-R4" context="pubs:ContributingAuthorInfo">
        <sch:extends rule="abs.rule00065"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00065-R5" context="pubs:POCinfo">
        <sch:extends rule="abs.rule00065"/>
    </sch:rule>
    
</sch:pattern>