<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00042">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">        
        [PUBS-ID-00042][Error]
        The permissible values for the year range are 0001 through 9999 for element
        DateTimeReferenced, and attributes date, dateTime, normalizedDate and normalizedDateTime.
        
        Human Readable: Year values for element DateTimeReferenced, and attributes date, dateTime, 
        normalizedDate and normalizedDateTime have to fall within the range 0001 through 9999.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses abstract rules to consolidate logic. For elements, 
        this rule ensures that the date contained within $dateValue has a year
        value within the range $minYear and $maxYear, inclusive. For attributes, 
        this rule ensures that each date contained within $dateList has a year value
        within the range $minYear and $maxYear, inclusive.
    </sch:p>
    
    <!-- Use abstract rule to handle required elements -->
    
    <sch:rule id="PUBS-ID-00042-R1" context="pubs:DateTimeReferenced">
        <sch:let name="minYear" value="0001"/>
        <sch:let name="maxYear" value="9999"/>
        <sch:let name="dateValue" value="."/>
        <sch:let name="errMsg" value="'             [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999 for element DateTimeReferenced.             '"/>
        <sch:extends rule="abs.dateYearRangeRule"/>
    </sch:rule>

	  <!-- Use abstract rule to handle required attributes -->

	  <sch:rule id="PUBS-ID-00042-R2" context="pubs:*[@date]">
		    <sch:let name="minYear" value="0001"/>
	        <sch:let name="maxYear" value="9999"/>
	        <sch:let name="dateValue" value="./@date"/>
		    <sch:let name="errMsg" value="'    [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999    for attributes date.    '"/>
	      <sch:extends rule="abs.dateYearRangeRule"/>
	  </sch:rule>
    
    <sch:rule id="PUBS-ID-00042-R3" context="cem:*[@cem:dateTime]">
        <sch:let name="minYear" value="0001"/>
        <sch:let name="maxYear" value="9999"/>
        <sch:let name="dateValue" value="./@cem:dateTime"/>
        <sch:let name="errMsg" value="'    [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999    for attributes dateTime.    '"/>
        <sch:extends rule="abs.dateYearRangeRule"/>
    </sch:rule>
     
    <sch:rule id="PUBS-ID-00042-R4" context="cem:*[@cem:normalizedDate]">
        <sch:let name="minYear" value="0001"/>
        <sch:let name="maxYear" value="9999"/>
        <sch:let name="dateValue" value="./@cem:normalizedDate"/>
        <sch:let name="errMsg" value="'    [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999    for attributes normalizedDate.    '"/>
        <sch:extends rule="abs.dateYearRangeRule"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00042-R5" context="cem:*[@cem:normalizedDateTime]">
        <sch:let name="minYear" value="0001"/>
        <sch:let name="maxYear" value="9999"/>
        <sch:let name="dateValue" value="./@cem:normalizedDateTime"/>
        <sch:let name="errMsg" value="'    [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999    for attributes normalizedDateTime.    '"/>
        <sch:extends rule="abs.dateYearRangeRule"/>
    </sch:rule>
</sch:pattern>