<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00036">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00036][Error]
        Internal links must be traversable. If the attribute xlink:href value for elements Link and ImageArea 
        is a URL fragment identifier with a [#] prefix, that fragment identifier must match the attribute id 
        value of an element within the XML instance. Note that a fragment identifier is characterized by 
        a [#] prefix. The [#] prefix is not part of the fragment identifier. So when the xlink:href attribute 
        value starts with a [#], the remainder of the value is the fragment identifier. This rule does not apply 
        to attribute values which contain a URL and a fragment identifier separated by [#], in which case it can 
        not be determined with certainty that the target is within the XML instance.
        
        Human Readable: If the elements Link and ImageArea attribute xlink:href value starts with [#], then 
        the fragment identifier portion of the value of attribute xlink:href must match 
        the value of any attribute id specified within the XML instance.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic.
        If the current element has attribute xlink:href specified with a value starting with [#], then 
        this rule ensures that the fragment identifier portion of the value of attribute xlink:href matches 
        the value of any attribute id specified within the XML instance. If the current element
        has attribute xlink:href specified with a value that does not start with [#], then this
        rule does not apply and this rule returns true.
    </sch:p>
    
    <!-- Abstract rule definition -->

    
    <sch:rule abstract="true" id="abs.rule00036">
        <sch:let name="fragementIdentifier" value="substring(@xlink:href,2)"/>
        <sch:assert test="if(starts-with(@xlink:href,'#'))                then ancestor::tdf:TrustedDataObject//*[@id=$fragementIdentifier]                   else true()             " flag="error" role="error">
            [PUBS-ID-00036][Error]
            Internal links must be traversable. If the attribute xlink:href value for elements Link and ImageArea 
            is a URL fragment identifier with a [#] prefix, that fragment identifier must match the attribute id 
            value of an element within the XML instance. Note that a fragment identifier is characterized by 
            a [#] prefix. The [#] prefix is not part of the fragment identifier. So when the xlink:href attribute 
            value starts with a [#], the remainder of the value is the fragment identifier. This rule does not apply 
            to attribute values which contain a URL and a fragment identifier separated by [#], in which case it can 
            not be determined with certainty that the target is within the XML instance.
            
            Human Readable: If the elements Link and ImageArea attribute xlink:href value starts with [#], then 
            the fragment identifier portion of the value of attribute xlink:href must match 
            the value of any attribute id specified within the XML instance.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule to check required elements -->

    
    <sch:rule id="PUBS-ID-00036-R2" context="pubs:Link">
        <sch:extends rule="abs.rule00036"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00036-R3" context="pubs:ImageArea">
        <sch:extends rule="abs.rule00036"/>
    </sch:rule>

</sch:pattern>