<?xml version="1.0" encoding="UTF-8"?>
<!--UNCLASSIFIED--><?ICEA master?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<!-- WARNING: 
    Once compiled into an XSLT the result will 
    be the aggregate classification of all the CVES 
    and included .sch files
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron"
            xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            queryBinding="xslt2">
	<!-- ************************** -->
	<!-- * Namespace declarations * -->
	<!-- ************************** -->
	<sch:ns uri="urn:us:gov:ic:pubs" prefix="pubs"/>
	  <sch:ns uri="urn:us:gov:ic:cem" prefix="cem"/>
	  <sch:ns uri="urn:us:gov:ic:icgenc" prefix="genc"/>
	  <sch:ns uri="urn:us:gov:ic:edh" prefix="edh"/>
	  <sch:ns uri="urn:us:gov:ic:src" prefix="src"/>
	  <sch:ns uri="urn:us:gov:ic:cve" prefix="cve"/>
	  <sch:ns uri="http://www.w3.org/1999/xlink" prefix="xlink"/>
	  <sch:ns uri="urn:us:gov:ic:ism" prefix="ism"/>
	  <sch:ns uri="urn:us:gov:ic:irm" prefix="irm"/>
	  <sch:ns uri="urn:us:gov:ic:tdf" prefix="tdf"/>
	  <sch:ns uri="urn:us:mil:ces:metadata:ddms:5" prefix="ddms"/>
	  <sch:ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
	  <sch:ns uri="http://www.w3.org/1999/XSL/Transform" prefix="xsl"/>
	  <sch:ns uri="date:time:function" prefix="dtf"/>
	  <sch:ns uri="urn:us:gov:ic:intdis" prefix="intdis"/>
	  <sch:ns uri="urn:us:gov:ic:mime" prefix="mime"/>
	  <sch:ns uri="urn:us:gov:ic:virt" prefix="virt"/>
	
	  <!-- ************************************** -->
	<!-- * Abstract Rule and Pattern Includes * -->
	<!-- ************************************** -->
	<sch:include href="./Lib/CompareDateTimes.sch"/>
	  <sch:include href="./Lib/DateYearRangeRule.sch"/>
	  <sch:include href="./Lib/DateListYearRangeRule.sch"/>
	  <sch:include href="./Lib/ValidateValidationEnvCVE.sch"/>
	  <sch:include href="./Lib/ValidateValidationEnvSchema.sch"/>
	  <sch:include href="./Lib/ValidateValueExistenceInList.sch"/>
	
	  <!-- **************************** -->
	<!-- * General Global Variables * -->
	<!-- **************************** -->
	<sch:let name="GMTTimeZoneOffset" value="'PT0H'"/>
	  <sch:let name="currentYear"
            value="year-from-dateTime(adjust-dateTime-to-timezone(current-dateTime(), xs:dayTimeDuration($GMTTimeZoneOffset)))"/>
	  <sch:let name="timeZoneRegEx" value="'Z|[\+-]\d{2}:\d{2}'"/>
	  <sch:let name="endsWithTimeZoneRegEx" value="concat('^.*',$timeZoneRegEx,'$')"/>
	  <sch:let name="startDateTimeTemplate" value="'0001-01-01T00:00:00.000'"/>
	  <sch:let name="endDateTimeTemplate" value="'9999-12-01T23:59:59.999'"/>
	  <sch:let name="defaultTimeZone" value="'Z'"/>
	  <sch:let name="gYearRegEx" value="'^\d{4}(Z|[\+-]\d{2}:\d{2})?$'"/>
	  <sch:let name="gYearMonthRegEx" value="'^\d{4}-\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>
	  <sch:let name="dateRegEx" value="'^\d{4}-\d{2}-\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>
	  <sch:let name="dateHourMinTypeRegEx"
            value="'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>
	  <sch:let name="dateTimeRegEx"
            value="'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d{1,3})?(Z|[\+-]\d{2}:\d{2})?$'"/>
	  <!-- ******************** -->
	<!-- * List Definitions * -->
	<!-- ******************** -->
	  <sch:let name="countryIso3166TrigraphList"
            value="document('../../CVE/PUBS/CVEnumPubsCountryISO3166Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
	  <sch:let name="iso639-2TrigraphList"
            value="document('../../CVE/PUBS/CVEnumISO639-2Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
	  <sch:let name="iso639-3TrigraphList"
            value="document('../../CVE/PUBS/CVEnumISO639-3Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
	  <sch:let name="iso639DigraphList"
            value="document('../../CVE/PUBS/CVEnumISO639Digraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
	  <sch:let name="unce20UnitsOfMeasureList"
            value="document('../../CVE/PUBS/CVEnumUNCE20UnitsOfMeasure.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
	  <sch:let name="iso4217TrigraphList"
            value="document('../../CVE/PUBS/CVEnumISO4217Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
	  <sch:let name="iso4217NumericList"
            value="document('../../CVE/PUBS/CVEnumISO4217Numeric.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
	  <sch:let name="compoundLanguageQualifierTypeList"
            value="document('../../CVE/IRM/CVEnumIRMCompoundLanguageQualifierType.xml')//cve:Value"/>
	  <!-- ************************************* -->
	<!-- * Custom XSLT2 Function Definitions * -->
	<!-- ************************************* -->
	<!--
     Returns value of pubs:ISO8601DateTimeType, pubs:dateTime, 
     cem:ISO8601DateTimeType, cem:ISO8601DateType, cem:dateTimesType adjusted to GMT timezone.
   -->
	<xsl:function name="dtf:adjust-CombinedDate-to-GMT-timezone" as="xs:string">
		    <xsl:param name="combinedDate" as="xs:string"/>
		    <xsl:choose>
			      <xsl:when test="matches($combinedDate, $timeZoneRegEx)">
				        <xsl:choose>
					          <xsl:when test="matches($combinedDate, $dateRegEx)">
						            <xsl:value-of select="adjust-date-to-timezone(xs:date($combinedDate), xs:dayTimeDuration($GMTTimeZoneOffset))"/>
					          </xsl:when>
					          <xsl:when test="matches($combinedDate, $dateHourMinTypeRegEx)">
						            <xsl:variable name="zeroSecondsPadding" select="':00'"/>
						            <xsl:variable name="combinedDatePadWithSeconds"
                                select="concat(substring($combinedDate, 1, 16), $zeroSecondsPadding, substring($combinedDate, 17))"/>
						            <xsl:value-of select="adjust-dateTime-to-timezone(xs:dateTime($combinedDatePadWithSeconds), xs:dayTimeDuration($GMTTimeZoneOffset))"/>
					          </xsl:when>
					          <xsl:when test="matches($combinedDate, $dateTimeRegEx)">
						            <xsl:value-of select="adjust-dateTime-to-timezone(xs:dateTime($combinedDate), xs:dayTimeDuration($GMTTimeZoneOffset))"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="$combinedDate"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$combinedDate"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
	  <!--
		Returns the maximum day of the month for an xs:dateTime as an xs:string.
		@param {xs:dateTime} date The date time from which to get the month
		@returns {xs:string} String representation of the maximum day of the month
	-->
	<xsl:function name="dtf:getMaxDay" as="xs:string">
		    <xsl:param name="date" as="xs:dateTime"/>
		    <xsl:variable name="month" select="number(dtf:getMonth(string($date)))"/>
		    <xsl:choose>
			      <xsl:when test="$month = (1, 3, 5, 7, 8, 10, 12)">
				        <xsl:value-of select="31"/>
			      </xsl:when>
			      <xsl:when test="$month = (4, 6, 9, 11)">
				        <xsl:value-of select="30"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:choose>
					          <xsl:when test="dtf:isLeapYear(string($date))">
						            <xsl:value-of select="29"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="28"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
	  <!--
		@param {xs:date} date String representation of a date
		@returns {xs:boolean} Returns true if the date provided occurs in a 
		    leap year; otherwise returns false.
	-->
	<xsl:function name="dtf:isLeapYear" as="xs:boolean">
		    <xsl:param name="date" as="xs:string"/>
		    <xsl:variable name="year" as="xs:integer" select="xs:integer(dtf:getYear($date))"/>
		    <xsl:choose>
			      <xsl:when test="$year mod 100 = 0">
				        <xsl:choose>
					          <xsl:when test="$year mod 400 = 0">
						            <xsl:value-of select="true()"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:choose>
					          <xsl:when test="$year mod 4 = 0">
						            <xsl:value-of select="true()"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
	  <!--
		Replaces the day portion of the provided dateTime with the new day provided.
		@param {xs:dateTime} dateTime An xs:dateTime to be updated with new day.
		@param {xs:string} newDayString String representation of day portion of a date.
		@returns {xs:dateTime} Returns new xs:dateTime with updated day portion. 
		leap year; otherwise returns false.
	-->
	<xsl:function name="dtf:replaceDateTimeDay" as="xs:dateTime">
		    <xsl:param name="dateTime" as="xs:dateTime"/>
		    <xsl:param name="newDayString" as="xs:string"/>
		    <xsl:variable name="beforeDay" select="substring(string($dateTime), 1, 8)"/>
		    <xsl:variable name="afterDay" select="substring(string($dateTime), 11)"/>
		    <xsl:value-of select="concat($beforeDay, $newDayString, $afterDay)"/>
	  </xsl:function>
	  <!--
		Returns a string representation of the year portion of the date
		represented by the provided string.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of the year portion of the 
		    date represented by the provided string.
	-->
	<xsl:function name="dtf:getYear" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 1, 4)"/>
	  </xsl:function>
	  <!--
		Returns a string representation of the month portion of the date
		represented by the provided string.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of the month portion of the 
		date represented by the provided string.
	-->
	<xsl:function name="dtf:getMonth" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 6, 2)"/>
	  </xsl:function>
	  <!--
		Returns a string representation of the day portion of the date
		represented by the provided string.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of the day portion of the 
		date represented by the provided string.
	-->
	<xsl:function name="dtf:getDay" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 9, 2)"/>
	  </xsl:function>
	  <!--
		Returns a string representation of the timezone portion of the date
		represented by the provided string.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of the timezone portion of
		    the date represented by the provided string.
	-->
	<xsl:function name="dtf:getTimeZone" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="dateTimeEndingWithTimezone"
                    as="xs:string"
                    select="concat('^.*(', $timeZoneRegEx, ')$')"/>
		    <xsl:choose>
			      <xsl:when test="matches($dateString, $dateTimeEndingWithTimezone)">
				        <xsl:value-of select="replace($dateString, $dateTimeEndingWithTimezone, '$1')"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$defaultTimeZone"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
	  <!--
		Returns true if the year portion of the date represented by the provided
		string contains four (4) digits; otherwise returns false.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} true if the year portion of the date represented by
		    the provided string contains four (4) digits; otherwise returns false.
	-->
	<xsl:function name="dtf:yearPortionHasFourDigits" as="xs:boolean">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="dateWithOnlyFourDigitYearAndOptionalTimeZoneRegEx"
                    as="xs:string"
                    select="concat('^\d{4}(', $timeZoneRegEx, ')?$')"/>
		    <xsl:variable name="dateStartingWithFourDigitYearRegEx"
                    as="xs:string"
                    select="'^\d{4}-.*$'"/>
		    <xsl:value-of select="matches($dateString, $dateWithOnlyFourDigitYearAndOptionalTimeZoneRegEx) or matches($dateString, $dateStartingWithFourDigitYearRegEx)"/>
	  </xsl:function>
	  <!--
		Removes the timezone portion of the date represented by the provided
		string and returns all remaining portions.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of a date without a timezone
		    portion.
	-->
	<xsl:function name="dtf:removeTimeZone" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="replace($dateString, $timeZoneRegEx, '')"/>
	  </xsl:function>
	  <!--
		Uses the template provided to fill in missing portions of the string
		representation of a dateTime provided and returns a full xs:dateTime.
		The dateString provided must not contain a timezone.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@param {xs:string} dateTemplateString String template of a default date
		    from which to pad missing portions of the dateString parameter.
		@returns {xs:dateTime} An xs:dateTime represented by the string date provided.
	-->
	<xsl:function name="dtf:padDateTimeWithTemplate" as="xs:dateTime">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:param name="dateTemplateString" as="xs:string"/>
		    <xsl:value-of select="concat($dateString, substring($dateTemplateString, string-length(normalize-space($dateString)) + 1))"/>
	  </xsl:function>
	  <!--
                Returns true if the string provided represents an allowable dateTime
                format; false, otherwise. The allowable dateTime formats are defined
                in the DES for the PUBS.XML specification.
                @returns {xs:boolean} Returns true if the string provided represents an 
                    allowable dateTime format; false, otherwise. 
        -->
	<xsl:function name="dtf:isAllowableDateTimeFormat" as="xs:boolean">
		    <xsl:param name="input" as="xs:string"/>
		    <xsl:variable name="trimmedInput" as="xs:string" select="normalize-space($input)"/>
		    <xsl:value-of select=" matches($trimmedInput, $gYearRegEx) or matches($trimmedInput, $gYearMonthRegEx) or matches($trimmedInput, $dateRegEx) or matches($trimmedInput, $dateHourMinTypeRegEx) or matches($trimmedInput, $dateTimeRegEx)"/>
	  </xsl:function>
	  <!--
		Returns the earlist xs:dateTime possible for the provided string
		representation of a dateTime. Fills in missing portions of the 
		dateTime with the earliest possible values. Default values for missing
		portions:
		MM = 01
		DD = 01
		hh = 00
		mm = 00
		ss = 00
		s  = 000
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:dateTime} The earliest xs:dateTime possible for the 
		    provided string representation of a dateTime.
	-->
	<xsl:function name="dtf:startDate" as="xs:dateTime">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="timeZonePortion" select="dtf:getTimeZone($dateString)"/>
		    <xsl:variable name="dateTimePortion" select="dtf:removeTimeZone($dateString)"/>
		    <xsl:variable name="outputDate"
                    select="dtf:padDateTimeWithTemplate($dateTimePortion, $startDateTimeTemplate)"/>
		    <xsl:value-of select="concat($outputDate, $timeZonePortion)"/>
	  </xsl:function>
	  <!--
		Returns the latest xs:dateTime possible for the provided string
		representation of a dateTime. Fills in missing portions of the 
		dateTime with the latest possible values. Default values for missing
		portions:
		MM = 12
		DD = maximum day of the month
		hh = 23
		mm = 59
		ss = 59
		s  = 999
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:dateTime} The latest xs:dateTime possible for the 
		    provided string representation of a dateTime.
	-->
	<xsl:function name="dtf:endDate" as="xs:dateTime">
		    <xsl:param name="input" as="xs:string"/>
		    <xsl:variable name="timeZonePortion" select="dtf:getTimeZone($input)"/>
		    <xsl:variable name="dateTimePortion" select="dtf:removeTimeZone($input)"/>
		    <xsl:variable name="outputDate"
                    select="dtf:padDateTimeWithTemplate($dateTimePortion, $endDateTimeTemplate)"/>
		    <xsl:variable name="outputWithCorrectedDay"
                    select="dtf:replaceDateTimeDay($outputDate, dtf:getMaxDay($outputDate))"/>
		    <xsl:choose>
			      <xsl:when test="dtf:getDay($input)">
				        <xsl:value-of select="concat($outputDate, $timeZonePortion)"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="concat($outputWithCorrectedDay, $timeZonePortion)"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
	  <!--
		Calculates the date range implied for both primary and secondary and 
		determines if there is any overlap between the two ranges. Overlap is
		defined as the start of primary date range less than or equal to the 
		end of secondary date range, inclusive, and the start of the secondary
		date range less than or equal to the end of the primary date range.
		Returns true if there is any overlap; otherwise, returns false.
		@param {xs:string} primary String representation of a date in one
		    of the allowable formats.
		@param {xs:string} secondary String representation of a date in one
		    of the allowable formats.
		@returns {xs:boolean} Returns true if the date ranges implied by primary 
		    and secondary overlap at all; otherwise, returns false.
	-->
	<xsl:function name="dtf:overlaps" as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryStart"
                    as="xs:dateTime"
                    select="dtf:startDate($primary)"/>
		    <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
		    <xsl:variable name="secondaryStart"
                    as="xs:dateTime"
                    select="dtf:startDate($secondary)"/>
		    <xsl:variable name="secondaryEnd"
                    as="xs:dateTime"
                    select="dtf:endDate($secondary)"/>
		    <xsl:value-of select="$primaryStart &lt;= $secondaryEnd and $secondaryStart &lt;= $primaryEnd"/>
	  </xsl:function>
	  <!--
		Determines if the date range implied by the string representation in 
		primary is strictly before the date range implied by the string
		representation in secondary. Returns true if the end of the date
		range implied by primary is less than the start of the date range
		implied by secondary; otherwise, returns false.
		@param {xs:string} primary String representation of a date in one
		    of the allowable formats.
		@param {xs:string} secondary String representation of a date in one
		    of the allowable formats.
		@returns {xs:boolean} Returns true if the date range implied by primary 
		    is stricly earlier than the date range implied by secondary; otherwise,
		    returns false.
	-->
	<xsl:function name="dtf:isBefore" as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
		    <xsl:variable name="secondaryStart"
                    as="xs:dateTime"
                    select="dtf:startDate($secondary)"/>
		    <xsl:value-of select="$primaryEnd &lt; $secondaryStart"/>
	  </xsl:function>
	  <!--
		Determines if the date range implied by the string representation in 
		primary is strictly after the date range implied by the string
		representation in secondary. Returns true if the end of the date
		range implied by primary is less than the start of the date range
		implied by secondary; otherwise, returns false.
		@param {xs:string} primary String representation of a date in one
		    of the allowable formats.
		@param {xs:string} secondary String representation of a date in one
		    of the allowable formats.
		@returns {xs:boolean} Returns true if the date range implied by primary 
		    is stricly later than the date range implied by secondary; otherwise,
		    returns false.
	-->
	<xsl:function name="dtf:isAfter" as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryStart"
                    as="xs:dateTime"
                    select="dtf:startDate($primary)"/>
		    <xsl:variable name="secondaryEnd"
                    as="xs:dateTime"
                    select="dtf:endDate($secondary)"/>
		    <xsl:value-of select="$secondaryEnd &lt; $primaryStart"/>
	  </xsl:function>
	  <!--
		Determines if the date range implied by the string representation in 
		primary satisfies the comparison to the date range implied by secondary
		using the provided comparison operator; otherwise, returns false.
		
		Both primary and secondary must be in one of the allowable formats
		and represent dates with four digits in the year portion.
		@param {xs:string} primary String representation of a date in one
		    of the allowable formats.
		@param {xs:string} secondary String representation of a date in one
		    of the allowable formats.
		@returns {xs:boolean} Returns true if the date range implied by primary 
		    satisfies the comparison to the date range implied by secondary using
		    the provided comparison operator; otherwise, returns false.
	-->
	<xsl:function name="dtf:compareDateTimeRanges" as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="operator" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryAndSecondayYearPortionsHaveFourDigits"
                    as="xs:boolean"
                    select="dtf:yearPortionHasFourDigits($primary) and dtf:yearPortionHasFourDigits($secondary)"/>
		    <xsl:choose>
			      <xsl:when test="$primaryAndSecondayYearPortionsHaveFourDigits">
				        <xsl:variable name="primaryStart"
                          as="xs:dateTime"
                          select="dtf:startDate($primary)"/>
				        <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
				        <xsl:variable name="secondaryStart"
                          as="xs:dateTime"
                          select="dtf:startDate($secondary)"/>
				        <xsl:variable name="secondaryEnd"
                          as="xs:dateTime"
                          select="dtf:endDate($secondary)"/>
				        <xsl:choose>
					<!-- 'Less Than' Edge Case -->
					<!-- 2010-01-01T00:00:00.000Z < 2010 -->
					<xsl:when test="($operator = 'lt' or $operator = '&lt;') and (($primaryStart = $primaryEnd and $primaryStart = $secondaryStart) or ($primaryStart = $primaryEnd and $primaryStart = $secondaryEnd) or ($secondaryStart = $secondaryEnd and $primaryStart = $secondaryStart))">
						            <xsl:value-of select="false()"/>
					          </xsl:when>
					          <!-- 'Greater Than' Edge Case -->
					<!-- 2010-12-31T23:59:59.999Z > 2010 -->
					<xsl:when test="($operator = 'gt' or $operator = '&gt;') and (($primaryStart = $primaryEnd and $primaryEnd = $secondaryEnd) or ($primaryStart = $primaryEnd and $primaryEnd = $secondaryStart) or ($secondaryStart = $secondaryEnd and $primaryEnd = $secondaryEnd))">
						            <xsl:value-of select="false()"/>
					          </xsl:when>
					          <!-- 'Less Than' and 'Less Than or Equal' -->
					<xsl:when test="$operator = 'lt' or $operator = '&lt;' or $operator = '&lt;='">
						            <xsl:value-of select="dtf:isBefore($primary, $secondary) or dtf:overlaps($primary, $secondary)"/>
					          </xsl:when>
					          <!-- 'Greater Than' and 'Greater Than or Equal' -->
					<xsl:when test="$operator = 'gt' or $operator = '&gt;' or $operator = '&gt;='">
						            <xsl:value-of select="dtf:isAfter($primary, $secondary) or dtf:overlaps($primary, $secondary)"/>
					          </xsl:when>
					          <!-- Default to false() -->
					<xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="false()"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>

   <!--****************************-->
<!-- (U) PUBS ID Rules -->
<!--****************************-->

<!--(U) -->
   <sch:include href="./Rules/PUBS_ID_00001.sch"/>
   <sch:include href="./Rules/PUBS_ID_00003.sch"/>
   <sch:include href="./Rules/PUBS_ID_00008.sch"/>
   <sch:include href="./Rules/PUBS_ID_00009.sch"/>
   <sch:include href="./Rules/PUBS_ID_00017.sch"/>
   <sch:include href="./Rules/PUBS_ID_00027.sch"/>
   <sch:include href="./Rules/PUBS_ID_00028.sch"/>
   <sch:include href="./Rules/PUBS_ID_00030.sch"/>
   <sch:include href="./Rules/PUBS_ID_00031.sch"/>
   <sch:include href="./Rules/PUBS_ID_00032.sch"/>
   <sch:include href="./Rules/PUBS_ID_00033.sch"/>
   <sch:include href="./Rules/PUBS_ID_00034.sch"/>
   <sch:include href="./Rules/PUBS_ID_00035.sch"/>
   <sch:include href="./Rules/PUBS_ID_00036.sch"/>
   <sch:include href="./Rules/PUBS_ID_00040.sch"/>
   <sch:include href="./Rules/PUBS_ID_00042.sch"/>
   <sch:include href="./Rules/PUBS_ID_00045.sch"/>
   <sch:include href="./Rules/PUBS_ID_00046.sch"/>
   <sch:include href="./Rules/PUBS_ID_00047.sch"/>
   <sch:include href="./Rules/PUBS_ID_00048.sch"/>
   <sch:include href="./Rules/PUBS_ID_00049.sch"/>
   <sch:include href="./Rules/PUBS_ID_00050.sch"/>
   <sch:include href="./Rules/PUBS_ID_00053.sch"/>
   <sch:include href="./Rules/PUBS_ID_00054.sch"/>
   <sch:include href="./Rules/PUBS_ID_00062.sch"/>
   <sch:include href="./Rules/PUBS_ID_00063.sch"/>
   <sch:include href="./Rules/PUBS_ID_00064.sch"/>
   <sch:include href="./Rules/PUBS_ID_00065.sch"/>
   <sch:include href="./Rules/PUBS_ID_00070.sch"/>
   <sch:include href="./Rules/PUBS_ID_00072.sch"/>
   <sch:include href="./Rules/PUBS_ID_00079.sch"/>
   <sch:include href="./Rules/PUBS_ID_00080.sch"/>
   <sch:include href="./Rules/PUBS_ID_00082.sch"/>
   <sch:include href="./Rules/PUBS_ID_00086.sch"/>
   <sch:include href="./Rules/PUBS_ID_00087.sch"/>
   <sch:include href="./Rules/PUBS_ID_00092.sch"/>
   <sch:include href="./Rules/PUBS_ID_00093.sch"/>
   <sch:include href="./Rules/PUBS_ID_00096.sch"/>
   <sch:include href="./Rules/PUBS_ID_00097.sch"/>
   <sch:include href="./Rules/PUBS_ID_00098.sch"/>
   <sch:include href="./Rules/PUBS_ID_00099.sch"/>
   <sch:include href="./Rules/PUBS_ID_00100.sch"/>
   <sch:include href="./Rules/PUBS_ID_00101.sch"/>
   <sch:include href="./Rules/PUBS_ID_00103.sch"/>
   <sch:include href="./Rules/PUBS_ID_00104.sch"/>
   <sch:include href="./Rules/PUBS_ID_00111.sch"/>
   <sch:include href="./Rules/PUBS_ID_00113.sch"/>
   <sch:include href="./Rules/PUBS_ID_00114.sch"/>
   <sch:include href="./Rules/PUBS_ID_00115.sch"/>
   <sch:include href="./Rules/PUBS_ID_00116.sch"/>
   <sch:include href="./Rules/PUBS_ID_00117.sch"/>
   <sch:include href="./Rules/PUBS_ID_00118.sch"/>
   <sch:include href="./Rules/PUBS_ID_00119.sch"/>
   <sch:include href="./Rules/PUBS_ID_00120.sch"/>
   <sch:include href="./Rules/PUBS_ID_00121.sch"/>
   <sch:include href="./Rules/PUBS_ID_00123.sch"/>
   <sch:include href="./Rules/PUBS_ID_00124.sch"/>
   <sch:include href="./Rules/PUBS_ID_00127.sch"/>
   <sch:include href="./Rules/PUBS_ID_00128.sch"/>
   <sch:include href="./Rules/PUBS_ID_00129.sch"/>
   <sch:include href="./Rules/PUBS_ID_00130.sch"/>
   <sch:include href="./Rules/PUBS_ID_00131.sch"/>
   <sch:include href="./Rules/PUBS_ID_00132.sch"/>
   <sch:include href="./Rules/PUBS_ID_00133.sch"/>
   <sch:include href="./Rules/PUBS_ID_00134.sch"/>
   <sch:include href="./Rules/PUBS_ID_00135.sch"/>

   <!--****************************-->
<!-- (U) PUBS Phases -->
<!--****************************--></sch:schema>
<!--UNCLASSIFIED-->
