<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="SRC-ID-00007">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [SRC-ID-00007][Error]
        If the DateInformation element exists, at least one of its child 
        elements DateString, ApproximableDateTime, or SearchableDateTime must be present.
        
        Human Readable: Element DateInformation must have a value for one of its child elements.
    </sch:p>

    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc"> 
        For element src:DateInformation, this rule ensures that one or more of the
        child elements DateString, ApproximableDateTime,
        SearchableDateTime/EarliestStartDate or SearchableDateTime/LatestEndDate
        is specified with a non-white space value.
    </sch:p>
    
    <sch:rule id="SRC-ID-00007-R1" context="src:DateInformation">
        <sch:assert test="normalize-space(string(src:DateString)) or normalize-space(string(src:ApproximableDateTime)) or normalize-space(string(src:SearchableDateTime/src:EarliestStartDate)) or normalize-space(string(src:SearchableDateTime/src:LatestEndDate))"
            flag="error" role="error">
            [SRC-ID-00007][Error]
            If the DateInformation element exists, at least one of its child 
            elements DateString, ApproximableDateTime, or SearchableDateTime must be present.
            
            Human Readable: Element DateInformation must have a value for one of its child elements.
        </sch:assert>
    </sch:rule>
</sch:pattern>
