<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00093">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00093][Error] Every attribute on a PUBS element in the document must be specified with a non-whitespace value.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        For each PUBS element with at least one attribute specified, this rule ensures that all attributes on 
        that element are specified with a non-whitespace value;
    </sch:p>
    
    <sch:rule id="PUBS-ID-00093-R1" context="pubs:*[@*]">
        <sch:assert test="every $attribute in @* satisfies                     normalize-space(string($attribute))" flag="error" role="error">
            [PUBS-ID-00093][Error] Every attribute on a PUBS element in the document must be specified with a non-whitespace value.
        </sch:assert>
    </sch:rule>
</sch:pattern>