<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00092">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00092][Error] For element DateInformation, the permissible values 
        for the year range are 0001 through 9999 for elements ApproximableDateTime, 
        SearchableDateTime/EarliestStartDate, and SearchableDateTime/LatestEndDate.
        
        Human Readable: For element DateInformation, year values for elements ApproximableDateTime, SearchableDateTime/EarliestStartDate, 
        and SearchableDateTime/LatestEndDate have to fall within the range 0001 through 9999.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic. It makes sure that 
        the date contained within $dateValue has a year value within 
        the range $minYear and $maxYear, inclusive. The abstract rule is 
        extended once for each element required in rule PUBS-ID-00092.
    </sch:p>

	  <sch:rule abstract="true" id="abs.rule00092">
		    <sch:let name="minYear" value="0001"/>
		    <sch:let name="maxYear" value="9999"/>
		    <sch:let name="dateValue" value="."/>
		    <sch:let name="errMsg" value="'    [PUBS-ID-00092][Error] For element DateInformation, the permissible values     for the year range are 0001 through 9999 for elements ApproximableDateTime,     SearchableDateTime/EarliestStartDate, and SearchableDateTime/LatestEndDate.    '"/>
		    <sch:extends rule="abs.dateYearRangeRule"/>
	  </sch:rule>

    <!-- Begin using abstract rule to check required elements -->

    <sch:rule id="PUBS-ID-00092-R2" context="pubs:DateInformation/pubs:ApproximableDateTime">
      <sch:extends rule="abs.rule00092"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00092-R3" context="pubs:DateInformation/pubs:SearchableDateTime/pubs:EarliestStartDate">
    	<sch:extends rule="abs.rule00092"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00092-R4" context="pubs:DateInformation/pubs:SearchableDateTime/pubs:LatestEndDate">
    	<sch:extends rule="abs.rule00092"/>
    </sch:rule>
</sch:pattern>