<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00047">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00047][Warning] DateValidTil must be later than or equivalent
        to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.
        
        Human Readable: DateValidTil has to be greater than or equal to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        For each irm:dates element which specifies attribute @irm:validTil, 
        this rule ensures that the date specified in attribute @irm:validTil is
        later than or equivalent to the date specified in attribute 
        @irm:posted, in attribute @irm:approvedOn, in pubs:DatePublished, in attribute @irm:infoCutOff,
        and in the irm:temporalCoverage element with irm:name [infoCutOff].
    </sch:p>
    
    <sch:rule id="PUBS-ID-00047-R1" context="tdf:*[descendant::tdf:StructuredPayload[pubs:IntelDoc]]/tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:dates[@irm:validTil]">
        <sch:let name="secondaryDateList" value="(@irm:approvedOn, @irm:infoCutOff, ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, @irm:posted, ancestor::irm:ICResourceMetadataPackage/irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end )"/>
        <sch:assert test=" every $secondaryDate in $secondaryDateList satisfies dtf:compareDateTimeRanges(string(@irm:validTil), '&gt;=', string($secondaryDate))" flag="warning" role="warning">
            [PUBS-ID-00047][Warning] DateValidTil must be later than or equivalent
            to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.
            
            Human Readable: DateValidTil has to be greater than or equal to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.
        </sch:assert>
    </sch:rule>
</sch:pattern>