<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00035">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00035][Error]
        All links that have attribute xlink:type specified with a value
        of [simple] must also have attribute xlink:href specified.
        
        Human Readable: If attribute xlink:type value is [simple], then attribute xlink:href has to have a value.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        For all elements that have the attribute xlink:type specified with a value
        of [simple], this rule normalizes the space of the value of the attribute xlink:href
        and makes sure that the length of the resulting string is greater than zero,
        which indicates non-whitespace content.
    </sch:p>
    
    <sch:rule id="PUBS-ID-00035-R1" context="pubs:*[@xlink:type='simple']">
        <sch:assert test="normalize-space(string(@xlink:href))" flag="error" role="error">
            [PUBS-ID-00035][Error]
            All links that have attribute xlink:type specified with a value
            of [simple] must also have attribute xlink:href specified.
            
            Human Readable: If attribute xlink:type value is [simple], then attribute xlink:href has to have a value.
        </sch:assert>
    </sch:rule>
</sch:pattern>