<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00034">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00034][Error]
        For a given attribute imageMapReference value for element StillImageExhibit, there 
        must be an attribute id for element ImageMap with an identical value within the XML instance.
        
        Human Readable: Element StillImageExhibit attribute imageMapReference value must equal element ImageMap attribute id value.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        If element StillImageExhibit has attribute imageMapReference specified, then
        this rule ensures that there exists in the document at least one ImageMap element 
        with attribute id specified with a value equal to the value of attribute 
        imageMapReference on element StillImageExhibit.
    </sch:p>

    <sch:rule id="PUBS-ID-00034-R1" context="pubs:StillImageExhibit[@imageMapReference]">
        <sch:let name="imageMapReference" value="@imageMapReference"/>
        <sch:assert test="ancestor::tdf:TrustedDataObject//pubs:ImageMap[@id=$imageMapReference]" flag="error" role="error">
            [PUBS-ID-00034][Error]
            For a given attribute imageMapReference value for element StillImageExhibit, there 
            must be an attribute id for element ImageMap with an identical value within the XML instance.
            
            Human Readable: Element StillImageExhibit attribute imageMapReference value must equal element ImageMap attribute id value.
        </sch:assert>
    </sch:rule>
</sch:pattern>