<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron" id="PUBS-ID-00003">
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="ruleText">
        [PUBS-ID-00003][Error]
        The following elements, if they exist in an XML instance, must have content: 
        irm:taskID, DescriptiveMetadata/Title, DescriptiveMetadata/Description,
        irm:mimeType, NetworkAddress, Appendix/Title, 
        BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry,
        GlossaryDivision/Title, GlossaryTerm, IndexDivision/Title, IndexEntry, ListItem,
        LongDescription/Para, Section/Title, DateString.
        
        Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
        DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
        BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
        IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
    </sch:p>
    
    <sch:p xmlns:ism="urn:us:gov:ic:ism" ism:classification="U" ism:ownerProducer="USA" class="codeDesc">
        This pattern uses an abstract rule to consolidate logic. The abstract rule
        normalizes the space of the value of the content element and makes sure 
        that the length of the resulting string is greater than zero, which indicates
        non-whitespace content. The abstract rule is extended once for each
        element included in rule PUBS_ID_00003.
    </sch:p>

    <!-- Abstract rule, which asserts that the context element has content -->

    <sch:rule abstract="true" id="abs.rule00003">
        <sch:assert test="normalize-space(string(.))" flag="error" role="error">
            [PUBS-ID-00003][Error]
            The element <sch:name/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule to check required elements -->

    <sch:rule id="PUBS-ID-00003-R2" context="irm:ICResourceMetadataPackage/irm:resourceManagement/irm:taskingInfo/irm:taskID">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>

    <sch:rule id="PUBS-ID-00003-R3" context="pubs:DescriptiveMetadata/pubs:Title">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R4" context="pubs:DescriptiveMetadata/pubs:Description">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R5" context="irm:ICResourceMetadataPackage/irm:format/irm:mimeType">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule> 

    <sch:rule id="PUBS-ID-00003-R7" context="pubs:NetworkAddress">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R8" context="pubs:Appendix/pubs:Title">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R9" context="pubs:BibliographyDivision/pubs:Title">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R10" context="pubs:BibliographyEntry">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R11" context="pubs:Definition/pubs:Para">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R12" context="pubs:DistributionEntry">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R13" context="pubs:GlossaryDivision/pubs:Title">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R14" context="pubs:GlossaryTerm">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R15" context="pubs:IndexDivision/pubs:Title">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R16" context="pubs:IndexEntry">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R17" context="pubs:ListItem">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R18" context="pubs:LongDescription/pubs:Para">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
    
    <sch:rule id="PUBS-ID-00003-R19" context="pubs:Section/pubs:Title">
        <sch:extends rule="abs.rule00003"/>
    </sch:rule>
</sch:pattern>