<?xml version="1.0" encoding="UTF-8"?>
<!--UNCLASSIFIED--><xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:pubs="urn:us:gov:ic:pubs"
                xmlns:cem="urn:us:gov:ic:cem"
                xmlns:genc="urn:us:gov:ic:icgenc"
                xmlns:edh="urn:us:gov:ic:edh"
                xmlns:src="urn:us:gov:ic:src"
                xmlns:cve="urn:us:gov:ic:cve"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:ism="urn:us:gov:ic:ism"
                xmlns:irm="urn:us:gov:ic:irm"
                xmlns:tdf="urn:us:gov:ic:tdf"
                xmlns:ddms="urn:us:mil:ces:metadata:ddms:5"
                xmlns:dtf="date:time:function"
                xmlns:intdis="urn:us:gov:ic:intdis"
                xmlns:mime="urn:us:gov:ic:mime"
                xmlns:virt="urn:us:gov:ic:virt"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->
<xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:adjust-CombinedDate-to-GMT-timezone"
                 as="xs:string">
		    <xsl:param name="combinedDate" as="xs:string"/>
		    <xsl:choose>
			      <xsl:when test="matches($combinedDate, $timeZoneRegEx)">
				        <xsl:choose>
					          <xsl:when test="matches($combinedDate, $dateRegEx)">
						            <xsl:value-of select="adjust-date-to-timezone(xs:date($combinedDate), xs:dayTimeDuration($GMTTimeZoneOffset))"/>
					          </xsl:when>
					          <xsl:when test="matches($combinedDate, $dateHourMinTypeRegEx)">
						            <xsl:variable name="zeroSecondsPadding" select="':00'"/>
						            <xsl:variable name="combinedDatePadWithSeconds"
                                select="concat(substring($combinedDate, 1, 16), $zeroSecondsPadding, substring($combinedDate, 17))"/>
						            <xsl:value-of select="adjust-dateTime-to-timezone(xs:dateTime($combinedDatePadWithSeconds), xs:dayTimeDuration($GMTTimeZoneOffset))"/>
					          </xsl:when>
					          <xsl:when test="matches($combinedDate, $dateTimeRegEx)">
						            <xsl:value-of select="adjust-dateTime-to-timezone(xs:dateTime($combinedDate), xs:dayTimeDuration($GMTTimeZoneOffset))"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="$combinedDate"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$combinedDate"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:getMaxDay"
                 as="xs:string">
		    <xsl:param name="date" as="xs:dateTime"/>
		    <xsl:variable name="month" select="number(dtf:getMonth(string($date)))"/>
		    <xsl:choose>
			      <xsl:when test="$month = (1, 3, 5, 7, 8, 10, 12)">
				        <xsl:value-of select="31"/>
			      </xsl:when>
			      <xsl:when test="$month = (4, 6, 9, 11)">
				        <xsl:value-of select="30"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:choose>
					          <xsl:when test="dtf:isLeapYear(string($date))">
						            <xsl:value-of select="29"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="28"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:isLeapYear"
                 as="xs:boolean">
		    <xsl:param name="date" as="xs:string"/>
		    <xsl:variable name="year" as="xs:integer" select="xs:integer(dtf:getYear($date))"/>
		    <xsl:choose>
			      <xsl:when test="$year mod 100 = 0">
				        <xsl:choose>
					          <xsl:when test="$year mod 400 = 0">
						            <xsl:value-of select="true()"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:choose>
					          <xsl:when test="$year mod 4 = 0">
						            <xsl:value-of select="true()"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:replaceDateTimeDay"
                 as="xs:dateTime">
		    <xsl:param name="dateTime" as="xs:dateTime"/>
		    <xsl:param name="newDayString" as="xs:string"/>
		    <xsl:variable name="beforeDay" select="substring(string($dateTime), 1, 8)"/>
		    <xsl:variable name="afterDay" select="substring(string($dateTime), 11)"/>
		    <xsl:value-of select="concat($beforeDay, $newDayString, $afterDay)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:getYear"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 1, 4)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:getMonth"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 6, 2)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:getDay"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 9, 2)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:getTimeZone"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="dateTimeEndingWithTimezone"
                    as="xs:string"
                    select="concat('^.*(', $timeZoneRegEx, ')$')"/>
		    <xsl:choose>
			      <xsl:when test="matches($dateString, $dateTimeEndingWithTimezone)">
				        <xsl:value-of select="replace($dateString, $dateTimeEndingWithTimezone, '$1')"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$defaultTimeZone"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:yearPortionHasFourDigits"
                 as="xs:boolean">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="dateWithOnlyFourDigitYearAndOptionalTimeZoneRegEx"
                    as="xs:string"
                    select="concat('^\d{4}(', $timeZoneRegEx, ')?$')"/>
		    <xsl:variable name="dateStartingWithFourDigitYearRegEx"
                    as="xs:string"
                    select="'^\d{4}-.*$'"/>
		    <xsl:value-of select="matches($dateString, $dateWithOnlyFourDigitYearAndOptionalTimeZoneRegEx) or matches($dateString, $dateStartingWithFourDigitYearRegEx)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:removeTimeZone"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="replace($dateString, $timeZoneRegEx, '')"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:padDateTimeWithTemplate"
                 as="xs:dateTime">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:param name="dateTemplateString" as="xs:string"/>
		    <xsl:value-of select="concat($dateString, substring($dateTemplateString, string-length(normalize-space($dateString)) + 1))"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:isAllowableDateTimeFormat"
                 as="xs:boolean">
		    <xsl:param name="input" as="xs:string"/>
		    <xsl:variable name="trimmedInput" as="xs:string" select="normalize-space($input)"/>
		    <xsl:value-of select=" matches($trimmedInput, $gYearRegEx) or matches($trimmedInput, $gYearMonthRegEx) or matches($trimmedInput, $dateRegEx) or matches($trimmedInput, $dateHourMinTypeRegEx) or matches($trimmedInput, $dateTimeRegEx)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:startDate"
                 as="xs:dateTime">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="timeZonePortion" select="dtf:getTimeZone($dateString)"/>
		    <xsl:variable name="dateTimePortion" select="dtf:removeTimeZone($dateString)"/>
		    <xsl:variable name="outputDate"
                    select="dtf:padDateTimeWithTemplate($dateTimePortion, $startDateTimeTemplate)"/>
		    <xsl:value-of select="concat($outputDate, $timeZonePortion)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:endDate"
                 as="xs:dateTime">
		    <xsl:param name="input" as="xs:string"/>
		    <xsl:variable name="timeZonePortion" select="dtf:getTimeZone($input)"/>
		    <xsl:variable name="dateTimePortion" select="dtf:removeTimeZone($input)"/>
		    <xsl:variable name="outputDate"
                    select="dtf:padDateTimeWithTemplate($dateTimePortion, $endDateTimeTemplate)"/>
		    <xsl:variable name="outputWithCorrectedDay"
                    select="dtf:replaceDateTimeDay($outputDate, dtf:getMaxDay($outputDate))"/>
		    <xsl:choose>
			      <xsl:when test="dtf:getDay($input)">
				        <xsl:value-of select="concat($outputDate, $timeZonePortion)"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="concat($outputWithCorrectedDay, $timeZonePortion)"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:overlaps"
                 as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryStart"
                    as="xs:dateTime"
                    select="dtf:startDate($primary)"/>
		    <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
		    <xsl:variable name="secondaryStart"
                    as="xs:dateTime"
                    select="dtf:startDate($secondary)"/>
		    <xsl:variable name="secondaryEnd"
                    as="xs:dateTime"
                    select="dtf:endDate($secondary)"/>
		    <xsl:value-of select="$primaryStart &lt;= $secondaryEnd and $secondaryStart &lt;= $primaryEnd"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:isBefore"
                 as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
		    <xsl:variable name="secondaryStart"
                    as="xs:dateTime"
                    select="dtf:startDate($secondary)"/>
		    <xsl:value-of select="$primaryEnd &lt; $secondaryStart"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:isAfter"
                 as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryStart"
                    as="xs:dateTime"
                    select="dtf:startDate($primary)"/>
		    <xsl:variable name="secondaryEnd"
                    as="xs:dateTime"
                    select="dtf:endDate($secondary)"/>
		    <xsl:value-of select="$secondaryEnd &lt; $primaryStart"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:compareDateTimeRanges"
                 as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="operator" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryAndSecondayYearPortionsHaveFourDigits"
                    as="xs:boolean"
                    select="dtf:yearPortionHasFourDigits($primary) and dtf:yearPortionHasFourDigits($secondary)"/>
		    <xsl:choose>
			      <xsl:when test="$primaryAndSecondayYearPortionsHaveFourDigits">
				        <xsl:variable name="primaryStart"
                          as="xs:dateTime"
                          select="dtf:startDate($primary)"/>
				        <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
				        <xsl:variable name="secondaryStart"
                          as="xs:dateTime"
                          select="dtf:startDate($secondary)"/>
				        <xsl:variable name="secondaryEnd"
                          as="xs:dateTime"
                          select="dtf:endDate($secondary)"/>
				        <xsl:choose>
					
					
					          <xsl:when test="($operator = 'lt' or $operator = '&lt;') and (($primaryStart = $primaryEnd and $primaryStart = $secondaryStart) or ($primaryStart = $primaryEnd and $primaryStart = $secondaryEnd) or ($secondaryStart = $secondaryEnd and $primaryStart = $secondaryStart))">
						            <xsl:value-of select="false()"/>
					          </xsl:when>
					          
					
					          <xsl:when test="($operator = 'gt' or $operator = '&gt;') and (($primaryStart = $primaryEnd and $primaryEnd = $secondaryEnd) or ($primaryStart = $primaryEnd and $primaryEnd = $secondaryStart) or ($secondaryStart = $secondaryEnd and $primaryEnd = $secondaryEnd))">
						            <xsl:value-of select="false()"/>
					          </xsl:when>
					          
					          <xsl:when test="$operator = 'lt' or $operator = '&lt;' or $operator = '&lt;='">
						            <xsl:value-of select="dtf:isBefore($primary, $secondary) or dtf:overlaps($primary, $secondary)"/>
					          </xsl:when>
					          
					          <xsl:when test="$operator = 'gt' or $operator = '&gt;' or $operator = '&gt;='">
						            <xsl:value-of select="dtf:isAfter($primary, $secondary) or dtf:overlaps($primary, $secondary)"/>
					          </xsl:when>
					          
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="false()"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>

   <!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" title="" schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:pubs" prefix="pubs"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:cem" prefix="cem"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:icgenc" prefix="genc"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:edh" prefix="edh"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:src" prefix="src"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:cve" prefix="cve"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/1999/xlink" prefix="xlink"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:ism" prefix="ism"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:irm" prefix="irm"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:tdf" prefix="tdf"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:mil:ces:metadata:ddms:5" prefix="ddms"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/1999/XSL/Transform" prefix="xsl"/>
         <svrl:ns-prefix-in-attribute-values uri="date:time:function" prefix="dtf"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:intdis" prefix="intdis"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:mime" prefix="mime"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:virt" prefix="virt"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <svrl:text>
        Abstract rule, which asserts that the date contained within $dateValue has a year value within 
        the range $minYear and $maxYear, inclusive.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M17"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <svrl:text>Abstract rule, which asserts that each date contained within the list $dateList has a year value within the range
		$minYear and $maxYear, inclusive. If any value in $dateList is not a valid date format, then return true because there is no guarantee
		the value provided is not allowed.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M18"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00001</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00001</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00001][Warning] For every optional element that exists in the 
        document and can have text content, the element should have non-null, 
        non-whitespace value.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic. The abstract rule
        first concatenates the text values within the given element, separated by a single 
        space. The resultant string is then normalized with leading and trailing 
        whitespace removed, and the length of the string is determined to be greater 
        than zero, which indicates non-whitespace content. The abstract rule is extended 
        once for each optional element in the PUBS schema.  
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M57"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00003</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00003</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00003][Error]
        The following elements, if they exist in an XML instance, must have content: 
        irm:taskID, DescriptiveMetadata/Title, DescriptiveMetadata/Description,
        irm:mimeType, NetworkAddress, Appendix/Title, 
        BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry,
        GlossaryDivision/Title, GlossaryTerm, IndexDivision/Title, IndexEntry, ListItem,
        LongDescription/Para, Section/Title, DateString.
        
        Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
        DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
        BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
        IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic. The abstract rule
        normalizes the space of the value of the content element and makes sure 
        that the length of the resulting string is greater than zero, which indicates
        non-whitespace content. The abstract rule is extended once for each
        element included in rule PUBS_ID_00003.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M58"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00008</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00008</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00008][Error] The IntelDoc element must have 
        element content in at least one of the descendent elements.
        
        Human Readable: Element IntelDoc must have content in at least one child element.
    </svrl:text>
            <svrl:text>
        This calculates the string value of the pubs:IntelDoc element if the value contains any non white space, then the rule returns true.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M59"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00009</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00009</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00009][Error]
        For element SourceReference, either child element SourceID 
        or child element DocumentID must exist and must have a non-null value.
    </svrl:text>
            <svrl:text>
        If element SourceID is specified and has non-white space content
        or is element DocumentID is specified and has non-whitespace content,
        then the rule returns true.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M60"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00017</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00017</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00017][Error]
        If element CountryName has either attribute countryCode or countryCodeVocabulary 
        is specified, then both must be specified.
        
        Human Readable: Element CountryName must have a value for both the countryCode and countryCodeVocabulary attributes.
    </svrl:text>
            <svrl:text>
        This rule ensures that element CountryName has either both attribute
        countryCode and attribute countryCodeVocabulary specified, or 
        that element CountryName has neither attribute countryCode
        nor attribute countryCodeVocabulary specified.        
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M61"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00027</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00027</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00027][Error]
        For element ImageArea attribute coordinates must be specified and the value 
        must be appropriate to the value of attribute shape as defined by the 
        PUBS.XML Data Element Dictionary.
        
        Human Readable: Element ImageArea attribute coordinates and shape must be specified.  The value for attribute coordinates has to 
        follow the format for the designated shape as defined by the PUBS.XML Data Element Dictionary.
    </svrl:text>
            <svrl:text>
        If attribute coordinates or attribute shape are not specified or are
        specified with an empty value, then return false. 
        
        If the attribute shape is specified, then this rule uses a regular expression
        to make sure that the attribute coordinates is specified with an appropriate
        value from the PUBS.XML Data Element Dictionary, reproduced below for
        convenience:

        The number and order of values depends on the shape being defined. Possible combinations:
        - rect: left-x, top-y, right-x, bottom-y.
        - circle: center-x, center-y, radius. Note: When the radius value is a percentage value, 
        user agents should calculate the final radius value based on the associated object's width and height.
        The radius should be the smaller value of the two.
        - poly: x1, y1, x2, y2, ..., xN, yN. The first x and y coordinate pair and the last should be the 
        same to close the polygon. When these coordinate values are not the same, user agents should infer
        an additional coordinate pair to close the polygon.
        
        Coordinates are relative to the top, left corner of the object. All values are lengths. All values are separated by commas.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M62"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00028</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00028</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00028][Error]
        For elements AnimationExhibit, AudioExhibit, Interactive3DExhibit, OtherExhibit, 
        StillImageExhibit and VideoExhibit attribute xlink:href must be specified.
        
        Human Readable: Attribute xlink:href must be specified for elements AnimationExhibit, AudioExhibit, Interactive3DExhibit, OtherExhibit, 
        StillImageExhibit and VideoExhibit.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic. It makes sure
        that the attribute xlink:href is specified. The abstract rule is extended
        once for each required element in rule PUBS_ID_00028.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M63"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00030</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00030</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00030][Error]
        For element Glossary, if child element GlossaryDivision is used, there 
        must be at least two instances of element GlossaryDivision.
        
        Human Readable: Element Glossary child element GlossaryDivision requires more than one instance.
    </svrl:text>
            <svrl:text>
        This rule ensures that element Glossary does not contain exactly
        one GlossaryDivision child element.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M64"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00031</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00031</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00031][Error]
        For element Bibliography, if child element BibliographyDivision is used, there 
        must be at least two instances of element BibliographyDivision.
        
        Human Readable: Element Bibliography child element BibliographyDivision requires more than one instance.
    </svrl:text>
            <svrl:text>
        This rule ensures that element Bibliography does not contain exactly
        one BibliographyDivision child element.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M65"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00032</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00032</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00032][Error]
        For element Index, if child element IndexDivision is used, there 
        must be at least two instances of element IndexDivision.
        
        Human Readable: Element Index child element IndexDivision requires more than one instance.
    </svrl:text>
            <svrl:text>
        This rule ensures that element Index does not contain exactly
        one IndexDivision child element.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M66"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00033</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00033</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00033][Error] element ImageMap must specify attribute id.
        
        Human Readable: Element ImageMap must have a value for attribute id.
    </svrl:text>
            <svrl:text>
        Ensure the the id attribute is specified with non-whitespace characters
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M67"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00034</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00034</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00034][Error]
        For a given attribute imageMapReference value for element StillImageExhibit, there 
        must be an attribute id for element ImageMap with an identical value within the XML instance.
        
        Human Readable: Element StillImageExhibit attribute imageMapReference value must equal element ImageMap attribute id value.
    </svrl:text>
            <svrl:text>
        If element StillImageExhibit has attribute imageMapReference specified, then
        this rule ensures that there exists in the document at least one ImageMap element 
        with attribute id specified with a value equal to the value of attribute 
        imageMapReference on element StillImageExhibit.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M68"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00035</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00035</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00035][Error]
        All links that have attribute xlink:type specified with a value
        of [simple] must also have attribute xlink:href specified.
        
        Human Readable: If attribute xlink:type value is [simple], then attribute xlink:href has to have a value.
    </svrl:text>
            <svrl:text>
        For all elements that have the attribute xlink:type specified with a value
        of [simple], this rule normalizes the space of the value of the attribute xlink:href
        and makes sure that the length of the resulting string is greater than zero,
        which indicates non-whitespace content.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M69"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00036</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00036</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00036][Error]
        Internal links must be traversable. If the attribute xlink:href value for elements Link and ImageArea 
        is a URL fragment identifier with a [#] prefix, that fragment identifier must match the attribute id 
        value of an element within the XML instance. Note that a fragment identifier is characterized by 
        a [#] prefix. The [#] prefix is not part of the fragment identifier. So when the xlink:href attribute 
        value starts with a [#], the remainder of the value is the fragment identifier. This rule does not apply 
        to attribute values which contain a URL and a fragment identifier separated by [#], in which case it can 
        not be determined with certainty that the target is within the XML instance.
        
        Human Readable: If the elements Link and ImageArea attribute xlink:href value starts with [#], then 
        the fragment identifier portion of the value of attribute xlink:href must match 
        the value of any attribute id specified within the XML instance.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic.
        If the current element has attribute xlink:href specified with a value starting with [#], then 
        this rule ensures that the fragment identifier portion of the value of attribute xlink:href matches 
        the value of any attribute id specified within the XML instance. If the current element
        has attribute xlink:href specified with a value that does not start with [#], then this
        rule does not apply and this rule returns true.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M70"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00040</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00040</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00040][Error]
        The permissible values for the year range are 1901 through the current year
        for elements DatePublished, DateReviewed, and DateRevised.
        
        Human Readable: Year values for DatePublished, DateReviewed, and DateRevised have to fall within the range 1901 through the current year.
    </svrl:text>
            <svrl:text>
        This pattern uses abstract rules to consolidate logic. For elements, 
        this rule ensures that the date contained within $dateValue has a year
        value within the range $minYear and $maxYear, inclusive. For attributes, 
        this rule ensures that each date contained within $dateValues has a year value
        within the range $minYear and $maxYear, inclusive.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M71"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00042</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00042</xsl:attribute>
            <svrl:text>        
        [PUBS-ID-00042][Error]
        The permissible values for the year range are 0001 through 9999 for element
        DateTimeReferenced, and attributes date, dateTime, normalizedDate and normalizedDateTime.
        
        Human Readable: Year values for element DateTimeReferenced, and attributes date, dateTime, 
        normalizedDate and normalizedDateTime have to fall within the range 0001 through 9999.
    </svrl:text>
            <svrl:text>
        This pattern uses abstract rules to consolidate logic. For elements, 
        this rule ensures that the date contained within $dateValue has a year
        value within the range $minYear and $maxYear, inclusive. For attributes, 
        this rule ensures that each date contained within $dateList has a year value
        within the range $minYear and $maxYear, inclusive.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M72"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00045</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00045</xsl:attribute>
            <svrl:text> [PUBS-ID-00045][Warning] irm:dates/@approvedOn must
        be earlier than or equivalent to pubs:DatePublished and irm:dates/@posted.
        
        Human Readable: irm:dates/@approvedOn has to be less than or equal to pubs:DatePublished and irm:dates/@posted.    
    </svrl:text>
            <svrl:text>
        For each irm:dates element which specifies attribute @irm:approvedOn, 
        this rule ensures that the date specified in attribute @irm:approvedOn is
        earlier than or equivalent to the date specified in attribute 
        irm:dates/@posted and the date specified in pubs:DatePublished.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M73"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00046</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00046</xsl:attribute>
            <svrl:text>This abstract pattern compares the date contained within the param
        tdf:*[descendant::tdf:StructuredPayload/pubs:IntelDoc]//tdf:Assertion//irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end to each date contained within the param (ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                   ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                           ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:posted) (using the comparison
        operator contained in param '&lt;=') and makes sure that each comparison returns
        true.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M74"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00047</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00047</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00047][Warning] DateValidTil must be later than or equivalent
        to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.
        
        Human Readable: DateValidTil has to be greater than or equal to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.
    </svrl:text>
            <svrl:text>
        For each irm:dates element which specifies attribute @irm:validTil, 
        this rule ensures that the date specified in attribute @irm:validTil is
        later than or equivalent to the date specified in attribute 
        @irm:posted, in attribute @irm:approvedOn, in pubs:DatePublished, in attribute @irm:infoCutOff,
        and in the irm:temporalCoverage element with irm:name [infoCutOff].
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M75"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00048</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00048</xsl:attribute>
            <svrl:text>This abstract pattern compares the date contained within the param
        pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised to each date contained within the param (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                                   ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                                   ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted,                ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:infoCutOff,            ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end) (using the comparison
        operator contained in param '&gt;=') and makes sure that each comparison returns
        true.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M76"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00049</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00049</xsl:attribute>
            <svrl:text>This abstract pattern compares the date contained within the param
        pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised to each date contained within the param (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:validTil) (using the comparison
        operator contained in param '&lt;=') and makes sure that each comparison returns
        true.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M77"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00050</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00050</xsl:attribute>
            <svrl:text>This abstract pattern compares the date contained within the param
        pubs:AdministrativeMetadata/pubs:DateList/pubs:DateReviewed to each date contained within the param (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                      ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                      ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted) (using the comparison
        operator contained in param '&lt;=') and makes sure that each comparison returns
        true.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M78"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00053</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00053</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00053][Error]
        For any element PostalAddress, at least one of its child elements 
        AddressLine, City, State, Province, PostalCode, or CountryCode must 
        have element content.
        
        Human Readable: Element PostalAddress must have a value for at least one of its child elements.
    </svrl:text>
            <svrl:text>
        For each child element of pubs:PostalAddress listed, this rule normalizes the
        space of its value and make sures that the length of the resulting string 
        is greater than zero, indicating non-whitespace content. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M79"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00054</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00054</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00054][Warning]
        For elements pubs:ApproximableDateTime, ApproximableDateTimeStart (irm:temporalCoverage/irm:approximableStart/irm:approximableDate),
        ApproximableDateTimeEnd (irm:temporalCoverage/irm:approximableEnd/irm:approximableDate), and pubs:DateString, if the time designator (T) 
        is specified, it is recommended that time zone be specified.
        
        Human Readable: It is recommended that time zone be specified if time designator (T) is specified for the following elements:
        pubs:ApproximableDateTime, ApproximableDateTimeStart, ApproximableDateTimeEnd and pubs:DateString.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic.
        If the value of the context contains the time zone designator (T),
        then it makes sure that the value of the context matches the 
        regular expression for a date with a time zone specified.
        The abstract rule is extended once for each required element
        listed in rule PUBS-ID-00054.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M80"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00062</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00062</xsl:attribute>
            <svrl:text> This abstract pattern checks to see if an attribute of an element
        exists in a list. cem:QuantityReference[@cem:unitOfMeasureVocabulary='UNECE20'] := the context in which the searchValue exists. @cem:unitOfMeasure :=
        the value which should be verified is in the list. $unce20UnitsOfMeasureList := the list in which to search for
        the searchValue. '         [PUBS-ID-00062][Error]         If the element QuantityReference has the attribute unitOfMeasureVocabulary          with a value of UNECE20 the value of attribute unitOfMeasure must be          in CVEnumUNCE20UnitsOfMeasure.xml.         ' := the error message text to display when the assertion
        fails.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M81"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00063</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00063</xsl:attribute>
            <svrl:text> This abstract pattern checks to see if an attribute of an element
        exists in a list. cem:QuantityReference[@cem:unitOfMeasureVocabulary='ISO4217-3'] := the context in which the searchValue exists. @cem:unitOfMeasure :=
        the value which should be verified is in the list. $iso4217TrigraphList := the list in which to search for
        the searchValue. '         [PUBS-ID-00063][Error]         If the element QuantityReference has the attribute unitOfMeasureVocabulary          with a value of ISO4217-3 the value of attribute unitOfMeasure must be          in CVEnumISO4217Trigraph.xml.         ' := the error message text to display when the assertion
        fails.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M82"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00064</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00064</xsl:attribute>
            <svrl:text> This abstract pattern checks to see if an attribute of an element
        exists in a list. cem:QuantityReference[@cem:unitOfMeasureVocabulary='ISO4217-NR'] := the context in which the searchValue exists. @cem:unitOfMeasure :=
        the value which should be verified is in the list. $iso4217NumericList := the list in which to search for
        the searchValue. '         [PUBS-ID-00064][Error]         If the element QuantityReference has the attribute unitOfMeasureVocabulary with a value          of ISO4217-NR the value of attribute unitOfMeasure must be in CVEnumISO4217Numeric.xml.         ' := the error message text to display when the assertion
        fails.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M83"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00065</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00065</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00065][Error]
        For elements: AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo 
        at least one of the following child elements must have non-whitespace content: 
        Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
        EmailAddress, WebPageAddress, FormattedSignatureBlock.
        
        Human Readable: Elements AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo must have a value for at least one of the following
        child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
        EmailAddress, WebPageAddress, FormattedSignatureBlock.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic. It
        normalizes the space of the value of the specified child elements
        and makes sure that the length of the resulting string is 
        greater than zero, which indicates non-whitespace content.
        
        Element PostalAddress cannot contain text content, so the rule counts the 
        number of its child elements that contain non-white space and makes sure
        that the count is great than 0.
        
        The abstract rule is extended once for each required element in 
        rule PUBS_ID_00065.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M84"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00070</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00070</xsl:attribute>
            <svrl:text> [PUBS-ID-00070][Error] Element irm:type must not have the attribute
        irm:qualifier with a value of RevisionRecallDesignations. The required practice for
        conveying Revision Recall is to use a RevisionRecall handling assertion introduced in the
        2014 DEC Revision Recall specification.</svrl:text>
            <svrl:text>This rule was originally created for PUBS v10 to prevent the PUBS v9
        practice of using the pubs:OtherProperty element to express RevRecall. PUBS v10 directly
        supported RevRecall, so this practice was prohibited. PUBS 2014-DEC no longer supports
        RevRecall directly; it uses RevRecall handling assertion.</svrl:text>
            <svrl:text> If any element irm:type has attribute irm::qualifier specified with a
        value of [RevisionRecallDesignations], then this rule asserts false (generate an error). </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M85"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00072</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00072</xsl:attribute>
            <svrl:text> This abstract pattern checks to see if an attribute of an element
        exists in a list. cem:CountryName[@cem:countryCodeVocabulary='ISO-3'] := the context in which the searchValue exists. @cem:countryCode :=
        the value which should be verified is in the list. $countryIso3166TrigraphList := the list in which to search for
        the searchValue. '         [PUBS-ID-00072][Error]         If element CountryName has attribute countryCodeVocabulary specified as ISO-3         the attribute countryCode value must be in CVEnumPubsCountryISO3166Trigraph.xml         ' := the error message text to display when the assertion
        fails.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M86"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00079</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00079</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00079][Error]
        Element DescriptiveMetadata/Title must not start with any of the following strings
        ADMINISTRATIVE RECALL, or ADMINISTRATIVE REVISION, or SUBSTANTIVE RECALL, or SUBSTANTIVE REVISION.
        
        Human Readable: Using text in the Title is incorporated into the schema using RevisionRecall. Element DescriptiveMetadata/Title 
        cannot start with any of the following strings: ADMINISTRATIVE RECALL, or ADMINISTRATIVE REVISION, or SUBSTANTIVE RECALL, or SUBSTANTIVE REVISION.
    </svrl:text>
            <svrl:text>
        If element DescriptiveMetadata/Title is specified with a value that starts with ADMINISTRATIVE RECALL, ADMINISTRATIVE REVISION, 
        SUBSTANTIVE RECALL, or SUBSTANTIVE REVISION, then this rule returns false.  The Revision Recall Best practice method of using text in the Title 
        is now incorporated into the schema using RevisionRecall therefore use in this DES is rescinded.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M87"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00080</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00080</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00080][Error]
        The attribute ism:excludeFromRollup must not be specified for any element in the 
        namespace urn:us:gov:ic:pubs except ReferencedResourceSecurity.
        
        Human Readable: Attribute ism:excluedFromRollup is only permitted with element ReferenceResourceSecurity in the urn:us:gov:ic:pubs
        namespace.
    </svrl:text>
            <svrl:text>
        For all elements in the namespace urn:us:gov:ic:pubs with 
        attribute ism:excludeFromRollup specified, this rule ensures that 
        the name of the element is ReferencedResourceSecurity.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M88"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00082</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00082</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00082][Error]
        The attribute ism:noticeType must not be specified for any element in 
        the namespace urn:us:gov:ic:pubs except IntelDoc, Note, NoteInline, AuthorInfo, CoauthorInfo, ContributingAuthorInfo, or POCinfo.
        
        Human Readable: Attribute ism:noticeType can only exist in the namespace urn:us:gov:ic:pubs for the following elements: IntelDoc, Note, 
        NoteInline, AuthorInfo, CoauthorInfo, ContributingAuthorInfo, or POCinfo.
    </svrl:text>
            <svrl:text>
        For all elements in the namespace urn:us:gov:ic:pubs with 
        attribute ism:noticeType specified, this rule ensures that the name
        of the element is one of IntelDoc, Note, NoteInline, AuthorInfo, CoauthorInfo, ContributingAuthorInfo, or POCinfo.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M89"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00086</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00086</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00086][Error]
        If PublicationMetadataList contains more than one PublicationMetadata 
        then all the PublicationMetadata elements must have ISM security marks present.
    </svrl:text>
            <svrl:text>
        For each PublicationMetadataList element with more than one
        PublicationMetadata child, verify that the PublicationMetadata 
        child element specifies the attribute ism:classification, which 
        indicates ISM security markings.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M90"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00087</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00087</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00087][Error]
        If the DateInformation element exists, at least one of its child 
        elements DateString, ApproximableDateTime, or SearchableDateTime must be present.
        
        Human Readable: Element DateInformation must have a value for one of its child elements.
    </svrl:text>
            <svrl:text> 
        For element pubs:DateInformation, this rule ensures that one or more of the
        child elements DateString, ApproximableDateTime,
        SearchableDateTime/EarliestStartDate or SearchableDateTime/LatestEndDate
        is specified with a non-white space value.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M91"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00092</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00092</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00092][Error] For element DateInformation, the permissible values 
        for the year range are 0001 through 9999 for elements ApproximableDateTime, 
        SearchableDateTime/EarliestStartDate, and SearchableDateTime/LatestEndDate.
        
        Human Readable: For element DateInformation, year values for elements ApproximableDateTime, SearchableDateTime/EarliestStartDate, 
        and SearchableDateTime/LatestEndDate have to fall within the range 0001 through 9999.
    </svrl:text>
            <svrl:text>
        This pattern uses an abstract rule to consolidate logic. It makes sure that 
        the date contained within $dateValue has a year value within 
        the range $minYear and $maxYear, inclusive. The abstract rule is 
        extended once for each element required in rule PUBS-ID-00092.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M92"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00093</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00093</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00093][Error] Every attribute on a PUBS element in the document must be specified with a non-whitespace value.
    </svrl:text>
            <svrl:text>
        For each PUBS element with at least one attribute specified, this rule ensures that all attributes on 
        that element are specified with a non-whitespace value;
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M93"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00096</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00096</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00096][Error]
        For elements Facility and Person, if attribute xlink:type is
        specified then it must have a value of [simple] or [resource].
        
        Human Readable: For elements Facility and Person, attribute xlink:type value must be either [simple] or [resource]. 
    </svrl:text>
            <svrl:text>
    	Makes sure that for each element Facility and Person,
    	if attribute xlink:type is specified then it has a value of [simple] or [resource].
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M94"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00097</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00097</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00097][Error]
        For element pubs:Link, if attribute xlink:type is defined then it must
        have a value of [simple] or [extended].
        
        Human Readable: For element pubs:Link, attribute xlink:type value must be either [simple] or [extended].
    </svrl:text>
            <svrl:text>
    	Makes sure that for each element pubs:Link, if attribute xlink:type is
    	specified then it has a value of [simple] or [extended].
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M95"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00098</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00098</xsl:attribute>
            <svrl:text>
		[PUBS-ID-00098][Error] For any element, if attribute xlink:type is specified
		with a value of [extended], then that element can only define the following attributes in the
		xlink namespace: xlink:type, xlink:role, and xlink:title.
		
		Human Readable: If any element has attribute xlink:type with a value of [extended], then that element can only have values for the
		following in the xlink namespace: xlink:type, xlink:role, and xlink:title.
	</svrl:text>
            <svrl:text>
		Makes sure that for each element that has attribute xlink:type specified
		with a value of [extended] only defines the following attributes in the xlink namespace:
		xlink:type, xlink:role, and xlink:title.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M96"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00099</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00099</xsl:attribute>
            <svrl:text>
		[PUBS-ID-00099][Error] For any element, if attribute xlink:type is specified
		with a value of [resource], then that element can only define the following
		attributes in the xlink namespace: xlink:type, xlink:role, xlink:title, and xlink:label.
		
		Human Readable: If any element has attribute xlink:type with a value of [resource], then that element can only have values for the
		following in the xlink namespace: xlink:type, xlink:role, xlink:title, and xlink:label.
	</svrl:text>
            <svrl:text>
		Makes sure that for each element that has attribute xlink:type specified
		with a value of [extended] only defines the following attributes in the xlink namespace:
		xlink:type, xlink:role, and xlink:title.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M97"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00100</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00100</xsl:attribute>
            <svrl:text>
		[PUBS-ID-00100][Error] For any element, if attribute xlink:type is specified
		with a value of [simple], then that element can only define the following
		attributes in the xlink namespace: xlink:type, xlink:href, xlink:role, xlink:arcrole,
		xlink:title, xlink:show, and xlink:actuate.
		
		Human Readable: If any element has attribute xlink:type with a value of [simple], then that element can only have values for the
		following in the xlink namespace: xlink:type, xlink:href, xlink:role, xlink:arcrole, xlink:title, xlink:show, and xlink:actuate.
	</svrl:text>
            <svrl:text>
		Makes sure that for each element that has attribute xlink:type specified
		with a value of [extended] only defines the following attributes in the xlink namespace:
		xlink:type, xlink:role, and xlink:title.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M98"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00101</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00101</xsl:attribute>
            <svrl:text>
		[PUBS-ID-00101][Error] For any element, if any attribute is specified with the 
		xlink namespace 'http://www.w3.org/1999/xlink', then attributes xlink:type and/or
		xlink:href must be specified.
		
		Human Readable: If any element has an attribute specified with the xlink namespace 'http://www.w3.org/1999/xlink', 
		then attributes xlink:type and/or xlink:href must be specified.
	</svrl:text>
            <svrl:text>
		Makes sure that for each element that has any attribute in the xlink namespace has
		either xlink:type or xlink:href specified.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M99"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00103</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00103</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00103][Error]
        If an element has @noteType then it cannot have @ism:noticeType or 
        @ism:unregisteredNoticeType.
        
        Human Readable: An element with attribute noteType cannot have the 
        ISM attributes noticeType or unregisteredNoticeType.
    </svrl:text>
            <svrl:text>
        If an element has a noteType attribute, then it may not have
        the ISM attributes noticeType or unregisteredNoticeType.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M100"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00104</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00104</xsl:attribute>
            <svrl:text>[PUBS-ID-00104][Error] When there is a mixture of Foreign Government
        Information (FGI) and US data present on a Para element with ism:ownerProducer containing
        [USA], then there must exist a source citation reference. Human Readable: Element Para with
        ism:ownerProducer containing [USA] and a mix of Foreign Goverment Information (FGI) and US
        data, must have a source citation reference.</svrl:text>
            <svrl:text>Given a pubs:Para element with @ism:ownerProducer containing USA and
        either attribute @ism:FGIsourceOpen or @ism:FGIsourceProtected, there must exist a source
        citation reference (pubs:SourceReferenceCitationRef).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M101"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00111</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00111</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00111][Error]
        At least one of either irm:ICResourceMetadataPackage/irm:dates/@irm:posted or pubs:DatePublished 
        is required to be specified.      
        
        Human Readable: A PUBS document must have either a date posted or date published 
        specified for itself.
    </svrl:text>
            <svrl:text>
        If a TDO has a PUBS assertion, determined by checking if it has a tdf:StructuredStatement element with
        a child of pubs:IntelDocMetadata, this rule verifies that at least one of 
        tdf:Assertion//irm:ICResourceMetadataPackage/irm:dates/@irm:posted or tdf:StructuredPayload//pubs:DatePublished is specified.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M102"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00113</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00113</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00113][Error]
        If a TrustedDataObject element contains an assertion with a PUBS structured statement, 
        it must also contain an assertion with an IRM structured statement. 
        
        Human Readable: If a Trusted Data Object contains a PUBS assertion, it must also contain an IRM assertion.  
    </svrl:text>
            <svrl:text>
        If a TDO has a PUBS assertion, determined by checking if it has a tdf:StructuredStatement element with
        a child of pubs:IntelDocMetadata, verify that it also contains an IRM assertion, verified by checking if
        it has a tdf:StructuredStatement element with a child of irm:ICResourceMetadataPackage.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M103"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00114</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00114</xsl:attribute>
            <svrl:text>
        This abstract pattern checks to see if the validation environment has at least the version / revision of the
        CVE as of the writing of this specification. 
        The calling rule must pass in '202111', 'ISM', '../../CVE/ISM/CVEnumISMClassificationAll.xml', 'PUBS-ID-00114'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M104"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00115</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00115</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00115][Error] The root node of a PUBS document must be pubs:IntelDoc 
        in a tdf:StructuredPayload element of a TDF instance.
        
        Human Readable: PUBS must be in a TDF and the starting node in the payload 
        must be pubs:IntelDoc.
    </svrl:text>
            <svrl:text>
        Ensure that the root node of the document is in the tdf namespace and that the
        beginning of a structured payload consists for a pubs:IntelDoc element.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M105"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00116</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00116</xsl:attribute>
            <svrl:text>[PUBS-ID-00116][Error] If a tdf:TrustedDataObject has an IntelDoc element, it must contain a
        pubs:IntelDocMetadata assertion.</svrl:text>
            <svrl:text>A PUBS Trusted Data Object IntelDoc must contain a PUBS assertion.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M106"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00117</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00117</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00117][Error]
        The value of each attribute @src:citationIDRef must be found in the list of attribute @src:citationID values.
    </svrl:text>
            <svrl:text>
        The value of each attribute @src:citationIDRef must be found in the list of attribute @src:citationID values.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M107"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00118</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00118</xsl:attribute>
            <svrl:text>
        This abstract pattern checks to see if the validation environment has at least the version / revision of the
        CVE as of the writing of this specification. 
        The calling rule must pass in '202010', 'MIME', '../../CVE/MIME/CVEnumMIMEType.xml', 'PUBS-ID-00118'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M108"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00119</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00119</xsl:attribute>
            <svrl:text> 
        [PUBS-ID-00119][Error] For PUBS elements with MIME attributes or containing
        MIME elements, the MIME CESVersion must exist somewhere in the instance. 
        
        Human Readable: If PUBS is using MIME in any way, the MIME CESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For PUBS elements with MIME attributes or containing MIME elements, the
        MIME CESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M109"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00120</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00120</xsl:attribute>
            <svrl:text>
        This abstract pattern checks to see if the validation environment has at least the version / revision of the
        CVE as of the writing of this specification. 
        The calling rule must pass in '201707', 'INTDIS', '../../CVE/INTDIS/CVEnumIntelDiscipline.xml', 'PUBS-ID-00120'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M110"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00121</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00121</xsl:attribute>
            <svrl:text> 
        [PUBS-ID-00121][Error] For PUBS elements with INTDIS attributes or containing
        INTDIS elements, the INTDIS CESVersion must exist somewhere in the instance. 
        
        Human Readable: If PUBS is using INTDIS in any way, the INTDIS CESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For PUBS elements with INTDIS attributes or containing INTDIS elements, the
        INTDIS CESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M111"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00123</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00123</xsl:attribute>
            <svrl:text> This abstract pattern
        checks to see if the validation environment has at least the version / revision of the
        Schema as of the writing of this specification. The calling rule must pass in '202111',
        'IRM', '../../Schema/IRM/IC-IRM.xsd', 'PUBS-ID-00123'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M112"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00124</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00124</xsl:attribute>
            <svrl:text> This abstract pattern
        checks to see if the validation environment has at least the version / revision of the
        Schema as of the writing of this specification. The calling rule must pass in '201508.202205',
        'SRC', '../../Schema/SRC/SRC-XML.xsd', 'PUBS-ID-00124'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M113"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00127</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00127</xsl:attribute>
            <svrl:text> This abstract pattern
        checks to see if the validation environment has at least the version / revision of the
        Schema as of the writing of this specification. The calling rule must pass in '201903',
        'IC-EDH', '../../Schema/IC-EDH/IC-EDH.xsd', 'PUBS-ID-00127'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M114"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00128</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00128</xsl:attribute>
            <svrl:text> This abstract pattern
        checks to see if the validation environment has at least the version / revision of the
        Schema as of the writing of this specification. The calling rule must pass in '202010',
        'VIRT', '../../Schema/VIRT/VIRT.xsd', 'PUBS-ID-00128'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M115"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00129</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00129</xsl:attribute>
            <svrl:text> 
        [PUBS-ID-00129][Error] For PUBS elements with VIRT attributes or containing
        VIRT elements, the VIRT DESVersion must exist somewhere in the instance. 
        
        Human Readable: If PUBS is using VIRT in any way, the VIRT DESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For PUBS elements with VIRT attributes or containing VIRT elements, the
        VIRT DESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M116"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00130</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00130</xsl:attribute>
            <svrl:text> [PUBS-ID-00130][Warning] pubs:DESVersion attribute SHOULD be specified as
        version 201804.202205 (Version:2018-APR Revision: 2022-MAY) with an optional extension. </svrl:text>
            <svrl:text> This rule supports extending the version identifier with an optional
        trailing hyphen and up to 23 additional characters. The version must match the regular
        expression “^201804.202205(-.{1,23})?$". </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M117"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00131</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00131</xsl:attribute>
            <svrl:text> 
        [PUBS-ID-00131][Error] For PUBS elements with CEM attributes or containing
        CEM elements, the CEM DESVersion must exist somewhere in the instance. 
        
        Human Readable: If PUBS is using CEM in any way, the CEM DESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For PUBS elements with CEM attributes or containing CEM elements, the
        CEM DESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M118"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00132</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00132</xsl:attribute>
            <svrl:text> This abstract pattern
        checks to see if the validation environment has at least the version / revision of the
        Schema as of the writing of this specification. The calling rule must pass in '201804',
        'CEM', '../../Schema/CEM/CEM-XML.xsd', 'PUBS-ID-00132'.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M119"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00133</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00133</xsl:attribute>
            <svrl:text> 
        [PUBS-ID-00133][Error] For PUBS elements with IC-EDH attributes or containing
        IC-EDH elements, the IC-EDH DESVersion must exist somewhere in the instance. 
        
        Human Readable: If PUBS is using IC-EDH in any way, the IC-EDH DESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For PUBS elements with IC-EDH attributes or containing IC-EDH elements, the
        IC-EDH DESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M120"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00134</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00134</xsl:attribute>
            <svrl:text> 
        [PUBS-ID-00134][Error] For PUBS elements with ISM attributes or containing
        ISM elements, the ISM DESVersion must exist somewhere in the instance. 
        
        Human Readable: If PUBS is using ISM in any way, the ISM DESVersion must exist in the instance. 
    </svrl:text>
            <svrl:text> 
        For PUBS elements with ISM attributes or containing ISM elements, the
        ISM DESVersion must exist somewhere in the instance. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M121"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">PUBS-ID-00135</xsl:attribute>
            <xsl:attribute name="name">PUBS-ID-00135</xsl:attribute>
            <svrl:text>
        [PUBS-ID-00135][Error] DateInfoCutoff must be earlier than or equivalent to DateApproved and DatePublished.        
        
        Human Readable: DateInfoCutoff has to be less than or equal to DateApproved and DatePublished.
    </svrl:text>
            <svrl:text>
        For each irm:dates element which specifies attribute @irm:infoCutOff, 
        this rule ensures that the date specified in attribute @irm:infoCutOff is
        earlier than or equivalent to the date specified in attributes 
        irm:dates/@approvedOn and pubs:DatePublished.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M122"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


<!--PATTERN -->
<xsl:template match="text()" priority="-1" mode="M17"/>
   <xsl:template match="@*|node()" priority="-2" mode="M17">
      <xsl:apply-templates select="*" mode="M17"/>
   </xsl:template>

   <!--PATTERN -->
<xsl:template match="text()" priority="-1" mode="M18"/>
   <xsl:template match="@*|node()" priority="-2" mode="M18">
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>
   <xsl:param name="GMTTimeZoneOffset" select="'PT0H'"/>
   <xsl:param name="currentYear"
              select="year-from-dateTime(adjust-dateTime-to-timezone(current-dateTime(), xs:dayTimeDuration($GMTTimeZoneOffset)))"/>
   <xsl:param name="timeZoneRegEx" select="'Z|[\+-]\d{2}:\d{2}'"/>
   <xsl:param name="endsWithTimeZoneRegEx" select="concat('^.*',$timeZoneRegEx,'$')"/>
   <xsl:param name="startDateTimeTemplate" select="'0001-01-01T00:00:00.000'"/>
   <xsl:param name="endDateTimeTemplate" select="'9999-12-01T23:59:59.999'"/>
   <xsl:param name="defaultTimeZone" select="'Z'"/>
   <xsl:param name="gYearRegEx" select="'^\d{4}(Z|[\+-]\d{2}:\d{2})?$'"/>
   <xsl:param name="gYearMonthRegEx" select="'^\d{4}-\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>
   <xsl:param name="dateRegEx" select="'^\d{4}-\d{2}-\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>
   <xsl:param name="dateHourMinTypeRegEx"
              select="'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>
   <xsl:param name="dateTimeRegEx"
              select="'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d{1,3})?(Z|[\+-]\d{2}:\d{2})?$'"/>
   <xsl:param name="countryIso3166TrigraphList"
              select="document('../../CVE/PUBS/CVEnumPubsCountryISO3166Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="iso639-2TrigraphList"
              select="document('../../CVE/PUBS/CVEnumISO639-2Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="iso639-3TrigraphList"
              select="document('../../CVE/PUBS/CVEnumISO639-3Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="iso639DigraphList"
              select="document('../../CVE/PUBS/CVEnumISO639Digraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="unce20UnitsOfMeasureList"
              select="document('../../CVE/PUBS/CVEnumUNCE20UnitsOfMeasure.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="iso4217TrigraphList"
              select="document('../../CVE/PUBS/CVEnumISO4217Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="iso4217NumericList"
              select="document('../../CVE/PUBS/CVEnumISO4217Numeric.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="compoundLanguageQualifierTypeList"
              select="document('../../CVE/IRM/CVEnumIRMCompoundLanguageQualifierType.xml')//cve:Value"/>

   <!--PATTERN PUBS-ID-00001-->


	<!--RULE PUBS-ID-00001-R2-->
<xsl:template match="pubs:AbbreviatedTitle" priority="1069" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AbbreviatedTitle"
                       id="PUBS-ID-00001-R2"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R3-->
<xsl:template match="pubs:AttributionText" priority="1068" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AttributionText"
                       id="PUBS-ID-00001-R3"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R4-->
<xsl:template match="pubs:BiographicalSketch" priority="1067" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:BiographicalSketch"
                       id="PUBS-ID-00001-R4"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R5-->
<xsl:template match="pubs:Caption" priority="1066" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Caption"
                       id="PUBS-ID-00001-R5"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R6-->
<xsl:template match="pubs:CompilationTitle" priority="1065" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:CompilationTitle"
                       id="PUBS-ID-00001-R6"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R7-->
<xsl:template match="pubs:Description" priority="1064" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Description"
                       id="PUBS-ID-00001-R7"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R8-->
<xsl:template match="pubs:EmphasizedText" priority="1063" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:EmphasizedText"
                       id="PUBS-ID-00001-R8"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R9-->
<xsl:template match="pubs:Footnote" priority="1062" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Footnote"
                       id="PUBS-ID-00001-R9"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R10-->
<xsl:template match="pubs:Legend" priority="1061" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Legend"
                       id="PUBS-ID-00001-R10"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R11-->
<xsl:template match="pubs:Link" priority="1060" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Link"
                       id="PUBS-ID-00001-R11"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R12-->
<xsl:template match="pubs:ListItem" priority="1059" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ListItem"
                       id="PUBS-ID-00001-R12"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R13-->
<xsl:template match="pubs:Para" priority="1058" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Para"
                       id="PUBS-ID-00001-R13"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R14-->
<xsl:template match="pubs:PreformattedText" priority="1057" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:PreformattedText"
                       id="PUBS-ID-00001-R14"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R15-->
<xsl:template match="pubs:SourceDescriptor" priority="1056" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:SourceDescriptor"
                       id="PUBS-ID-00001-R15"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R16-->
<xsl:template match="pubs:SourcedText" priority="1055" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:SourcedText"
                       id="PUBS-ID-00001-R16"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R17-->
<xsl:template match="pubs:Subtitle" priority="1054" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Subtitle"
                       id="PUBS-ID-00001-R17"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R18-->
<xsl:template match="pubs:TextBox" priority="1053" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:TextBox"
                       id="PUBS-ID-00001-R18"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R19-->
<xsl:template match="pubs:Title" priority="1052" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Title"
                       id="PUBS-ID-00001-R19"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R20-->
<xsl:template match="pubs:entry" priority="1051" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:entry"
                       id="PUBS-ID-00001-R20"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R21-->
<xsl:template match="pubs:NoteInline" priority="1050" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:NoteInline"
                       id="PUBS-ID-00001-R21"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R22-->
<xsl:template match="pubs:Quote" priority="1049" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Quote"
                       id="PUBS-ID-00001-R22"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R23-->
<xsl:template match="pubs:Abbreviation" priority="1048" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Abbreviation"
                       id="PUBS-ID-00001-R23"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R24-->
<xsl:template match="pubs:Acronym" priority="1047" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Acronym"
                       id="PUBS-ID-00001-R24"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R25-->
<xsl:template match="pubs:AddressLine" priority="1046" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AddressLine"
                       id="PUBS-ID-00001-R25"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R26-->
<xsl:template match="pubs:BibliographyEntry" priority="1045" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:BibliographyEntry"
                       id="PUBS-ID-00001-R26"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R27-->
<xsl:template match="pubs:City" priority="1044" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:City"
                       id="PUBS-ID-00001-R27"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R28-->
<xsl:template match="pubs:ContactFor" priority="1043" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ContactFor"
                       id="PUBS-ID-00001-R28"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R29-->
<xsl:template match="pubs:CopyrightAttribution" priority="1042" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:CopyrightAttribution"
                       id="PUBS-ID-00001-R29"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R30-->
<xsl:template match="pubs:DocumentID" priority="1041" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DocumentID"
                       id="PUBS-ID-00001-R30"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R31-->
<xsl:template match="pubs:EditionNumber" priority="1040" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:EditionNumber"
                       id="PUBS-ID-00001-R31"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R32-->
<xsl:template match="pubs:GenerationalQualifier" priority="1039" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:GenerationalQualifier"
                       id="PUBS-ID-00001-R32"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R33-->
<xsl:template match="pubs:GivenName" priority="1038" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:GivenName"
                       id="PUBS-ID-00001-R33"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R34-->
<xsl:template match="pubs:GlossaryTerm" priority="1037" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:GlossaryTerm"
                       id="PUBS-ID-00001-R34"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R35-->
<xsl:template match="pubs:Honorific" priority="1036" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Honorific"
                       id="PUBS-ID-00001-R35"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R36-->
<xsl:template match="pubs:IndexEntry" priority="1035" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:IndexEntry"
                       id="PUBS-ID-00001-R36"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R37-->
<xsl:template match="pubs:IssueNumber" priority="1034" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:IssueNumber"
                       id="PUBS-ID-00001-R37"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R38-->
<xsl:template match="pubs:JobTitle" priority="1033" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:JobTitle"
                       id="PUBS-ID-00001-R38"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R39-->
<xsl:template match="pubs:MediaExtent" priority="1032" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:MediaExtent"
                       id="PUBS-ID-00001-R39"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R40-->
<xsl:template match="pubs:MilitaryRank" priority="1031" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:MilitaryRank"
                       id="PUBS-ID-00001-R40"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R41-->
<xsl:template match="pubs:OfficeName" priority="1030" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:OfficeName"
                       id="PUBS-ID-00001-R41"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R42-->
<xsl:template match="pubs:OriginalClassificationMarking"
                 priority="1029"
                 mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:OriginalClassificationMarking"
                       id="PUBS-ID-00001-R42"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R43-->
<xsl:template match="pubs:PersonalTitle" priority="1028" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:PersonalTitle"
                       id="PUBS-ID-00001-R43"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R44-->
<xsl:template match="pubs:PostalCode" priority="1027" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:PostalCode"
                       id="PUBS-ID-00001-R44"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R45-->
<xsl:template match="pubs:Province" priority="1026" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Province"
                       id="PUBS-ID-00001-R45"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R46-->
<xsl:template match="pubs:SegmentLabel" priority="1025" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:SegmentLabel"
                       id="PUBS-ID-00001-R46"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R47-->
<xsl:template match="pubs:SourceID" priority="1024" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:SourceID"
                       id="PUBS-ID-00001-R47"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R48-->
<xsl:template match="pubs:State" priority="1023" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:State"
                       id="PUBS-ID-00001-R48"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R49-->
<xsl:template match="pubs:Subscript" priority="1022" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Subscript"
                       id="PUBS-ID-00001-R49"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R50-->
<xsl:template match="pubs:Superscript" priority="1021" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Superscript"
                       id="PUBS-ID-00001-R50"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R51-->
<xsl:template match="pubs:Surname" priority="1020" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Surname"
                       id="PUBS-ID-00001-R51"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R52-->
<xsl:template match="pubs:UUID" priority="1019" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:UUID"
                       id="PUBS-ID-00001-R52"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R53-->
<xsl:template match="pubs:VolumeNumber" priority="1018" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:VolumeNumber"
                       id="PUBS-ID-00001-R53"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R54-->
<xsl:template match="pubs:locatorLink" priority="1017" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:locatorLink"
                       id="PUBS-ID-00001-R54"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R55-->
<xsl:template match="pubs:Affiliation" priority="1016" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Affiliation"
                       id="PUBS-ID-00001-R55"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R56-->
<xsl:template match="pubs:AlternateFormat" priority="1015" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AlternateFormat"
                       id="PUBS-ID-00001-R56"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R57-->
<xsl:template match="pubs:CountryCode" priority="1014" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:CountryCode"
                       id="PUBS-ID-00001-R57"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R58-->
<xsl:template match="pubs:EmailAddress" priority="1013" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:EmailAddress"
                       id="PUBS-ID-00001-R58"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R59-->
<xsl:template match="pubs:FaxNumber" priority="1012" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:FaxNumber"
                       id="PUBS-ID-00001-R59"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R60-->
<xsl:template match="pubs:FormattedSignatureBlock" priority="1011" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:FormattedSignatureBlock"
                       id="PUBS-ID-00001-R60"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R61-->
<xsl:template match="pubs:InternalID" priority="1010" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:InternalID"
                       id="PUBS-ID-00001-R61"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R62-->
<xsl:template match="pubs:NetworkAddress" priority="1009" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:NetworkAddress"
                       id="PUBS-ID-00001-R62"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R63-->
<xsl:template match="pubs:OtherProperty" priority="1008" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:OtherProperty"
                       id="PUBS-ID-00001-R63"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R64-->
<xsl:template match="pubs:PhoneNumber" priority="1007" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:PhoneNumber"
                       id="PUBS-ID-00001-R64"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R65-->
<xsl:template match="pubs:PlaceName" priority="1006" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:PlaceName"
                       id="PUBS-ID-00001-R65"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R66-->
<xsl:template match="pubs:ProductLine" priority="1005" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ProductLine"
                       id="PUBS-ID-00001-R66"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R67-->
<xsl:template match="pubs:Region" priority="1004" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Region"
                       id="PUBS-ID-00001-R67"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R68-->
<xsl:template match="pubs:SubjectCategory" priority="1003" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:SubjectCategory"
                       id="PUBS-ID-00001-R68"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R69-->
<xsl:template match="pubs:SubjectCode" priority="1002" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:SubjectCode"
                       id="PUBS-ID-00001-R69"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R70-->
<xsl:template match="pubs:UserID" priority="1001" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:UserID"
                       id="PUBS-ID-00001-R70"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00001-R71-->
<xsl:template match="pubs:WebPageAddress" priority="1000" mode="M57">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:WebPageAddress"
                       id="PUBS-ID-00001-R71"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="normalize-space(string())"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string())">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00001][Warning] For every optional element that exists in the 
            document and can have text content, the element should have non-null, 
            non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M57"/>
   <xsl:template match="@*|node()" priority="-2" mode="M57">
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00003-->


	<!--RULE PUBS-ID-00003-R2-->
<xsl:template match="irm:ICResourceMetadataPackage/irm:resourceManagement/irm:taskingInfo/irm:taskID"
                 priority="1016"
                 mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="irm:ICResourceMetadataPackage/irm:resourceManagement/irm:taskingInfo/irm:taskID"
                       id="PUBS-ID-00003-R2"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R3-->
<xsl:template match="pubs:DescriptiveMetadata/pubs:Title"
                 priority="1015"
                 mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DescriptiveMetadata/pubs:Title"
                       id="PUBS-ID-00003-R3"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R4-->
<xsl:template match="pubs:DescriptiveMetadata/pubs:Description"
                 priority="1014"
                 mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DescriptiveMetadata/pubs:Description"
                       id="PUBS-ID-00003-R4"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R5-->
<xsl:template match="irm:ICResourceMetadataPackage/irm:format/irm:mimeType"
                 priority="1013"
                 mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="irm:ICResourceMetadataPackage/irm:format/irm:mimeType"
                       id="PUBS-ID-00003-R5"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R7-->
<xsl:template match="pubs:NetworkAddress" priority="1012" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:NetworkAddress"
                       id="PUBS-ID-00003-R7"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R8-->
<xsl:template match="pubs:Appendix/pubs:Title" priority="1011" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Appendix/pubs:Title"
                       id="PUBS-ID-00003-R8"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R9-->
<xsl:template match="pubs:BibliographyDivision/pubs:Title"
                 priority="1010"
                 mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:BibliographyDivision/pubs:Title"
                       id="PUBS-ID-00003-R9"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R10-->
<xsl:template match="pubs:BibliographyEntry" priority="1009" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:BibliographyEntry"
                       id="PUBS-ID-00003-R10"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R11-->
<xsl:template match="pubs:Definition/pubs:Para" priority="1008" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Definition/pubs:Para"
                       id="PUBS-ID-00003-R11"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R12-->
<xsl:template match="pubs:DistributionEntry" priority="1007" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DistributionEntry"
                       id="PUBS-ID-00003-R12"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R13-->
<xsl:template match="pubs:GlossaryDivision/pubs:Title" priority="1006" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:GlossaryDivision/pubs:Title"
                       id="PUBS-ID-00003-R13"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R14-->
<xsl:template match="pubs:GlossaryTerm" priority="1005" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:GlossaryTerm"
                       id="PUBS-ID-00003-R14"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R15-->
<xsl:template match="pubs:IndexDivision/pubs:Title" priority="1004" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:IndexDivision/pubs:Title"
                       id="PUBS-ID-00003-R15"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R16-->
<xsl:template match="pubs:IndexEntry" priority="1003" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:IndexEntry"
                       id="PUBS-ID-00003-R16"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R17-->
<xsl:template match="pubs:ListItem" priority="1002" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ListItem"
                       id="PUBS-ID-00003-R17"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R18-->
<xsl:template match="pubs:LongDescription/pubs:Para" priority="1001" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:LongDescription/pubs:Para"
                       id="PUBS-ID-00003-R18"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00003-R19-->
<xsl:template match="pubs:Section/pubs:Title" priority="1000" mode="M58">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Section/pubs:Title"
                       id="PUBS-ID-00003-R19"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(.))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00003][Error]
            The element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> must have content.
            
            Human Readable: All of the following elements must have a value if they exist in an XML instance: irm:taskID, DescriptiveMetadata/Title, 
            DescriptiveMetadata/Description, irm:mimeType, NetworkAddress, Appendix/Title, 
            BibliographyDivision/Title, BibliographyEntry, Definition/Para, DistributionEntry, GlossaryDivision/Title, GlossaryTerm, 
            IndexDivision/Title, IndexEntry, ListItem, LongDescription/Para, Section/Title, DateString.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M58"/>
   <xsl:template match="@*|node()" priority="-2" mode="M58">
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00008-->


	<!--RULE PUBS-ID-00008-R1-->
<xsl:template match="pubs:DocumentBody" priority="1000" mode="M59">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DocumentBody"
                       id="PUBS-ID-00008-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length(normalize-space(string-join(descendant-or-self::text(),'')))&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string-length(normalize-space(string-join(descendant-or-self::text(),'')))&gt;0">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00008][Error] The IntelDoc element must have 
            element content in at least one of the descendent elements.
            
            Human Readable: Element IntelDoc must have content in at least one child element.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M59"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M59"/>
   <xsl:template match="@*|node()" priority="-2" mode="M59">
      <xsl:apply-templates select="*" mode="M59"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00009-->


	<!--RULE PUBS-ID-00009-R1-->
<xsl:template match="pubs:SourceReference" priority="1000" mode="M60">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:SourceReference"
                       id="PUBS-ID-00009-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(pubs:SourceID)) or normalize-space(string(pubs:DocumentID))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(pubs:SourceID)) or normalize-space(string(pubs:DocumentID))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00009][Error]
            For element SourceReference, either child element SourceID 
            or child element DocumentID must exist and must have a non-null value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M60"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M60"/>
   <xsl:template match="@*|node()" priority="-2" mode="M60">
      <xsl:apply-templates select="*" mode="M60"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00017-->


	<!--RULE PUBS-ID-00017-R1-->
<xsl:template match="cem:CountryName" priority="1000" mode="M61">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:CountryName"
                       id="PUBS-ID-00017-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@cem:countryCode and @cem:countryCodeVocabulary)             or not(@cem:countryCode or @cem:countryCodeVocabulary)             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(@cem:countryCode and @cem:countryCodeVocabulary) or not(@cem:countryCode or @cem:countryCodeVocabulary)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00017][Error]
            If element CountryName has either attribute countryCode or countryCodeVocabulary 
            is specified, then both must be specified.
            
            Human Readable: Element CountryName must have a value for both the countryCode and countryCodeVocabulary attributes.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M61"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M61"/>
   <xsl:template match="@*|node()" priority="-2" mode="M61">
      <xsl:apply-templates select="*" mode="M61"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00027-->


	<!--RULE PUBS-ID-00027-R1-->
<xsl:template match="pubs:ImageArea" priority="1000" mode="M62">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ImageArea"
                       id="PUBS-ID-00027-R1"/>
      <xsl:variable name="coordinatesAttr" select="normalize-space(string(@coordinates))"/>
      <xsl:variable name="shapeAttr" select="normalize-space(string(@shape))"/>
      <xsl:variable name="rectRegEx" select="'(-?[0-9]+,){3}-?[0-9]+$'"/>
      <xsl:variable name="circCoordinatesRegEx" select="'^(-?[0-9]+,){2}-?[0-9]+$'"/>
      <xsl:variable name="circPercentageRegEx"
                    select="'^(-?[0-9]+,){2}(0|[1-9][1-9]?|100)%$'"/>
      <xsl:variable name="polyRegEx" select="'^((-?[0-9]+,){2})*-?[0-9]+,-?[0-9]+$'"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="             if(string-length($coordinatesAttr) = 0 or string-length($shapeAttr) = 0)             then false()             else                 if($shapeAttr='rect')                 then matches(string($coordinatesAttr),$rectRegEx)                 else                     if($shapeAttr='circ')                     then matches(string($coordinatesAttr),$circCoordinatesRegEx) or matches($coordinatesAttr,$circPercentageRegEx)                     else                         if($shapeAttr='poly')                         then matches(string($coordinatesAttr),$polyRegEx)                         else                             false()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(string-length($coordinatesAttr) = 0 or string-length($shapeAttr) = 0) then false() else if($shapeAttr='rect') then matches(string($coordinatesAttr),$rectRegEx) else if($shapeAttr='circ') then matches(string($coordinatesAttr),$circCoordinatesRegEx) or matches($coordinatesAttr,$circPercentageRegEx) else if($shapeAttr='poly') then matches(string($coordinatesAttr),$polyRegEx) else false()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00027][Error]
            For element ImageArea attribute coordinates must be specified and the value 
            must be appropriate to the value of attribute shape as defined by the 
            PUBS.XML Data Element Dictionary.
            
            Human Readable: Element ImageArea attribute coordinates and shape must be specified.  The value for attribute coordinates has to 
            follow the format for the designated shape as defined by the PUBS.XML Data Element Dictionary.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M62"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M62"/>
   <xsl:template match="@*|node()" priority="-2" mode="M62">
      <xsl:apply-templates select="*" mode="M62"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00028-->


	<!--RULE PUBS-ID-00028-R2-->
<xsl:template match="pubs:AnimationExhibit" priority="1005" mode="M63">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AnimationExhibit"
                       id="PUBS-ID-00028-R2"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@xlink:href"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xlink:href">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00028][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> attribute xlink:href must be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00028-R3-->
<xsl:template match="pubs:AudioExhibit" priority="1004" mode="M63">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AudioExhibit"
                       id="PUBS-ID-00028-R3"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@xlink:href"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xlink:href">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00028][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> attribute xlink:href must be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00028-R4-->
<xsl:template match="pubs:Interactive3DExhibit" priority="1003" mode="M63">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Interactive3DExhibit"
                       id="PUBS-ID-00028-R4"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@xlink:href"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xlink:href">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00028][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> attribute xlink:href must be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00028-R5-->
<xsl:template match="pubs:OtherExhibit" priority="1002" mode="M63">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:OtherExhibit"
                       id="PUBS-ID-00028-R5"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@xlink:href"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xlink:href">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00028][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> attribute xlink:href must be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00028-R6-->
<xsl:template match="pubs:StillImageExhibit" priority="1001" mode="M63">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:StillImageExhibit"
                       id="PUBS-ID-00028-R6"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@xlink:href"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xlink:href">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00028][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> attribute xlink:href must be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00028-R7-->
<xsl:template match="pubs:VideoExhibit" priority="1000" mode="M63">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:VideoExhibit"
                       id="PUBS-ID-00028-R7"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@xlink:href"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xlink:href">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00028][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> attribute xlink:href must be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M63"/>
   <xsl:template match="@*|node()" priority="-2" mode="M63">
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00030-->


	<!--RULE PUBS-ID-00030-R1-->
<xsl:template match="pubs:Glossary" priority="1000" mode="M64">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Glossary"
                       id="PUBS-ID-00030-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(pubs:GlossaryDivision) != 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(pubs:GlossaryDivision) != 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00030][Error]
            For element Glossary, if child element GlossaryDivision is used, there 
            must be at least two instances of element GlossaryDivision.
            
            Human Readable: Element Glossary child element GlossaryDivision requires more than one instance.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M64"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M64"/>
   <xsl:template match="@*|node()" priority="-2" mode="M64">
      <xsl:apply-templates select="*" mode="M64"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00031-->


	<!--RULE PUBS-ID-00031-R1-->
<xsl:template match="pubs:Bibliography" priority="1000" mode="M65">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Bibliography"
                       id="PUBS-ID-00031-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(pubs:BibliographyDivision) != 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(pubs:BibliographyDivision) != 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00031][Error]
            For element Bibliography, if child element BibliographyDivision is used, there 
            must be at least two instances of element BibliographyDivision.
            
            Human Readable: Element Bibliography child element BibliographyDivision requires more than one instance.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M65"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M65"/>
   <xsl:template match="@*|node()" priority="-2" mode="M65">
      <xsl:apply-templates select="*" mode="M65"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00032-->


	<!--RULE PUBS-ID-00032-R1-->
<xsl:template match="pubs:Index" priority="1000" mode="M66">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Index"
                       id="PUBS-ID-00032-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(pubs:IndexDivision) != 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(pubs:IndexDivision) != 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00032][Error]
            For element Index, if child element IndexDivision is used, there 
            must be at least two instances of element IndexDivision.
            
            Human Readable: Element Index child element IndexDivision requires more than one instance.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M66"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M66"/>
   <xsl:template match="@*|node()" priority="-2" mode="M66">
      <xsl:apply-templates select="*" mode="M66"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00033-->


	<!--RULE PUBS-ID-00033-R1-->
<xsl:template match="pubs:ImageMap" priority="1000" mode="M67">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ImageMap"
                       id="PUBS-ID-00033-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(@id))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(@id))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00033][Error] Element ImageMap must specify attribute id.
            
            Human Readable: Element ImageMap must have a value for attribute id.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M67"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M67"/>
   <xsl:template match="@*|node()" priority="-2" mode="M67">
      <xsl:apply-templates select="*" mode="M67"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00034-->


	<!--RULE PUBS-ID-00034-R1-->
<xsl:template match="pubs:StillImageExhibit[@imageMapReference]"
                 priority="1000"
                 mode="M68">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:StillImageExhibit[@imageMapReference]"
                       id="PUBS-ID-00034-R1"/>
      <xsl:variable name="imageMapReference" select="@imageMapReference"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="ancestor::tdf:TrustedDataObject//pubs:ImageMap[@id=$imageMapReference]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::tdf:TrustedDataObject//pubs:ImageMap[@id=$imageMapReference]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00034][Error]
            For a given attribute imageMapReference value for element StillImageExhibit, there 
            must be an attribute id for element ImageMap with an identical value within the XML instance.
            
            Human Readable: Element StillImageExhibit attribute imageMapReference value must equal element ImageMap attribute id value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M68"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M68"/>
   <xsl:template match="@*|node()" priority="-2" mode="M68">
      <xsl:apply-templates select="*" mode="M68"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00035-->


	<!--RULE PUBS-ID-00035-R1-->
<xsl:template match="pubs:*[@xlink:type='simple']" priority="1000" mode="M69">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@xlink:type='simple']"
                       id="PUBS-ID-00035-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(@xlink:href))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(@xlink:href))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00035][Error]
            All links that have attribute xlink:type specified with a value
            of [simple] must also have attribute xlink:href specified.
            
            Human Readable: If attribute xlink:type value is [simple], then attribute xlink:href has to have a value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M69"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M69"/>
   <xsl:template match="@*|node()" priority="-2" mode="M69">
      <xsl:apply-templates select="*" mode="M69"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00036-->


	<!--RULE PUBS-ID-00036-R2-->
<xsl:template match="pubs:Link" priority="1001" mode="M70">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Link"
                       id="PUBS-ID-00036-R2"/>
      <xsl:variable name="fragementIdentifier" select="substring(@xlink:href,2)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(starts-with(@xlink:href,'#'))                then ancestor::tdf:TrustedDataObject//*[@id=$fragementIdentifier]                   else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(starts-with(@xlink:href,'#')) then ancestor::tdf:TrustedDataObject//*[@id=$fragementIdentifier] else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00036][Error]
            Internal links must be traversable. If the attribute xlink:href value for elements Link and ImageArea 
            is a URL fragment identifier with a [#] prefix, that fragment identifier must match the attribute id 
            value of an element within the XML instance. Note that a fragment identifier is characterized by 
            a [#] prefix. The [#] prefix is not part of the fragment identifier. So when the xlink:href attribute 
            value starts with a [#], the remainder of the value is the fragment identifier. This rule does not apply 
            to attribute values which contain a URL and a fragment identifier separated by [#], in which case it can 
            not be determined with certainty that the target is within the XML instance.
            
            Human Readable: If the elements Link and ImageArea attribute xlink:href value starts with [#], then 
            the fragment identifier portion of the value of attribute xlink:href must match 
            the value of any attribute id specified within the XML instance.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00036-R3-->
<xsl:template match="pubs:ImageArea" priority="1000" mode="M70">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ImageArea"
                       id="PUBS-ID-00036-R3"/>
      <xsl:variable name="fragementIdentifier" select="substring(@xlink:href,2)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(starts-with(@xlink:href,'#'))                then ancestor::tdf:TrustedDataObject//*[@id=$fragementIdentifier]                   else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(starts-with(@xlink:href,'#')) then ancestor::tdf:TrustedDataObject//*[@id=$fragementIdentifier] else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00036][Error]
            Internal links must be traversable. If the attribute xlink:href value for elements Link and ImageArea 
            is a URL fragment identifier with a [#] prefix, that fragment identifier must match the attribute id 
            value of an element within the XML instance. Note that a fragment identifier is characterized by 
            a [#] prefix. The [#] prefix is not part of the fragment identifier. So when the xlink:href attribute 
            value starts with a [#], the remainder of the value is the fragment identifier. This rule does not apply 
            to attribute values which contain a URL and a fragment identifier separated by [#], in which case it can 
            not be determined with certainty that the target is within the XML instance.
            
            Human Readable: If the elements Link and ImageArea attribute xlink:href value starts with [#], then 
            the fragment identifier portion of the value of attribute xlink:href must match 
            the value of any attribute id specified within the XML instance.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M70"/>
   <xsl:template match="@*|node()" priority="-2" mode="M70">
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00040-->
<xsl:variable name="minYear" select="1901"/>
   <xsl:variable name="maxYear" select="$currentYear"/>

	  <!--RULE PUBS-ID-00040-R3-->
<xsl:template match="pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished"
                 priority="1002"
                 mode="M71">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished"
                       id="PUBS-ID-00040-R3"/>
      <xsl:variable name="dateValue" select="."/>
      <xsl:variable name="errMsg"
                    select="    concat('[PUBS-ID-00040][Error]    The permissible values for the year range are 1901 through the current year     for element ', name())"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00040-R4-->
<xsl:template match="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateReviewed"
                 priority="1001"
                 mode="M71">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateReviewed"
                       id="PUBS-ID-00040-R4"/>
      <xsl:variable name="dateValue" select="."/>
      <xsl:variable name="errMsg"
                    select="    concat('[PUBS-ID-00040][Error]    The permissible values for the year range are 1901 through the current year     for element ', name())"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00040-R5-->
<xsl:template match="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised"
                 priority="1000"
                 mode="M71">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised"
                       id="PUBS-ID-00040-R5"/>
      <xsl:variable name="dateValue" select="."/>
      <xsl:variable name="errMsg"
                    select="    concat('[PUBS-ID-00040][Error]    The permissible values for the year range are 1901 through the current year     for element ', name())"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M71"/>
   <xsl:template match="@*|node()" priority="-2" mode="M71">
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00042-->


	<!--RULE PUBS-ID-00042-R1-->
<xsl:template match="pubs:DateTimeReferenced" priority="1004" mode="M72">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DateTimeReferenced"
                       id="PUBS-ID-00042-R1"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateValue" select="."/>
      <xsl:variable name="errMsg"
                    select="'             [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999 for element DateTimeReferenced.             '"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00042-R2-->
<xsl:template match="pubs:*[@date]" priority="1003" mode="M72">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@date]"
                       id="PUBS-ID-00042-R2"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateValue" select="./@date"/>
      <xsl:variable name="errMsg"
                    select="'    [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999    for attributes date.    '"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00042-R3-->
<xsl:template match="cem:*[@cem:dateTime]" priority="1002" mode="M72">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:*[@cem:dateTime]"
                       id="PUBS-ID-00042-R3"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateValue" select="./@cem:dateTime"/>
      <xsl:variable name="errMsg"
                    select="'    [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999    for attributes dateTime.    '"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00042-R4-->
<xsl:template match="cem:*[@cem:normalizedDate]" priority="1001" mode="M72">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:*[@cem:normalizedDate]"
                       id="PUBS-ID-00042-R4"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateValue" select="./@cem:normalizedDate"/>
      <xsl:variable name="errMsg"
                    select="'    [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999    for attributes normalizedDate.    '"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00042-R5-->
<xsl:template match="cem:*[@cem:normalizedDateTime]" priority="1000" mode="M72">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:*[@cem:normalizedDateTime]"
                       id="PUBS-ID-00042-R5"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateValue" select="./@cem:normalizedDateTime"/>
      <xsl:variable name="errMsg"
                    select="'    [PUBS-ID-00042][Error] The permissible values for the year range are 0001 through 9999    for attributes normalizedDateTime.    '"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M72"/>
   <xsl:template match="@*|node()" priority="-2" mode="M72">
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00045-->


	<!--RULE PUBS-ID-00045-R1-->
<xsl:template match="irm:ICResourceMetadataPackage/irm:dates[@irm:approvedOn]"
                 priority="1000"
                 mode="M73">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="irm:ICResourceMetadataPackage/irm:dates[@irm:approvedOn]"
                       id="PUBS-ID-00045-R1"/>
      <xsl:variable name="secondaryDateList"
                    select="(ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, @irm:posted)"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="             every $secondaryDate in $secondaryDateList satisfies                 dtf:compareDateTimeRanges(string(@irm:approvedOn), '&lt;=', string($secondaryDate))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $secondaryDate in $secondaryDateList satisfies dtf:compareDateTimeRanges(string(@irm:approvedOn), '&lt;=', string($secondaryDate))">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00045][Warning][PUBS-ID-00045][Warning] irm:dates/@approvedOn must
        	be earlier than or equivalent to pubs:DatePublished and DatePosted.
        	
        	Human Readable: irm:dates/@approvedOn has to be less than or equal to pubs:DatePublished and DatePosted.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M73"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M73"/>
   <xsl:template match="@*|node()" priority="-2" mode="M73">
      <xsl:apply-templates select="*" mode="M73"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00046-->


	<!--RULE -->
<xsl:template match="tdf:*[descendant::tdf:StructuredPayload/pubs:IntelDoc]//tdf:Assertion//irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end"
                 priority="1000"
                 mode="M74">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:*[descendant::tdf:StructuredPayload/pubs:IntelDoc]//tdf:Assertion//irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'warning')             then every $secondaryDate in (ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                   ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                           ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:posted) satisfies                     dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate))             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'warning') then every $secondaryDate in (ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn, ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:posted) satisfies dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate)) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="' [PUBS-ID-00046][Error] DateInfoCutoff must                   be earlier than or equivalent to DateApproved, DatePublished                   and DatePosted.                 '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'error')             then every $secondaryDate in (ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                   ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                           ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:posted) satisfies                     dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate))                 else true()                 "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'error') then every $secondaryDate in (ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn, ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, ancestor::irm:ICResourceMetadataPackage/irm:dates/@irm:posted) satisfies dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate)) else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="' [PUBS-ID-00046][Error] DateInfoCutoff must                   be earlier than or equivalent to DateApproved, DatePublished                   and DatePosted.                 '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M74"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M74"/>
   <xsl:template match="@*|node()" priority="-2" mode="M74">
      <xsl:apply-templates select="*" mode="M74"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00047-->


	<!--RULE PUBS-ID-00047-R1-->
<xsl:template match="tdf:*[descendant::tdf:StructuredPayload[pubs:IntelDoc]]/tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:dates[@irm:validTil]"
                 priority="1000"
                 mode="M75">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:*[descendant::tdf:StructuredPayload[pubs:IntelDoc]]/tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:dates[@irm:validTil]"
                       id="PUBS-ID-00047-R1"/>
      <xsl:variable name="secondaryDateList"
                    select="(@irm:approvedOn, @irm:infoCutOff, ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, @irm:posted, ancestor::irm:ICResourceMetadataPackage/irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end )"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test=" every $secondaryDate in $secondaryDateList satisfies dtf:compareDateTimeRanges(string(@irm:validTil), '&gt;=', string($secondaryDate))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $secondaryDate in $secondaryDateList satisfies dtf:compareDateTimeRanges(string(@irm:validTil), '&gt;=', string($secondaryDate))">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00047][Warning] DateValidTil must be later than or equivalent
            to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.
            
            Human Readable: DateValidTil has to be greater than or equal to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M75"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M75"/>
   <xsl:template match="@*|node()" priority="-2" mode="M75">
      <xsl:apply-templates select="*" mode="M75"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00048-->


	<!--RULE -->
<xsl:template match="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised"
                 priority="1000"
                 mode="M76">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('warning' = 'warning')             then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                                   ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                                   ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted,                ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:infoCutOff,            ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end) satisfies                     dtf:compareDateTimeRanges(string(.), '&gt;=', string($secondaryDate))             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('warning' = 'warning') then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn, ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted, ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:infoCutOff, ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end) satisfies dtf:compareDateTimeRanges(string(.), '&gt;=', string($secondaryDate)) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'[PUBS-ID-00048][Warning] DateRevised must be later than or equivalent to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.'"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('warning' = 'error')             then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                                   ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                                   ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted,                ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:infoCutOff,            ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end) satisfies                     dtf:compareDateTimeRanges(string(.), '&gt;=', string($secondaryDate))                 else true()                 "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('warning' = 'error') then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn, ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted, ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:infoCutOff, ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:temporalCoverage[irm:name='infoCutOff']/irm:approximableEnd/irm:searchableDate/irm:end) satisfies dtf:compareDateTimeRanges(string(.), '&gt;=', string($secondaryDate)) else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'[PUBS-ID-00048][Warning] DateRevised must be later than or equivalent to DateApproved, DatePublished, DatePosted, and DateInfoCutoff.'"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M76"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M76"/>
   <xsl:template match="@*|node()" priority="-2" mode="M76">
      <xsl:apply-templates select="*" mode="M76"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00049-->


	<!--RULE -->
<xsl:template match="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised"
                 priority="1000"
                 mode="M77">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateRevised"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'warning')             then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:validTil) satisfies                     dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate))             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'warning') then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:validTil) satisfies dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate)) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'[PUBS-ID-00049][Error] DateRevised must be earlier than or equivalent to DateValidTil.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'error')             then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:validTil) satisfies                     dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate))                 else true()                 "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'error') then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:validTil) satisfies dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate)) else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'[PUBS-ID-00049][Error] DateRevised must be earlier than or equivalent to DateValidTil.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M77"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M77"/>
   <xsl:template match="@*|node()" priority="-2" mode="M77">
      <xsl:apply-templates select="*" mode="M77"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00050-->


	<!--RULE -->
<xsl:template match="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateReviewed"
                 priority="1000"
                 mode="M78">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AdministrativeMetadata/pubs:DateList/pubs:DateReviewed"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('warning' = 'warning')             then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                      ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                      ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted) satisfies                     dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate))             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('warning' = 'warning') then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn, ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted) satisfies dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate)) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'[PUBS-ID-00050][Warning] DateReviewed must be earlier than or equivalent to DateApproved, DatePublished, and DatePosted.  '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('warning' = 'error')             then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn,                      ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished,                      ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted) satisfies                     dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate))                 else true()                 "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('warning' = 'error') then every $secondaryDate in (ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:approvedOn, ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, ancestor::tdf:*//irm:ICResourceMetadataPackage/irm:dates/@irm:posted) satisfies dtf:compareDateTimeRanges(string(.), '&lt;=', string($secondaryDate)) else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'[PUBS-ID-00050][Warning] DateReviewed must be earlier than or equivalent to DateApproved, DatePublished, and DatePosted.  '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M78"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M78"/>
   <xsl:template match="@*|node()" priority="-2" mode="M78">
      <xsl:apply-templates select="*" mode="M78"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00053-->


	<!--RULE PUBS-ID-00053-R1-->
<xsl:template match="pubs:PostalAddress" priority="1000" mode="M79">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:PostalAddress"
                       id="PUBS-ID-00053-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="some $child in (pubs:AddressLine | pubs:City | pubs:State | pubs:Province | pubs:PostalCode | pubs:CountryCode) satisfies                     normalize-space(string($child))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $child in (pubs:AddressLine | pubs:City | pubs:State | pubs:Province | pubs:PostalCode | pubs:CountryCode) satisfies normalize-space(string($child))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00053][Error]
            For any element PostalAddress, at least one of its child elements 
            AddressLine, City, State, Province, PostalCode, or CountryCode must 
            have element content.    
            
            Human Readable: Element PostalAddress must have a value for at least one of its child elements.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M79"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M79"/>
   <xsl:template match="@*|node()" priority="-2" mode="M79">
      <xsl:apply-templates select="*" mode="M79"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00054-->


	<!--RULE PUBS-ID-00054-R3-->
<xsl:template match="pubs:ApproximableDateTime" priority="1003" mode="M80">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ApproximableDateTime"
                       id="PUBS-ID-00054-R3"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))                         then matches(string($valueTest),$endsWithTimeZoneRegEx)                           else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [PUBS-ID-00054][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designator (T) is specified for element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00054-R4-->
<xsl:template match="irm:ICResourceMetadataPackage/irm:temporalCoverage/irm:approximableStart/irm:approximableDate"
                 priority="1002"
                 mode="M80">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="irm:ICResourceMetadataPackage/irm:temporalCoverage/irm:approximableStart/irm:approximableDate"
                       id="PUBS-ID-00054-R4"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))                         then matches(string($valueTest),$endsWithTimeZoneRegEx)                           else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [PUBS-ID-00054][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designator (T) is specified for element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00054-R5-->
<xsl:template match="irm:ICResourceMetadataPackage/irm:temporalCoverage/irm:approximableEnd/irm:approximableDate"
                 priority="1001"
                 mode="M80">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="irm:ICResourceMetadataPackage/irm:temporalCoverage/irm:approximableEnd/irm:approximableDate"
                       id="PUBS-ID-00054-R5"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))                         then matches(string($valueTest),$endsWithTimeZoneRegEx)                           else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [PUBS-ID-00054][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designator (T) is specified for element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00054-R6-->
<xsl:template match="pubs:DateString" priority="1000" mode="M80">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DateString"
                       id="PUBS-ID-00054-R6"/>
      <xsl:variable name="valueTest" select="."/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="if (contains(string($valueTest),'T'))                         then matches(string($valueTest),$endsWithTimeZoneRegEx)                           else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (contains(string($valueTest),'T')) then matches(string($valueTest),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
          [PUBS-ID-00054][Warning]
          For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>, if the time designator (T) is specified, it is recommended that time zone be specified.    
          
          Human Readable: It is recommended that time zone be specified if time designator (T) is specified for element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/>.
      </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M80"/>
   <xsl:template match="@*|node()" priority="-2" mode="M80">
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00062-->


	<!--RULE -->
<xsl:template match="cem:QuantityReference[@cem:unitOfMeasureVocabulary='UNECE20']"
                 priority="1000"
                 mode="M81">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:QuantityReference[@cem:unitOfMeasureVocabulary='UNECE20']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $unce20UnitsOfMeasureList satisfies              compare($token,normalize-space(@cem:unitOfMeasure)) = 0             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $unce20UnitsOfMeasureList satisfies compare($token,normalize-space(@cem:unitOfMeasure)) = 0">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [PUBS-ID-00062][Error]         If the element QuantityReference has the attribute unitOfMeasureVocabulary          with a value of UNECE20 the value of attribute unitOfMeasure must be          in CVEnumUNCE20UnitsOfMeasure.xml.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M81"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M81"/>
   <xsl:template match="@*|node()" priority="-2" mode="M81">
      <xsl:apply-templates select="*" mode="M81"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00063-->


	<!--RULE -->
<xsl:template match="cem:QuantityReference[@cem:unitOfMeasureVocabulary='ISO4217-3']"
                 priority="1000"
                 mode="M82">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:QuantityReference[@cem:unitOfMeasureVocabulary='ISO4217-3']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $iso4217TrigraphList satisfies              compare($token,normalize-space(@cem:unitOfMeasure)) = 0             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $iso4217TrigraphList satisfies compare($token,normalize-space(@cem:unitOfMeasure)) = 0">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [PUBS-ID-00063][Error]         If the element QuantityReference has the attribute unitOfMeasureVocabulary          with a value of ISO4217-3 the value of attribute unitOfMeasure must be          in CVEnumISO4217Trigraph.xml.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M82"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M82"/>
   <xsl:template match="@*|node()" priority="-2" mode="M82">
      <xsl:apply-templates select="*" mode="M82"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00064-->


	<!--RULE -->
<xsl:template match="cem:QuantityReference[@cem:unitOfMeasureVocabulary='ISO4217-NR']"
                 priority="1000"
                 mode="M83">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:QuantityReference[@cem:unitOfMeasureVocabulary='ISO4217-NR']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $iso4217NumericList satisfies              compare($token,normalize-space(@cem:unitOfMeasure)) = 0             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $iso4217NumericList satisfies compare($token,normalize-space(@cem:unitOfMeasure)) = 0">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [PUBS-ID-00064][Error]         If the element QuantityReference has the attribute unitOfMeasureVocabulary with a value          of ISO4217-NR the value of attribute unitOfMeasure must be in CVEnumISO4217Numeric.xml.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M83"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M83"/>
   <xsl:template match="@*|node()" priority="-2" mode="M83">
      <xsl:apply-templates select="*" mode="M83"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00065-->


	<!--RULE PUBS-ID-00065-R2-->
<xsl:template match="pubs:AuthorInfo" priority="1003" mode="M84">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:AuthorInfo"
                       id="PUBS-ID-00065-R2"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="pubs:Surname[normalize-space(string(text()))]             or pubs:UserID[normalize-space(string(text()))]             or pubs:JobTitle[normalize-space(string(text()))]             or pubs:Affiliation[normalize-space(string(text()))]             or pubs:OfficeName[normalize-space(string(text()))]             or pubs:PhoneNumber[normalize-space(string(text()))]             or pubs:FaxNumber[normalize-space(string(text()))]             or pubs:EmailAddress[normalize-space(string(text()))]             or pubs:WebPageAddress[normalize-space(string(text()))]             or pubs:FormattedSignatureBlock[normalize-space(string(text()))]                   or (some $token in pubs:PostalAddress/*/text() satisfies                      normalize-space(string($token)))             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="pubs:Surname[normalize-space(string(text()))] or pubs:UserID[normalize-space(string(text()))] or pubs:JobTitle[normalize-space(string(text()))] or pubs:Affiliation[normalize-space(string(text()))] or pubs:OfficeName[normalize-space(string(text()))] or pubs:PhoneNumber[normalize-space(string(text()))] or pubs:FaxNumber[normalize-space(string(text()))] or pubs:EmailAddress[normalize-space(string(text()))] or pubs:WebPageAddress[normalize-space(string(text()))] or pubs:FormattedSignatureBlock[normalize-space(string(text()))] or (some $token in pubs:PostalAddress/*/text() satisfies normalize-space(string($token)))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00065][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> at least one of the following child elements must have non-whitespace content:  
            Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
            
            Human Readable: Elements AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo must have a value for at least one of the following
            child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00065-R3-->
<xsl:template match="pubs:CoauthorInfo" priority="1002" mode="M84">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:CoauthorInfo"
                       id="PUBS-ID-00065-R3"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="pubs:Surname[normalize-space(string(text()))]             or pubs:UserID[normalize-space(string(text()))]             or pubs:JobTitle[normalize-space(string(text()))]             or pubs:Affiliation[normalize-space(string(text()))]             or pubs:OfficeName[normalize-space(string(text()))]             or pubs:PhoneNumber[normalize-space(string(text()))]             or pubs:FaxNumber[normalize-space(string(text()))]             or pubs:EmailAddress[normalize-space(string(text()))]             or pubs:WebPageAddress[normalize-space(string(text()))]             or pubs:FormattedSignatureBlock[normalize-space(string(text()))]                   or (some $token in pubs:PostalAddress/*/text() satisfies                      normalize-space(string($token)))             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="pubs:Surname[normalize-space(string(text()))] or pubs:UserID[normalize-space(string(text()))] or pubs:JobTitle[normalize-space(string(text()))] or pubs:Affiliation[normalize-space(string(text()))] or pubs:OfficeName[normalize-space(string(text()))] or pubs:PhoneNumber[normalize-space(string(text()))] or pubs:FaxNumber[normalize-space(string(text()))] or pubs:EmailAddress[normalize-space(string(text()))] or pubs:WebPageAddress[normalize-space(string(text()))] or pubs:FormattedSignatureBlock[normalize-space(string(text()))] or (some $token in pubs:PostalAddress/*/text() satisfies normalize-space(string($token)))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00065][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> at least one of the following child elements must have non-whitespace content:  
            Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
            
            Human Readable: Elements AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo must have a value for at least one of the following
            child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00065-R4-->
<xsl:template match="pubs:ContributingAuthorInfo" priority="1001" mode="M84">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:ContributingAuthorInfo"
                       id="PUBS-ID-00065-R4"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="pubs:Surname[normalize-space(string(text()))]             or pubs:UserID[normalize-space(string(text()))]             or pubs:JobTitle[normalize-space(string(text()))]             or pubs:Affiliation[normalize-space(string(text()))]             or pubs:OfficeName[normalize-space(string(text()))]             or pubs:PhoneNumber[normalize-space(string(text()))]             or pubs:FaxNumber[normalize-space(string(text()))]             or pubs:EmailAddress[normalize-space(string(text()))]             or pubs:WebPageAddress[normalize-space(string(text()))]             or pubs:FormattedSignatureBlock[normalize-space(string(text()))]                   or (some $token in pubs:PostalAddress/*/text() satisfies                      normalize-space(string($token)))             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="pubs:Surname[normalize-space(string(text()))] or pubs:UserID[normalize-space(string(text()))] or pubs:JobTitle[normalize-space(string(text()))] or pubs:Affiliation[normalize-space(string(text()))] or pubs:OfficeName[normalize-space(string(text()))] or pubs:PhoneNumber[normalize-space(string(text()))] or pubs:FaxNumber[normalize-space(string(text()))] or pubs:EmailAddress[normalize-space(string(text()))] or pubs:WebPageAddress[normalize-space(string(text()))] or pubs:FormattedSignatureBlock[normalize-space(string(text()))] or (some $token in pubs:PostalAddress/*/text() satisfies normalize-space(string($token)))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00065][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> at least one of the following child elements must have non-whitespace content:  
            Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
            
            Human Readable: Elements AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo must have a value for at least one of the following
            child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00065-R5-->
<xsl:template match="pubs:POCinfo" priority="1000" mode="M84">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:POCinfo"
                       id="PUBS-ID-00065-R5"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="pubs:Surname[normalize-space(string(text()))]             or pubs:UserID[normalize-space(string(text()))]             or pubs:JobTitle[normalize-space(string(text()))]             or pubs:Affiliation[normalize-space(string(text()))]             or pubs:OfficeName[normalize-space(string(text()))]             or pubs:PhoneNumber[normalize-space(string(text()))]             or pubs:FaxNumber[normalize-space(string(text()))]             or pubs:EmailAddress[normalize-space(string(text()))]             or pubs:WebPageAddress[normalize-space(string(text()))]             or pubs:FormattedSignatureBlock[normalize-space(string(text()))]                   or (some $token in pubs:PostalAddress/*/text() satisfies                      normalize-space(string($token)))             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="pubs:Surname[normalize-space(string(text()))] or pubs:UserID[normalize-space(string(text()))] or pubs:JobTitle[normalize-space(string(text()))] or pubs:Affiliation[normalize-space(string(text()))] or pubs:OfficeName[normalize-space(string(text()))] or pubs:PhoneNumber[normalize-space(string(text()))] or pubs:FaxNumber[normalize-space(string(text()))] or pubs:EmailAddress[normalize-space(string(text()))] or pubs:WebPageAddress[normalize-space(string(text()))] or pubs:FormattedSignatureBlock[normalize-space(string(text()))] or (some $token in pubs:PostalAddress/*/text() satisfies normalize-space(string($token)))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00065][Error]
            For element <xsl:text/>
                  <xsl:value-of select="name(.)"/>
                  <xsl:text/> at least one of the following child elements must have non-whitespace content:  
            Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
            
            Human Readable: Elements AuthorInfo, CoauthorInfo, ContributingAuthorInfo, POCinfo must have a value for at least one of the following
            child elements: Surname, UserID, JobTitle, Affiliation, OfficeName, PostalAddress, PhoneNumber, FaxNumber, 
            EmailAddress, WebPageAddress, FormattedSignatureBlock.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M84"/>
   <xsl:template match="@*|node()" priority="-2" mode="M84">
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00070-->


	<!--RULE PUBS-ID-00070-R1-->
<xsl:template match="tdf:*[descendant::tdf:StructuredPayload[pubs:IntelDoc]]/tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:type[@irm:qualifier='RevisionRecallDesignations']"
                 priority="1000"
                 mode="M85">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:*[descendant::tdf:StructuredPayload[pubs:IntelDoc]]/tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:type[@irm:qualifier='RevisionRecallDesignations']"
                       id="PUBS-ID-00070-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> [PUBS-ID-00070][Error] Element irm:type must not
            have the attribute irm:qualifier with a value of RevisionRecallDesignations. The
            required practice for conveying Revision Recall is to use a RevisionRecall handling
            assertion introduced in the 2014 DEC Revision Recall specification.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M85"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M85"/>
   <xsl:template match="@*|node()" priority="-2" mode="M85">
      <xsl:apply-templates select="*" mode="M85"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00072-->


	<!--RULE -->
<xsl:template match="cem:CountryName[@cem:countryCodeVocabulary='ISO-3']"
                 priority="1000"
                 mode="M86">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:CountryName[@cem:countryCodeVocabulary='ISO-3']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $countryIso3166TrigraphList satisfies              compare($token,normalize-space(@cem:countryCode)) = 0             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $countryIso3166TrigraphList satisfies compare($token,normalize-space(@cem:countryCode)) = 0">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [PUBS-ID-00072][Error]         If element CountryName has attribute countryCodeVocabulary specified as ISO-3         the attribute countryCode value must be in CVEnumPubsCountryISO3166Trigraph.xml         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M86"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M86"/>
   <xsl:template match="@*|node()" priority="-2" mode="M86">
      <xsl:apply-templates select="*" mode="M86"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00079-->


	<!--RULE PUBS-ID-00079-R1-->
<xsl:template match="pubs:DescriptiveMetadata/pubs:Title | tdf:*[descendant::tdf:StructuredPayload[pubs:IntelDoc]]/tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:title"
                 priority="1000"
                 mode="M87">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DescriptiveMetadata/pubs:Title | tdf:*[descendant::tdf:StructuredPayload[pubs:IntelDoc]]/tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:title"
                       id="PUBS-ID-00079-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="             if(starts-with(upper-case(.),'ADMINISTRATIVE RECALL')                 or starts-with(upper-case(.),'ADMINISTRATIVE REVISION')                 or starts-with(upper-case(.),'SUBSTANTIVE RECALL')                 or starts-with(upper-case(.),'SUBSTANTIVE REVISION')             ) then false()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(starts-with(upper-case(.),'ADMINISTRATIVE RECALL') or starts-with(upper-case(.),'ADMINISTRATIVE REVISION') or starts-with(upper-case(.),'SUBSTANTIVE RECALL') or starts-with(upper-case(.),'SUBSTANTIVE REVISION') ) then false() else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00079][Error] Element DescriptiveMetadata/Title must not start with any of the following strings
            ADMINISTRATIVE RECALL, or ADMINISTRATIVE REVISION, or SUBSTANTIVE RECALL, or SUBSTANTIVE REVISION.
            
            Human Readable: Element DescriptiveMetadata/Title cannot start with any of the following strings: ADMINISTRATIVE RECALL, or 
            ADMINISTRATIVE REVISION, or SUBSTANTIVE RECALL, or SUBSTANTIVE REVISION.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M87"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M87"/>
   <xsl:template match="@*|node()" priority="-2" mode="M87">
      <xsl:apply-templates select="*" mode="M87"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00080-->


	<!--RULE PUBS-ID-00080-R1-->
<xsl:template match="pubs:*[@ism:excludeFromRollup]" priority="1000" mode="M88">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@ism:excludeFromRollup]"
                       id="PUBS-ID-00080-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="self::pubs:ReferencedResourceSecurity"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="self::pubs:ReferencedResourceSecurity">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00080][Error]
            The attribute ism:excludeFromRollup must not be specified for any element in the 
            namespace urn:us:gov:ic:pubs except ReferencedResourceSecurity.
            
            Human Readable: Attribute ism:excluedFromRollup is only permitted with element ReferenceResourceSecurity in the urn:us:gov:ic:pubs
            namespace.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M88"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M88"/>
   <xsl:template match="@*|node()" priority="-2" mode="M88">
      <xsl:apply-templates select="*" mode="M88"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00082-->


	<!--RULE PUBS-ID-00082-R1-->
<xsl:template match="pubs:*[@ism:noticeType][not(self::pubs:Note | self::pubs:AuthorInfo | self::pubs:NoteInline | self::pubs:IntelDoc | self::pubs:CoauthorInfo | self::pubs:ContributingAuthorInfo | self::pubs:POCinfo)]"
                 priority="1000"
                 mode="M89">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@ism:noticeType][not(self::pubs:Note | self::pubs:AuthorInfo | self::pubs:NoteInline | self::pubs:IntelDoc | self::pubs:CoauthorInfo | self::pubs:ContributingAuthorInfo | self::pubs:POCinfo)]"
                       id="PUBS-ID-00082-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00082][Error]
            The attribute ism:noticeType must not be specified for any element in 
            the namespace urn:us:gov:ic:pubs except IntelDoc, Note, NoteInline, AuthorInfo, CoauthorInfo, ContributingAuthorInfo, or POCinfo.
            
            Human Readable: Attribute ism:noticeType can only exist in the namespace urn:us:gov:ic:pubs for the following elements: IntelDoc, Note, 
            NoteInline, AuthorInfo, CoauthorInfo, ContributingAuthorInfo, or POCinfo.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M89"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M89"/>
   <xsl:template match="@*|node()" priority="-2" mode="M89">
      <xsl:apply-templates select="*" mode="M89"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00086-->


	<!--RULE PUBS-ID-00086-R1-->
<xsl:template match="pubs:PublicationMetadataList[count(pubs:PublicationMetadata) &gt; 1]/pubs:PublicationMetadata"
                 priority="1000"
                 mode="M90">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:PublicationMetadataList[count(pubs:PublicationMetadata) &gt; 1]/pubs:PublicationMetadata"
                       id="PUBS-ID-00086-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@ism:classification"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ism:classification">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00086][Error] When there are multiple PublicationMetadata each must be security portion marked 
            to facilitate use of PublicationMetadata at a different level than the document.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M90"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M90"/>
   <xsl:template match="@*|node()" priority="-2" mode="M90">
      <xsl:apply-templates select="*" mode="M90"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00087-->


	<!--RULE PUBS-ID-00087-R1-->
<xsl:template match="pubs:DateInformation" priority="1000" mode="M91">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DateInformation"
                       id="PUBS-ID-00087-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(pubs:DateString)) or normalize-space(string(pubs:ApproximableDateTime)) or normalize-space(string(pubs:SearchableDateTime/pubs:EarliestStartDate)) or normalize-space(string(pubs:SearchableDateTime/pubs:LatestEndDate))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(pubs:DateString)) or normalize-space(string(pubs:ApproximableDateTime)) or normalize-space(string(pubs:SearchableDateTime/pubs:EarliestStartDate)) or normalize-space(string(pubs:SearchableDateTime/pubs:LatestEndDate))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00087][Error]
            If the DateInformation element exists, at least one of its child 
            elements DateString, ApproximableDateTime, or SearchableDateTime must be present.
            
            Human Readable: Element DateInformation must have a value for one of its child elements.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M91"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M91"/>
   <xsl:template match="@*|node()" priority="-2" mode="M91">
      <xsl:apply-templates select="*" mode="M91"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00092-->


	<!--RULE PUBS-ID-00092-R2-->
<xsl:template match="pubs:DateInformation/pubs:ApproximableDateTime"
                 priority="1002"
                 mode="M92">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DateInformation/pubs:ApproximableDateTime"
                       id="PUBS-ID-00092-R2"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateValue" select="."/>
      <xsl:variable name="errMsg"
                    select="'    [PUBS-ID-00092][Error] For element DateInformation, the permissible values     for the year range are 0001 through 9999 for elements ApproximableDateTime,     SearchableDateTime/EarliestStartDate, and SearchableDateTime/LatestEndDate.    '"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00092-R3-->
<xsl:template match="pubs:DateInformation/pubs:SearchableDateTime/pubs:EarliestStartDate"
                 priority="1001"
                 mode="M92">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DateInformation/pubs:SearchableDateTime/pubs:EarliestStartDate"
                       id="PUBS-ID-00092-R3"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateValue" select="."/>
      <xsl:variable name="errMsg"
                    select="'    [PUBS-ID-00092][Error] For element DateInformation, the permissible values     for the year range are 0001 through 9999 for elements ApproximableDateTime,     SearchableDateTime/EarliestStartDate, and SearchableDateTime/LatestEndDate.    '"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>

	  <!--RULE PUBS-ID-00092-R4-->
<xsl:template match="pubs:DateInformation/pubs:SearchableDateTime/pubs:LatestEndDate"
                 priority="1000"
                 mode="M92">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:DateInformation/pubs:SearchableDateTime/pubs:LatestEndDate"
                       id="PUBS-ID-00092-R4"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateValue" select="."/>
      <xsl:variable name="errMsg"
                    select="'    [PUBS-ID-00092][Error] For element DateInformation, the permissible values     for the year range are 0001 through 9999 for elements ApproximableDateTime,     SearchableDateTime/EarliestStartDate, and SearchableDateTime/LatestEndDate.    '"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if(not(dtf:yearPortionHasFourDigits(string($dateValue))))              then false()              else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear               and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(dtf:yearPortionHasFourDigits(string($dateValue)))) then false() else xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &lt;= $maxYear and xs:integer(substring(string(dtf:adjust-CombinedDate-to-GMT-timezone($dateValue)), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M92"/>
   <xsl:template match="@*|node()" priority="-2" mode="M92">
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00093-->


	<!--RULE PUBS-ID-00093-R1-->
<xsl:template match="pubs:*[@*]" priority="1000" mode="M93">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@*]"
                       id="PUBS-ID-00093-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="every $attribute in @* satisfies                     normalize-space(string($attribute))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $attribute in @* satisfies normalize-space(string($attribute))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00093][Error] Every attribute on a PUBS element in the document must be specified with a non-whitespace value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M93"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M93"/>
   <xsl:template match="@*|node()" priority="-2" mode="M93">
      <xsl:apply-templates select="*" mode="M93"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00096-->


	<!--RULE PUBS-ID-00096-R1-->
<xsl:template match="cem:Facility[@xlink:type] | cem:Person[@xlink:type]"
                 priority="1000"
                 mode="M94">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="cem:Facility[@xlink:type] | cem:Person[@xlink:type]"
                       id="PUBS-ID-00096-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@xlink:type='simple' or @xlink:type='resource'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@xlink:type='simple' or @xlink:type='resource'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
        	[PUBS-ID-00096][Error]
        	For elements Facility and Person, if attribute xlink:type is
        	specified then it must have a value of [simple] or [resource].
        	
        	Human Readable: For elements Facility and Person, attribute xlink:type value must be either [simple] or [resource]. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M94"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M94"/>
   <xsl:template match="@*|node()" priority="-2" mode="M94">
      <xsl:apply-templates select="*" mode="M94"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00097-->


	<!--RULE PUBS-ID-00097-R1-->
<xsl:template match="pubs:Link[@xlink:type]" priority="1000" mode="M95">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Link[@xlink:type]"
                       id="PUBS-ID-00097-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@xlink:type='simple' or @xlink:type='extended'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@xlink:type='simple' or @xlink:type='extended'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
        	[PUBS-ID-00097][Error]
        	For element pubs:Link, if attribute xlink:type is defined then it must
        	have a value of [simple] or [extended].
        	
        	Human Readable: For element pubs:Link, attribute xlink:type value must be either [simple] or [extended].
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M95"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M95"/>
   <xsl:template match="@*|node()" priority="-2" mode="M95">
      <xsl:apply-templates select="*" mode="M95"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00098-->


	<!--RULE PUBS-ID-00098-R1-->
<xsl:template match="pubs:*[@xlink:type='extended']" priority="1000" mode="M96">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@xlink:type='extended']"
                       id="PUBS-ID-00098-R1"/>
      <xsl:variable name="xlinkAttrLocalNames"
                    select="for $attr in @xlink:* return $attr/local-name()"/>
      <xsl:variable name="allowedXlinkLocalNamesList" select="('type', 'role', 'title')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="     every $attrLocalName in $xlinkAttrLocalNames satisfies      index-of($allowedXlinkLocalNamesList, $attrLocalName)    "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $attrLocalName in $xlinkAttrLocalNames satisfies index-of($allowedXlinkLocalNamesList, $attrLocalName)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[PUBS-ID-00098][Error] For any element,
			if attribute xlink:type is specified with a value of [extended], then that element can only
			define the following attributes in the xlink namespace: xlink:type, xlink:role, and
			xlink:title.
			
			Human Readable: If any element has attribute xlink:type with a value of [extended], then that element can only have values for the
			following in the xlink namespace: xlink:type, xlink:role, and xlink:title.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M96"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M96"/>
   <xsl:template match="@*|node()" priority="-2" mode="M96">
      <xsl:apply-templates select="*" mode="M96"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00099-->


	<!--RULE PUBS-ID-00099-R1-->
<xsl:template match="pubs:*[@xlink:type='resource'] | cem:*[@xlink:type='resource']"
                 priority="1000"
                 mode="M97">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@xlink:type='resource'] | cem:*[@xlink:type='resource']"
                       id="PUBS-ID-00099-R1"/>
      <xsl:variable name="xlinkAttrLocalNames"
                    select="for $attr in @xlink:* return $attr/local-name()"/>
      <xsl:variable name="allowedXlinkLocalNamesList"
                    select="('type', 'role', 'title', 'label')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="     every $attrLocalName in $xlinkAttrLocalNames satisfies      index-of($allowedXlinkLocalNamesList, $attrLocalName)    "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $attrLocalName in $xlinkAttrLocalNames satisfies index-of($allowedXlinkLocalNamesList, $attrLocalName)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[PUBS-ID-00099][Error] For any element, if attribute xlink:type is specified
			with a value of [resource], then that element can only define the following
			attributes in the xlink namespace: xlink:type, xlink:role, xlink:title, and xlink:label.
			
			Human Readable: If any element has attribute xlink:type with a value of [resource], then that element can only have values for the
			following in the xlink namespace: xlink:type, xlink:role, xlink:title, and xlink:label.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M97"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M97"/>
   <xsl:template match="@*|node()" priority="-2" mode="M97">
      <xsl:apply-templates select="*" mode="M97"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00100-->


	<!--RULE PUBS-ID-00100-R1-->
<xsl:template match="pubs:*[@xlink:type='simple']" priority="1000" mode="M98">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@xlink:type='simple']"
                       id="PUBS-ID-00100-R1"/>
      <xsl:variable name="xlinkAttrLocalNames"
                    select="for $attr in @xlink:* return $attr/local-name()"/>
      <xsl:variable name="allowedXlinkLocalNamesList"
                    select="('type', 'href', 'role', 'arcrole', 'title', 'show', 'actuate')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="     every $attrLocalName in $xlinkAttrLocalNames satisfies      index-of($allowedXlinkLocalNamesList, $attrLocalName)    "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $attrLocalName in $xlinkAttrLocalNames satisfies index-of($allowedXlinkLocalNamesList, $attrLocalName)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[PUBS-ID-00100][Error] For any element, if attribute xlink:type is specified
			with a value of [simple], then that element can only define the following
			attributes in the xlink namespace: xlink:type, xlink:href, xlink:role, xlink:arcrole,
			xlink:title, xlink:show, and xlink:actuate.
			
			Human Readable: If any element has attribute xlink:type with a value of [simple], then that element can only have values for the
			following in the xlink namespace: xlink:type, xlink:href, xlink:role, xlink:arcrole, xlink:title, xlink:show, and xlink:actuate.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M98"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M98"/>
   <xsl:template match="@*|node()" priority="-2" mode="M98">
      <xsl:apply-templates select="*" mode="M98"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00101-->


	<!--RULE PUBS-ID-00101-R1-->
<xsl:template match="pubs:*[@xlink:*]" priority="1000" mode="M99">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@xlink:*]"
                       id="PUBS-ID-00101-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="normalize-space(string(@xlink:type))    or normalize-space(string(@xlink:href))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(@xlink:type)) or normalize-space(string(@xlink:href))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[PUBS-ID-00101][Error] For any element, if any attribute is specified with the 
			xlink namespace 'http://www.w3.org/1999/xlink', then attributes xlink:type and/or
			xlink:href must be specified.
			
			Human Readable: If any element has an attribute specified with the xlink namespace 'http://www.w3.org/1999/xlink', 
			then attributes xlink:type and/or xlink:href must be specified.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M99"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M99"/>
   <xsl:template match="@*|node()" priority="-2" mode="M99">
      <xsl:apply-templates select="*" mode="M99"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00103-->


	<!--RULE PUBS-ID-00103-R1-->
<xsl:template match="pubs:*[@noteType]" priority="1000" mode="M100">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:*[@noteType]"
                       id="PUBS-ID-00103-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@ism:unregisteredNoticeType|@ism:noticeType)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@ism:unregisteredNoticeType|@ism:noticeType)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00103][Error]
            If an element has @noteType then it cannot have @ism:noticeType or 
            @ism:unregisteredNoticeType.
            
            Human Readable: An element with attribute noteType cannot have the 
            ISM attributes noticeType or unregisteredNoticeType.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M100"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M100"/>
   <xsl:template match="@*|node()" priority="-2" mode="M100">
      <xsl:apply-templates select="*" mode="M100"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00104-->


	<!--RULE PUBS-ID-00104-R1-->
<xsl:template match="pubs:Para[contains(concat(' ',string(@ism:ownerProducer),' '), ' USA ') and (@ism:FGIsourceOpen or @ism:FGIsourceProtected)]"
                 priority="1000"
                 mode="M101">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:Para[contains(concat(' ',string(@ism:ownerProducer),' '), ' USA ') and (@ism:FGIsourceOpen or @ism:FGIsourceProtected)]"
                       id="PUBS-ID-00104-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test=".//pubs:SourceReferenceCitationRef"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test=".//pubs:SourceReferenceCitationRef">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>[PUBS-ID-00104][Error] When there is
            a mixture of Foreign Government Information (FGI) and US data present on a Para element
            with ism:ownerProducer containing [USA], then there must exist a source citation. reference Human
            Readable: Element Para with ism:ownerProducer containing [USA] and a mix of Foreign
            Goverment Information (FGI) and US data, must have a source citation reference.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M101"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M101"/>
   <xsl:template match="@*|node()" priority="-2" mode="M101">
      <xsl:apply-templates select="*" mode="M101"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00111-->


	<!--RULE PUBS-ID-00111-R1-->
<xsl:template match="tdf:TrustedDataObject[descendant::tdf:StructuredStatement/pubs:IntelDocMetadata]"
                 priority="1000"
                 mode="M102">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject[descendant::tdf:StructuredStatement/pubs:IntelDocMetadata]"
                       id="PUBS-ID-00111-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:dates[@irm:posted] or                          tdf:StructuredPayload/descendant::pubs:DatePublished"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="tdf:Assertion/tdf:StructuredStatement/irm:ICResourceMetadataPackage/irm:dates[@irm:posted] or tdf:StructuredPayload/descendant::pubs:DatePublished">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00111][Error]
            At least one of either irm:ICResourceMetadataPackage/irm:dates/@irm:posted or pubs:DatePublished 
            is required to be specified.      
            
            Human Readable: A PUBS document must have either a date posted or date published 
            specified for itself.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M102"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M102"/>
   <xsl:template match="@*|node()" priority="-2" mode="M102">
      <xsl:apply-templates select="*" mode="M102"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00113-->


	<!--RULE PUBS-ID-00113-R1-->
<xsl:template match="tdf:TrustedDataObject[descendant::tdf:StructuredStatement/pubs:IntelDocMetadata]"
                 priority="1000"
                 mode="M103">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject[descendant::tdf:StructuredStatement/pubs:IntelDocMetadata]"
                       id="PUBS-ID-00113-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="descendant::tdf:StructuredStatement/irm:ICResourceMetadataPackage"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="descendant::tdf:StructuredStatement/irm:ICResourceMetadataPackage">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00113][Error]
            If tdf:TrustedDataObject contains an assertion with a PUBS structured statement, 
            it must also contain an assertion with an IRM structured statement. 
            
            Human Readable: If a Trusted Data Object contains a PUBS assertion, it must also contain an IRM assertion. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M103"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M103"/>
   <xsl:template match="@*|node()" priority="-2" mode="M103">
      <xsl:apply-templates select="*" mode="M103"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00114-->


	<!--RULE ValidateValidationEnvCVE-R1-->
<xsl:template match="/" priority="1000" mode="M104">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvCVE-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion castable as xs:double              and document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion &gt;= '202111'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion castable as xs:double and document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion &gt;= '202111'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [<xsl:text/>
                  <xsl:value-of select="'PUBS-ID-00114'"/>
                  <xsl:text/>][Error] Version [ <xsl:text/>
                  <xsl:value-of select="document('../../CVE/ISM/CVEnumISMClassificationAll.xml')//cve:CVE//@specVersion"/>
                  <xsl:text/> ] of <xsl:text/>
                  <xsl:value-of select="'ISM'"/>
                  <xsl:text/> found; 
            Version [<xsl:text/>
                  <xsl:value-of select="'202111'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'ISM'"/>
                  <xsl:text/> 
            is not being used in the validation infrastructure. Regardless of the version indicated on the instance document, 
            the validation infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'ISM'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'202111'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of the instance
            document but of the validation environment itself. The incorrect value was found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../CVE/ISM/CVEnumISMClassificationAll.xml'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M104"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M104"/>
   <xsl:template match="@*|node()" priority="-2" mode="M104">
      <xsl:apply-templates select="*" mode="M104"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00115-->


	<!--RULE PUBS-ID-00115-R1-->
<xsl:template match="/" priority="1000" mode="M105">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="PUBS-ID-00115-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="tdf:*//tdf:StructuredPayload/pubs:IntelDoc"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="tdf:*//tdf:StructuredPayload/pubs:IntelDoc">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00115][Error] The root node of a PUBS document must be pubs:IntelDoc 
            in a tdf:StructuredPayload element of a TDF instance.
            
            Human Readable: PUBS must be in a TDF and the starting node in the payload 
            must be pubs:IntelDoc.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M105"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M105"/>
   <xsl:template match="@*|node()" priority="-2" mode="M105">
      <xsl:apply-templates select="*" mode="M105"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00116-->


	<!--RULE PUBS-ID-00116-R1-->
<xsl:template match="tdf:TrustedDataObject/tdf:StructuredPayload/pubs:IntelDoc"
                 priority="1000"
                 mode="M106">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject/tdf:StructuredPayload/pubs:IntelDoc"
                       id="PUBS-ID-00116-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="ancestor::tdf:TrustedDataObject/tdf:Assertion/tdf:StructuredStatement/pubs:IntelDocMetadata"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::tdf:TrustedDataObject/tdf:Assertion/tdf:StructuredStatement/pubs:IntelDocMetadata">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>[PUBS-ID-00116][Error] If a tdf:TrustedDataObject has an IntelDoc element, it must contain a
            pubs:IntelDocMetadata assertion.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M106"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M106"/>
   <xsl:template match="@*|node()" priority="-2" mode="M106">
      <xsl:apply-templates select="*" mode="M106"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00117-->


	<!--RULE PUBS-ID-00117-R1-->
<xsl:template match="pubs:SourceReferenceCitationRef|pubs:AppendedReferenceCitationRef"
                 priority="1000"
                 mode="M107">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="pubs:SourceReferenceCitationRef|pubs:AppendedReferenceCitationRef"
                       id="PUBS-ID-00117-R1"/>
      <xsl:variable name="citationIDList"
                    select="ancestor::tdf:TrustedDataObject//@src:citationID"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="some $citationID in $citationIDList satisfies compare($citationID,normalize-space(@src:citationIDRef)) = 0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $citationID in $citationIDList satisfies compare($citationID,normalize-space(@src:citationIDRef)) = 0">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00117][Error]
            The value of each attribute @src:citationIDRef (<xsl:text/>
                  <xsl:value-of select="@src:citationIDRef"/>
                  <xsl:text/>) must be found in the list of attribute @src:citationID values. (<xsl:text/>
                  <xsl:value-of select="for $citationID in $citationIDList return $citationID"/>
                  <xsl:text/>)
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M107"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M107"/>
   <xsl:template match="@*|node()" priority="-2" mode="M107">
      <xsl:apply-templates select="*" mode="M107"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00118-->


	<!--RULE ValidateValidationEnvCVE-R1-->
<xsl:template match="/" priority="1000" mode="M108">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvCVE-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document('../../CVE/MIME/CVEnumMIMEType.xml')//cve:CVE//@specVersion castable as xs:double              and document('../../CVE/MIME/CVEnumMIMEType.xml')//cve:CVE//@specVersion &gt;= '202010'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../CVE/MIME/CVEnumMIMEType.xml')//cve:CVE//@specVersion castable as xs:double and document('../../CVE/MIME/CVEnumMIMEType.xml')//cve:CVE//@specVersion &gt;= '202010'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [<xsl:text/>
                  <xsl:value-of select="'PUBS-ID-00118'"/>
                  <xsl:text/>][Error] Version [ <xsl:text/>
                  <xsl:value-of select="document('../../CVE/MIME/CVEnumMIMEType.xml')//cve:CVE//@specVersion"/>
                  <xsl:text/> ] of <xsl:text/>
                  <xsl:value-of select="'MIME'"/>
                  <xsl:text/> found; 
            Version [<xsl:text/>
                  <xsl:value-of select="'202010'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'MIME'"/>
                  <xsl:text/> 
            is not being used in the validation infrastructure. Regardless of the version indicated on the instance document, 
            the validation infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'MIME'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'202010'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of the instance
            document but of the validation environment itself. The incorrect value was found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../CVE/MIME/CVEnumMIMEType.xml'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M108"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M108"/>
   <xsl:template match="@*|node()" priority="-2" mode="M108">
      <xsl:apply-templates select="*" mode="M108"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00119-->


	<!--RULE PUBS-ID-00119-R1-->
<xsl:template match="//pubs:*[@mime:* or .//mime:*]" priority="1000" mode="M109">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//pubs:*[@mime:* or .//mime:*]"
                       id="PUBS-ID-00119-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@mime:CESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@mime:CESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [PUBS-ID-00119][Error] For PUBS elements with MIME attributes or containing MIME elements, the MIME CESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If PUBS is using MIME in any way, the MIME CESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M109"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M109"/>
   <xsl:template match="@*|node()" priority="-2" mode="M109">
      <xsl:apply-templates select="*" mode="M109"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00120-->


	<!--RULE ValidateValidationEnvCVE-R1-->
<xsl:template match="/" priority="1000" mode="M110">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvCVE-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion castable as xs:double              and document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion &gt;= '201707'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion castable as xs:double and document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion &gt;= '201707'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [<xsl:text/>
                  <xsl:value-of select="'PUBS-ID-00120'"/>
                  <xsl:text/>][Error] Version [ <xsl:text/>
                  <xsl:value-of select="document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml')//cve:CVE//@specVersion"/>
                  <xsl:text/> ] of <xsl:text/>
                  <xsl:value-of select="'INTDIS'"/>
                  <xsl:text/> found; 
            Version [<xsl:text/>
                  <xsl:value-of select="'201707'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'INTDIS'"/>
                  <xsl:text/> 
            is not being used in the validation infrastructure. Regardless of the version indicated on the instance document, 
            the validation infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'INTDIS'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'201707'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of the instance
            document but of the validation environment itself. The incorrect value was found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../CVE/INTDIS/CVEnumIntelDiscipline.xml'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M110"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M110"/>
   <xsl:template match="@*|node()" priority="-2" mode="M110">
      <xsl:apply-templates select="*" mode="M110"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00121-->


	<!--RULE PUBS-ID-00121-R1-->
<xsl:template match="//pubs:*[@intdis:* or .//intdis:*]"
                 priority="1000"
                 mode="M111">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//pubs:*[@intdis:* or .//intdis:*]"
                       id="PUBS-ID-00121-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@intdis:CESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@intdis:CESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [PUBS-ID-00121][Error] For PUBS elements with INTDIS attributes or containing INTDIS elements, the INTDIS CESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If PUBS is using INTDIS in any way, the INTDIS CESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M111"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M111"/>
   <xsl:template match="@*|node()" priority="-2" mode="M111">
      <xsl:apply-templates select="*" mode="M111"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00123-->


	<!--RULE ValidateValidationEnvSchema-R1-->
<xsl:template match="/" priority="1000" mode="M112">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvSchema-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="             document('../../Schema/IRM/IC-IRM.xsd')//xsd:schema//@version castable as xs:double             and document('../../Schema/IRM/IC-IRM.xsd')//xsd:schema//@version &gt;= '202111'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../Schema/IRM/IC-IRM.xsd')//xsd:schema//@version castable as xs:double and document('../../Schema/IRM/IC-IRM.xsd')//xsd:schema//@version &gt;= '202111'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> [<xsl:text/>
                  <xsl:value-of select="'PUBS-ID-00123'"/>
                  <xsl:text/>][Error] Version [
            <xsl:text/>
                  <xsl:value-of select="document('../../Schema/IRM/IC-IRM.xsd')//xsd:schema//@version"/>
                  <xsl:text/> ] of
            <xsl:text/>
                  <xsl:value-of select="'IRM'"/>
                  <xsl:text/> found; Version [<xsl:text/>
                  <xsl:value-of select="'202111'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'IRM'"/>
                  <xsl:text/> is not being used in the validation infrastructure.
            Regardless of the version indicated on the instance document, the validation
            infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'IRM'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'202111'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of
            the instance document but of the validation environment itself. The incorrect value was
            found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../Schema/IRM/IC-IRM.xsd'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M112"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M112"/>
   <xsl:template match="@*|node()" priority="-2" mode="M112">
      <xsl:apply-templates select="*" mode="M112"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00124-->


	<!--RULE ValidateValidationEnvSchema-R1-->
<xsl:template match="/" priority="1000" mode="M113">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvSchema-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="             document('../../Schema/SRC/SRC-XML.xsd')//xsd:schema//@version castable as xs:double             and document('../../Schema/SRC/SRC-XML.xsd')//xsd:schema//@version &gt;= '201508.202205'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../Schema/SRC/SRC-XML.xsd')//xsd:schema//@version castable as xs:double and document('../../Schema/SRC/SRC-XML.xsd')//xsd:schema//@version &gt;= '201508.202205'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> [<xsl:text/>
                  <xsl:value-of select="'PUBS-ID-00124'"/>
                  <xsl:text/>][Error] Version [
            <xsl:text/>
                  <xsl:value-of select="document('../../Schema/SRC/SRC-XML.xsd')//xsd:schema//@version"/>
                  <xsl:text/> ] of
            <xsl:text/>
                  <xsl:value-of select="'SRC'"/>
                  <xsl:text/> found; Version [<xsl:text/>
                  <xsl:value-of select="'201508.202205'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'SRC'"/>
                  <xsl:text/> is not being used in the validation infrastructure.
            Regardless of the version indicated on the instance document, the validation
            infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'SRC'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'201508.202205'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of
            the instance document but of the validation environment itself. The incorrect value was
            found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../Schema/SRC/SRC-XML.xsd'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M113"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M113"/>
   <xsl:template match="@*|node()" priority="-2" mode="M113">
      <xsl:apply-templates select="*" mode="M113"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00127-->


	<!--RULE ValidateValidationEnvSchema-R1-->
<xsl:template match="/" priority="1000" mode="M114">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvSchema-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="             document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version castable as xs:double             and document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version &gt;= '201903'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version castable as xs:double and document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version &gt;= '201903'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> [<xsl:text/>
                  <xsl:value-of select="'PUBS-ID-00127'"/>
                  <xsl:text/>][Error] Version [
            <xsl:text/>
                  <xsl:value-of select="document('../../Schema/IC-EDH/IC-EDH.xsd')//xsd:schema//@version"/>
                  <xsl:text/> ] of
            <xsl:text/>
                  <xsl:value-of select="'IC-EDH'"/>
                  <xsl:text/> found; Version [<xsl:text/>
                  <xsl:value-of select="'201903'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'IC-EDH'"/>
                  <xsl:text/> is not being used in the validation infrastructure.
            Regardless of the version indicated on the instance document, the validation
            infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'IC-EDH'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'201903'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of
            the instance document but of the validation environment itself. The incorrect value was
            found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../Schema/IC-EDH/IC-EDH.xsd'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M114"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M114"/>
   <xsl:template match="@*|node()" priority="-2" mode="M114">
      <xsl:apply-templates select="*" mode="M114"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00128-->


	<!--RULE ValidateValidationEnvSchema-R1-->
<xsl:template match="/" priority="1000" mode="M115">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvSchema-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="             document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version castable as xs:double             and document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version &gt;= '202010'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version castable as xs:double and document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version &gt;= '202010'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> [<xsl:text/>
                  <xsl:value-of select="'PUBS-ID-00128'"/>
                  <xsl:text/>][Error] Version [
            <xsl:text/>
                  <xsl:value-of select="document('../../Schema/VIRT/VIRT.xsd')//xsd:schema//@version"/>
                  <xsl:text/> ] of
            <xsl:text/>
                  <xsl:value-of select="'VIRT'"/>
                  <xsl:text/> found; Version [<xsl:text/>
                  <xsl:value-of select="'202010'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'VIRT'"/>
                  <xsl:text/> is not being used in the validation infrastructure.
            Regardless of the version indicated on the instance document, the validation
            infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'VIRT'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'202010'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of
            the instance document but of the validation environment itself. The incorrect value was
            found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../Schema/VIRT/VIRT.xsd'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M115"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M115"/>
   <xsl:template match="@*|node()" priority="-2" mode="M115">
      <xsl:apply-templates select="*" mode="M115"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00129-->


	<!--RULE PUBS-ID-00129-R1-->
<xsl:template match="//pubs:*[@virt:* or .//virt:*]" priority="1000" mode="M116">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//pubs:*[@virt:* or .//virt:*]"
                       id="PUBS-ID-00129-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@virt:DESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@virt:DESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [PUBS-ID-00129][Error] For PUBS elements with VIRT attributes or containing VIRT elements, the VIRT DESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If PUBS is using VIRT in any way, the VIRT DESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M116"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M116"/>
   <xsl:template match="@*|node()" priority="-2" mode="M116">
      <xsl:apply-templates select="*" mode="M116"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00130-->


	<!--RULE PUBS-ID-00130-R1-->
<xsl:template match="*[@DESVersion]" priority="1000" mode="M117">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="*[@DESVersion]"
                       id="PUBS-ID-00130-R1"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="matches(@DESVersion, '^201804.202205(\-.{1,23})?$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="matches(@DESVersion, '^201804.202205(\-.{1,23})?$')">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> [PUBS-ID-00130][Warning] pubs:DESVersion attribute SHOULD be specified
            as version 201804.202205 (Version:2018-APR Revision: 2022-MAY) with an optional extension. </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M117"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M117"/>
   <xsl:template match="@*|node()" priority="-2" mode="M117">
      <xsl:apply-templates select="*" mode="M117"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00131-->


	<!--RULE PUBS-ID-00131-R1-->
<xsl:template match="//pubs:*[@cem:* or .//cem:*]" priority="1000" mode="M118">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//pubs:*[@cem:* or .//cem:*]"
                       id="PUBS-ID-00131-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@cem:DESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@cem:DESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [PUBS-ID-00131][Error] For PUBS elements with CEM attributes or containing CEM elements, the CEM DESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If PUBS is using CEM in any way, the CEM DESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M118"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M118"/>
   <xsl:template match="@*|node()" priority="-2" mode="M118">
      <xsl:apply-templates select="*" mode="M118"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00132-->


	<!--RULE ValidateValidationEnvSchema-R1-->
<xsl:template match="/" priority="1000" mode="M119">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="/"
                       id="ValidateValidationEnvSchema-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="             document('../../Schema/CEM/CEM-XML.xsd')//xsd:schema//@version castable as xs:double             and document('../../Schema/CEM/CEM-XML.xsd')//xsd:schema//@version &gt;= '201804'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="document('../../Schema/CEM/CEM-XML.xsd')//xsd:schema//@version castable as xs:double and document('../../Schema/CEM/CEM-XML.xsd')//xsd:schema//@version &gt;= '201804'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> [<xsl:text/>
                  <xsl:value-of select="'PUBS-ID-00132'"/>
                  <xsl:text/>][Error] Version [
            <xsl:text/>
                  <xsl:value-of select="document('../../Schema/CEM/CEM-XML.xsd')//xsd:schema//@version"/>
                  <xsl:text/> ] of
            <xsl:text/>
                  <xsl:value-of select="'CEM'"/>
                  <xsl:text/> found; Version [<xsl:text/>
                  <xsl:value-of select="'201804'"/>
                  <xsl:text/>] or later is required. The latest version of <xsl:text/>
                  <xsl:value-of select="'CEM'"/>
                  <xsl:text/> is not being used in the validation infrastructure.
            Regardless of the version indicated on the instance document, the validation
            infrastructure needs to use a version of <xsl:text/>
                  <xsl:value-of select="'CEM'"/>
                  <xsl:text/> that is
            version [<xsl:text/>
                  <xsl:value-of select="'201804'"/>
                  <xsl:text/>] or later. NOTE: This is not an error of
            the instance document but of the validation environment itself. The incorrect value was
            found in <xsl:text/>
                  <xsl:value-of select="document-uri(document('../../Schema/CEM/CEM-XML.xsd'))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M119"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M119"/>
   <xsl:template match="@*|node()" priority="-2" mode="M119">
      <xsl:apply-templates select="*" mode="M119"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00133-->


	<!--RULE PUBS-ID-00133-R1-->
<xsl:template match="//pubs:*[@edh:* or .//edh:*]" priority="1000" mode="M120">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//pubs:*[@edh:* or .//edh:*]"
                       id="PUBS-ID-00133-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@edh:DESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@edh:DESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [PUBS-ID-00133][Error] For PUBS elements with IC-EDH attributes or containing IC-EDH elements, the IC-EDH DESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If PUBS is using IC-EDH in any way, the IC-EDH DESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M120"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M120"/>
   <xsl:template match="@*|node()" priority="-2" mode="M120">
      <xsl:apply-templates select="*" mode="M120"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00134-->


	<!--RULE PUBS-ID-00134-R1-->
<xsl:template match="//pubs:*[@ism:* or .//ism:*]" priority="1000" mode="M121">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="//pubs:*[@ism:* or .//ism:*]"
                       id="PUBS-ID-00134-R1"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="//*[@ism:DESVersion]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="//*[@ism:DESVersion]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text> 
            [PUBS-ID-00134][Error] For PUBS elements with ISM attributes or containing ISM elements, the ISM DESVersion
            must exist somewhere in the instance. 
            
            Human Readable: If PUBS is using ISM in any way, the ISM DESVersion must exist in the instance. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M121"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M121"/>
   <xsl:template match="@*|node()" priority="-2" mode="M121">
      <xsl:apply-templates select="*" mode="M121"/>
   </xsl:template>

   <!--PATTERN PUBS-ID-00135-->


	<!--RULE PUBS-ID-00135-R1-->
<xsl:template match="irm:ICResourceMetadataPackage/irm:dates[@irm:infoCutOff]"
                 priority="1000"
                 mode="M122">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="irm:ICResourceMetadataPackage/irm:dates[@irm:infoCutOff]"
                       id="PUBS-ID-00135-R1"/>
      <xsl:variable name="secondaryDateList"
                    select="(ancestor::tdf:TrustedDataObject//pubs:AdministrativeMetadata/pubs:DateList/pubs:DatePublished, @irm:approvedOn)"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="             every $secondaryDate in $secondaryDateList satisfies dtf:compareDateTimeRanges(string(@irm:infoCutOff),              '&lt;=', string($secondaryDate))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $secondaryDate in $secondaryDateList satisfies dtf:compareDateTimeRanges(string(@irm:infoCutOff), '&lt;=', string($secondaryDate))">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [PUBS-ID-00135][Warning] irm:dates/@irm:infoCutOff must
            be earlier than or equivalent to irm:dates/@irm:approvedOn.
            
            Human Readable: DateInfoCutoff has to be less than or equal to DateApproved.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M122"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M122"/>
   <xsl:template match="@*|node()" priority="-2" mode="M122">
      <xsl:apply-templates select="*" mode="M122"/>
   </xsl:template>
</xsl:stylesheet>
<!--UNCLASSIFIED-->
