<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:dhzm="urn:us:gov:ic:digitalhazmat"
                xmlns:anlys="urn:us:gov:ic:anlysassert"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="urn:x-us:gov:ic:dhzm:changes"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xhtml="http://www.w3.org/1999/xhtml-StopBrowserRendering"
                xmlns:ism="urn:us:gov:ic:ism"
                xmlns:sfhashv="urn:us:gov:ic:sf:hashverification"
                xmlns:ch="urn:x-us:gov:ic:dhzm:changes"
                version="2.0"
                exclude-result-prefixes="ch">
   <xsl:output encoding="US-ASCII"/>
   <!--present documentation before input comments--><xsl:template match="/">
      <xsl:text xml:space="preserve">
</xsl:text>
      <xsl:comment>
  This file is auto-generated, do not edit this file directly.
  
  Modified by to be made more restrictive for Cross Domain Guards and to be more open for 
  non IC Corporate use in support of transport of digital hazmat.  All
  changes are marked "DigitalHazMatCom:" with comments.
  
  DHZMC-TDF-Changes.xml
</xsl:comment>
      <xsl:text xml:space="preserve">
</xsl:text>
      <xsl:apply-templates/>
   </xsl:template>
   <!--assume comments in prologue start on new lines--><xsl:template match="/comment()">
      <xsl:text xml:space="preserve">
</xsl:text>
      <xsl:copy/>
   </xsl:template>
   <!--assume document element not being matched; copy namespaces to reduce the need for declarations--><xsl:template match="/*">
      <xsl:text xml:space="preserve">
</xsl:text>
      <xsl:element name="{name(/*)}" namespace="{namespace-uri(/*)}">
         <xsl:copy-of select="(/ | document(''))/*/                      namespace::*[.!='http://www.w3.org/1999/XSL/Transform'                               and .!='urn:x-us:gov:ic:dhzm:changes']"/>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:element>
   </xsl:template>
   <!--Identity transform for all unmached leaf nodes--><xsl:template match="@*|text()|comment()|processing-instruction()">
      <xsl:copy/>
   </xsl:template>
   <!--Identity transform for all unmached elements--><xsl:template match="*">
      <xsl:element name="{name(.)}" namespace="{namespace-uri(.)}">
         <xsl:apply-templates select="@*|node()"/>
      </xsl:element>
   </xsl:template>
   <!--Using a template allows xml:space to be used in param--><xsl:template name="copy-content">
      <xsl:param name="rtf"/>
      <xsl:copy-of select="$rtf"/>
   </xsl:template>
   <!--Expose current element's start tag--><xsl:template name="show-old-start-tag">
      <xsl:comment>
         <xsl:text xml:space="preserve">Replacing:
</xsl:text>
         <xsl:apply-templates mode="expose" select=".">
            <xsl:with-param name="suppress" select="true()"/>
         </xsl:apply-templates>
         <xsl:text xml:space="preserve">
</xsl:text>
      </xsl:comment>
   </xsl:template>
   <xsl:template name="show-old-element">
      <xsl:comment>
         <xsl:text xml:space="preserve">Replacing:
</xsl:text>
         <xsl:apply-templates mode="expose" select="."/>
         <xsl:text xml:space="preserve">
</xsl:text>
      </xsl:comment>
   </xsl:template>
   <xsl:template mode="expose" match="*">
      <xsl:param name="suppress" select="false()"/>
      <xsl:value-of disable-output-escaping="yes" select="concat('&lt;',name(.))"/>
      <xsl:for-each select="@*">
         <xsl:value-of select="concat(' ',name(.),'=&#34;',.,'&#34;')"/>
      </xsl:for-each>
      <xsl:if test="not(node())">/</xsl:if>
      <xsl:text>&gt;</xsl:text>
      <xsl:if test="not( $suppress ) and node()">
         <xsl:apply-templates mode="expose"/>
         <xsl:value-of disable-output-escaping="yes" select="concat('&lt;/',name(.),'&gt;')"/>
      </xsl:if>
   </xsl:template>
   <xsl:template mode="expose" match="comment()">
      <xsl:value-of disable-output-escaping="yes" select="concat('&lt;!-',.,'-&gt;')"/>
   </xsl:template>
   <xsl:template mode="expose" match="processing-instruction()">
      <xsl:value-of disable-output-escaping="yes" select="concat('&lt;?',name(.),' ',.,'?&gt;')"/>
   </xsl:template>
   <!--Specific node changes follow--><!--injectAttribute--><xsl:template match="xs:import[@namespace='urn:us:gov:ic:cvenum:tdf:signaturealgorithm']">
      <xsl:call-template name="show-old-start-tag"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">  
    <xsl:comment> DigitalHazMatCom: Update import path to BASE-TDF CVEGenerated for CVEnumTDFHashAlgorithm </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
      <xsl:copy>
         <xsl:apply-templates select="@*"/>
         <xsl:attribute name="schemaLocation" namespace="">../BASE-TDF/CVEGenerated/CVEnumTDFSignatureAlgorithm.xsd</xsl:attribute>
         <xsl:apply-templates select="node()"/>
      </xsl:copy>
   </xsl:template>
   <!--injectAttribute--><xsl:template match="xs:import[@namespace='urn:us:gov:ic:cvenum:tdf:hashalgorithm']">
      <xsl:call-template name="show-old-start-tag"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">  
    <xsl:comment> DigitalHazMatCom: Update import path to BASE-TDF CVEGenerated for CVEnumTDFSignatureAlgorithm </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
      <xsl:copy>
         <xsl:apply-templates select="@*"/>
         <xsl:attribute name="schemaLocation" namespace="">../BASE-TDF/CVEGenerated/CVEnumTDFHashAlgorithm.xsd</xsl:attribute>
         <xsl:apply-templates select="node()"/>
      </xsl:copy>
   </xsl:template>
   <!--injectAttribute--><xsl:template match="xs:import[@namespace='urn:us:gov:ic:cvenum:tdf:state']">
      <xsl:call-template name="show-old-start-tag"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">  
    <xsl:comment> DigitalHazMatCom: Update import path to BASE-TDF CVEGenerated for CVEnumTDFAppliesToState </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
      <xsl:copy>
         <xsl:apply-templates select="@*"/>
         <xsl:attribute name="schemaLocation" namespace="">../BASE-TDF/CVEGenerated/CVEnumTDFAppliesToState.xsd</xsl:attribute>
         <xsl:apply-templates select="node()"/>
      </xsl:copy>
   </xsl:template>
   <!--injectAttribute--><xsl:template match="xs:attribute[@name='version']/xs:simpleType/xs:restriction/xs:pattern">
      <xsl:call-template name="show-old-start-tag"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Update tdf:version regex to be for DHZMC-TDF customization </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
      <xsl:copy>
         <xsl:apply-templates select="@*"/>
         <xsl:attribute name="value" namespace="">[0-9]{6}(\.[0-9]{6})?\-DHZMC\-TDF\.[0-9]{6}(\.[0-9]{6})?(\-.{1,23})?</xsl:attribute>
         <xsl:apply-templates select="node()"/>
      </xsl:copy>
   </xsl:template>
   <!--injectBefore--><xsl:template match="xs:element[@name='TrustedDataCollection']">
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Add DHZM and ANLYS schema imports </xsl:comment>
    <xs:import namespace="urn:us:gov:ic:digitalhazmat" schemaLocation="../DHZM/DHZM.xsd"/>
    <xs:import namespace="urn:us:gov:ic:anlysassert" schemaLocation="../ANLYS/ANLYS.xsd"/>
  </xsl:with-param>
      </xsl:call-template>
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='StringPayload']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Remove references to StringPayload </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='StructuredPayload']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Remove references to StructuredPayload </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='TrustedDataObjectType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Replace EncryptionInformationGroup with EncryptionInformationGroupRequired </xsl:comment>
    <xs:complexType name="TrustedDataObjectType">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:classification="U" ism:ownerProducer="USA">A list of Trusted Data 
            Objects.</xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:sequence>
        <xs:group maxOccurs="1" minOccurs="1" ref="AssertionGroup"/>
        <xs:group maxOccurs="1" minOccurs="1" ref="EncryptionInformationGroupRequired"/>
        <xs:group ref="PayloadGroup"/>
      </xs:sequence>
      <xs:attribute ref="version"/>
      <xs:attribute ref="sf:DESVersion" use="optional"/>
      <xs:attribute ref="id" use="optional"/>
    </xs:complexType>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='StructuredValueType']/xs:sequence/xs:any">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Replace StructuredValueType xs:any with xs:choice of dhzm:DigitalHazMatAssertion, 
                        dhzm:ProvenanceAssertion or anlys:AnalysisAssertion </xsl:comment>
    <xs:choice>
      <xs:element ref="dhzm:DigitalHazMatAssertion"/>
      <xs:element ref="dhzm:ProvenanceAssertion"/>
      <xs:element ref="anlys:AnalysisAssertion"/>
    </xs:choice>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='Base64BinaryValueType']/xs:simpleContent/xs:extension[@base='xs:base64Binary']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Replace xs:base64Binary with Base64BinaryRestrictedType </xsl:comment>
    <xs:extension base="Base64BinaryRestrictedType">
      <xs:attribute ref="mediaType" use="optional"/>
      <xs:attribute ref="filename" use="optional"/>
      <xs:attribute ref="isEncrypted" use="optional"/>
      <xs:attribute ref="id" use="optional"/>
    </xs:extension>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--injectAfter--><xsl:template match="xs:complexType[@name='Base64BinaryValueType']">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Add Base64BinaryRestrictedType type </xsl:comment>
    <xs:simpleType name="Base64BinaryRestrictedType">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:classification="U" ism:ownerProducer="USA">base64 binary with restricted length</xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:restriction base="xs:base64Binary">
        <xs:maxLength value="10000000"/>
      </xs:restriction>
    </xs:simpleType>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--injectBefore--><xsl:template match="xs:group[@name='EncryptionInformationGroup']">
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Add EncryptionInformationGroupRequired group </xsl:comment>
    <xs:group name="EncryptionInformationGroupRequired">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:classification="U" ism:ownerProducer="USA">The group of elements used
            to express encryption information in an Assertion or a TDO.</xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:sequence>
        <xs:element maxOccurs="unbounded" minOccurs="1" name="EncryptionInformation">
          <xs:annotation>
            <xs:documentation>
              <xhtml:p ism:classification="U" ism:ownerProducer="USA">Top level element
                for holding information related to the encryption of an assertion or
                payload. Multiple child KeyAccess and/or EncryptionMethod elements
                represent onion or layered encryption. In this case, the first child
                represents the outermost layer of encryption.</xhtml:p>
            </xs:documentation>
          </xs:annotation>
          <xs:complexType>
            <xs:choice maxOccurs="1">
              <xs:sequence>
                <xs:element minOccurs="1" name="KeyAccess" type="KeyAccessType">
                  <xs:annotation>
                    <xs:documentation>
                      <xhtml:p ism:classification="U" ism:ownerProducer="USA">
                        Contains information pertaining to the key for which the
                        application value(s) was/were encrypted and/or that is
                        necessary for decryption.</xhtml:p>
                    </xs:documentation>
                  </xs:annotation>
                </xs:element>
                <xs:element maxOccurs="1" minOccurs="1" name="EncryptionMethod" type="EncryptionMethodType">
                  <xs:annotation>
                    <xs:documentation>
                      <xhtml:p ism:classification="U" ism:ownerProducer="USA">
                        Contains information pertaining to the methods for which
                        the applicable value(s) was/were encrypted. (i.e.
                        SHA256)</xhtml:p>
                    </xs:documentation>
                  </xs:annotation>
                </xs:element>
              </xs:sequence>
            </xs:choice>
            <xs:attribute name="sequenceNum" type="xs:integer" use="optional">
              <xs:annotation>
                <xs:documentation>
                  <xhtml:p ism:classification="U" ism:ownerProducer="USA">The sequence number of the encryption info.</xhtml:p>
                </xs:documentation>
              </xs:annotation>
            </xs:attribute>
          </xs:complexType>
        </xs:element>
      </xs:sequence>
    </xs:group>
  </xsl:with-param>
      </xsl:call-template>
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='HandlingAssertionType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> DigitalHazMatCom: Remove HandlingAssertionType so we can't do any classified or CUI  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='HandlingStatementType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
  <xsl:comment> DigitalHazMatCom: Remove HandlingStatementType so we can't do any classified or CUI </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='HandlingAssertion']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
  <xsl:comment> DigitalHazMatCom: Remove HandlingAssertion So we can't do any classified or CUI  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
</xsl:stylesheet>
