<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cdsm="urn:us:gov:ic:cdsmanifest"
                xmlns:anlys="urn:us:gov:ic:anlysassert"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="urn:x-us:gov:ic:cdsmanifest:changes"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xhtml="http://www.w3.org/1999/xhtml-StopBrowserRendering"
                xmlns:ism="urn:us:gov:ic:ism"
                xmlns:ch="urn:x-us:gov:ic:cdsmanifest:changes"
                version="2.0"
                exclude-result-prefixes="ch">
   <xsl:output encoding="US-ASCII"/>
   <!--present documentation before input comments--><xsl:template match="/">
      <xsl:text xml:space="preserve">
</xsl:text>
      <xsl:comment>
  This file is auto-generated, do not edit this file directly.
  
  Modified by to be made more restrictive for Cross Domain Guards and to be more open for 
  non IC Corporate use in support of cross domain system manifests.  All
  changes are marked "CdsManifest:" with comments.
  
  CDSM-TDF-Changes.xml
</xsl:comment>
      <xsl:text xml:space="preserve">
</xsl:text>
      <xsl:apply-templates/>
   </xsl:template>
   <!--assume comments in prologue start on new lines--><xsl:template match="/comment()">
      <xsl:text xml:space="preserve">
</xsl:text>
      <xsl:copy/>
   </xsl:template>
   <!--assume document element not being matched; copy namespaces to reduce the need for declarations--><xsl:template match="/*">
      <xsl:text xml:space="preserve">
</xsl:text>
      <xsl:element name="{name(/*)}" namespace="{namespace-uri(/*)}">
         <xsl:copy-of select="(/ | document(''))/*/                      namespace::*[.!='http://www.w3.org/1999/XSL/Transform'                               and .!='urn:x-us:gov:ic:cdsmanifest:changes']"/>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:element>
   </xsl:template>
   <!--Identity transform for all unmached leaf nodes--><xsl:template match="@*|text()|comment()|processing-instruction()">
      <xsl:copy/>
   </xsl:template>
   <!--Identity transform for all unmached elements--><xsl:template match="*">
      <xsl:element name="{name(.)}" namespace="{namespace-uri(.)}">
         <xsl:apply-templates select="@*|node()"/>
      </xsl:element>
   </xsl:template>
   <!--Using a template allows xml:space to be used in param--><xsl:template name="copy-content">
      <xsl:param name="rtf"/>
      <xsl:copy-of select="$rtf"/>
   </xsl:template>
   <!--Expose current element's start tag--><xsl:template name="show-old-start-tag">
      <xsl:comment>
         <xsl:text xml:space="preserve">Replacing:
</xsl:text>
         <xsl:apply-templates mode="expose" select=".">
            <xsl:with-param name="suppress" select="true()"/>
         </xsl:apply-templates>
         <xsl:text xml:space="preserve">
</xsl:text>
      </xsl:comment>
   </xsl:template>
   <xsl:template name="show-old-element">
      <xsl:comment>
         <xsl:text xml:space="preserve">Replacing:
</xsl:text>
         <xsl:apply-templates mode="expose" select="."/>
         <xsl:text xml:space="preserve">
</xsl:text>
      </xsl:comment>
   </xsl:template>
   <xsl:template mode="expose" match="*">
      <xsl:param name="suppress" select="false()"/>
      <xsl:value-of disable-output-escaping="yes" select="concat('&lt;',name(.))"/>
      <xsl:for-each select="@*">
         <xsl:value-of select="concat(' ',name(.),'=&#34;',.,'&#34;')"/>
      </xsl:for-each>
      <xsl:if test="not(node())">/</xsl:if>
      <xsl:text>&gt;</xsl:text>
      <xsl:if test="not( $suppress ) and node()">
         <xsl:apply-templates mode="expose"/>
         <xsl:value-of disable-output-escaping="yes" select="concat('&lt;/',name(.),'&gt;')"/>
      </xsl:if>
   </xsl:template>
   <xsl:template mode="expose" match="comment()">
      <xsl:value-of disable-output-escaping="yes" select="concat('&lt;!-',.,'-&gt;')"/>
   </xsl:template>
   <xsl:template mode="expose" match="processing-instruction()">
      <xsl:value-of disable-output-escaping="yes" select="concat('&lt;?',name(.),' ',.,'?&gt;')"/>
   </xsl:template>
   <!--Specific node changes follow--><!--replaceElement--><xsl:template match="xs:import[@namespace='urn:us:gov:ic:cvenum:tdf:signaturealgorithm']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove signaturealgorithm Import since CdsManifest does not allow encryption 
                      and add CDSM and ANLYS schema import</xsl:comment>
    <xs:import namespace="urn:us:gov:ic:cdsmanifest" schemaLocation="../CDSM/CDSM.xsd"/>
    <xs:import namespace="urn:us:gov:ic:anlysassert" schemaLocation="../ANLYS/ANLYS.xsd"/>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:import[@namespace='urn:us:gov:ic:cvenum:tdf:hashalgorithm']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove hashalgorithm Import since CdsManifest does not allow encryption. </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:import[@namespace='urn:us:gov:ic:cvenum:tdf:state']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove tdf state Import since CdsManifest does not allow encryption. </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='AssertionType']/xs:sequence/xs:element[@name='StatementMetadata']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove Statement Metadata on Statements. </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='StatementMetadataType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove StatementMetadataType on Statements. </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='HandlingAssertionType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove HandlingAssertionType so we can't do any classified or CUI  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='HandlingStatementType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove HandlingStatementType so we can't do any classified or CUI </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='HandlingAssertion']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove HandlingAssertion so we can't do any classified or CUI  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:group[@name='EncryptionInformationGroup']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove EncryptionInformationGroup Nothing is allowed to be encrypted  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:group[@ref='EncryptionInformationGroup']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to EncryptionInformationGroup Nothing is allowed to be encrypted  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@ref='EncryptionMethodType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to EncryptionMethodType Nothing is allowed to be encrypted  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='StringPayload']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to StringPayload only ReferenceValuePayload is allowed for CdsManifest project.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='Base64BinaryPayload']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to Base64BinaryPayload only ReferenceValuePayload is allowed for CdsManifest project.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='StructuredPayload']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to StructuredPayload only ReferenceValuePayload is allowed for CdsManifest project.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='StringStatement']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to StringStatement only StructuredStatement is allowed for CdsManifest project.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='Base64BinaryStatement']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to Base64BinaryStatement only StructuredStatement is allowed for CdsManifest project.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='ReferenceStatement']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to ReferenceStatement only StructuredStatement is allowed for CdsManifest project.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='Base64BinaryValueType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to Base64BinaryValueType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='StringValueType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to StringValueType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='KeyAccessType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to KeyAccessType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='AttachedKeyType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to AttachedKeyType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='PreSharedKeyType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to PreSharedKeyType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='RemoteStoredKeyType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to RemoteStoredKeyType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='PasswordKeyType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to PasswordKeyType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='WrappedPDPKeyType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to WrappedPDPKeyType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='WrappedKeyType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to WrappedKeyType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='EncryptionMethodType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to EncryptionMethodType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='TrustedDataCollection']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to TrustedDataCollection Only TrustedDataObjects are valid for CdsManifest project.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='TrustedDataCollectionType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to TrustedDataCollection All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='isEncrypted']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove attribute isEncrypted since nothing in CdsManifest allows encryption.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@ref='isEncrypted']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove attribute isEncrypted since nothing in CdsManifest allows encryption.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='filename']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove attribute filename since nothing it was only used for Base64 and String which were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@ref='filename']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove attribute filename since nothing it was only used for Base64 and String which were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:enumeration[@value='TDC']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove Scope enumerations TDC since there are no TDC's allowed.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:enumeration[@value='DESC_TDO']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove Scope enumerations DESC_TDO since there are no TDC's allowed.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:enumeration[@value='DESC_PAYL']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove Scope enumerations DESC_PAYL since there are no TDC's allowed.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:enumeration[@value='TDC_MEMBER']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove Scope enumerations TDC_MEMBER since there are no TDC's allowed.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:enumeration[@value='EXPLICIT']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove Scope enumerations EXPLICIT since Explicit is not supported for CdsManifest.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='BoundValueListType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to BoundValueListType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='BoundValueType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to BoundValueType All uses of this type were tailored out.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='BoundValueList']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to BoundValueList this type of binding is not supported for CdsManifest.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='ReferenceType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to ReferenceType this type of binding is not supported for CdsManifest.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='ReferenceListType']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to ReferenceListType this type of binding is not supported for CdsManifest.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:element[@name='ReferenceList']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove references to ReferenceList this type of binding is not supported for CdsManifest.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='type']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove the type attribute as it is not required for CdsManifest.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:simpleType[@name='MediaTypeType']/xs:restriction">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xs:restriction base="xs:string">
      <xs:annotation>
        <xs:documentation> 
          A restriction on string for the format of mediaType (i.e.
          audio/GSM) as defined in 
          <xhtml:a href="http://tools.ietf.org/html/rfc4288">RFC 4288</xhtml:a>.
        </xs:documentation>
      </xs:annotation>
      <xs:maxLength value="256"/>
      <xs:pattern value="[a-zA-Z]*/[a-zA-Z+-.]*"/>
    </xs:restriction>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='normalizationMethod']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Restrict normalizationMethod to specific allowed URIs. </xsl:comment>
    <xs:attribute name="normalizationMethod">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:classification="U" ism:ownerProducer="USA">
            A URI that provides guidance on how to format the included values such as whitespace, attributes, and child
            nodes in a universally consistent manner. The normalization method is essential to prevent formatting such as
            whitespace and order from interfering with the validation of the cryptographic integrity of data. 
            Assertions should explicitly declare all their namespaces at the assertion level rather than relying on those 
            provided by the root node.
          </xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:simpleType>
        <xs:restriction base="xs:anyURI">
          <xs:enumeration value="http://www.w3.org/TR/xml-c14n11"/>
        </xs:restriction>
      </xs:simpleType>
    </xs:attribute>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:complexType[@name='StructuredValueType']/xs:sequence/xs:any">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove xs:any and force assertion to be cdsm:CdsManifestAssertion or anlys:AnalysisAssertion and keep Xsat Happy.  </xsl:comment>
    <xs:choice>
      <xs:element ref="cdsm:CdsManifestAssertion"/>
      <xs:element ref="anlys:AnalysisAssertion"/>
    </xs:choice>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='issuer']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Replace entirety of issuer force a max length and pattern to keep Xsat Happy.  </xsl:comment>
    <xsl:comment> CdsManifest: Force issuer to be required since we don't use serial.  </xsl:comment>
    <xs:attribute name="issuer" use="required">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:classification="U" ism:ownerProducer="USA">The
            distinguished name of the authority that issued the
            credentials to the subject. Refer to RFC 5280 for more
            information.</xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:simpleType>
        <xs:restriction base="xs:string">
          <xs:minLength value="1"/>
          <xs:maxLength value="50"/>
          <xs:pattern value="([a-zA-Z0-9\.\s=_-])*"/>
        </xs:restriction>
      </xs:simpleType>
    </xs:attribute>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='serial']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Remove serial since we require issuer.  </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='signatureAlgorithm']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Replace entirety of signatureAlgorithm to disallow newer signing algorithms and keep Xsat Happy.  </xsl:comment> 
    <xs:attribute name="signatureAlgorithm" use="required">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:classification="U" ism:ownerProducer="USA">The algorithm or
            pattern used by the signature restricted to the following values below.
          </xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:simpleType>
        <xs:restriction base="xs:string">
          <xs:enumeration value="SHA256withRSA"/>
          <xs:enumeration value="SHA384withRSA"/>
          <xs:enumeration value="SHA512withRSA"/>
          <xs:enumeration value="SHA256withECDSA"/>
          <xs:enumeration value="SHA384withECDSA"/>
          <xs:enumeration value="SHA512withECDSA"/>
        </xs:restriction>
      </xs:simpleType>
    </xs:attribute>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='subject']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Replace entirety of subject to enable max length and a pattern to keep Xsat Happy.  </xsl:comment> 
     <xs:attribute name="subject" use="required">
       <xs:annotation>
         <xs:documentation>
           <xhtml:p ism:classification="U" ism:ownerProducer="USA">The
             distinguished name of the person or entity who is doing the
             signing. Refer to RFC 5280 for more information.</xhtml:p>
         </xs:documentation>
       </xs:annotation>
     <xs:simpleType>
       <xs:restriction base="xs:string">
         <xs:minLength value="1"/>
         <xs:maxLength value="50"/>
         <xs:pattern value="([a-zA-Z0-9i\*\.\s=_-])*"/>
       </xs:restriction>
     </xs:simpleType>
   </xs:attribute>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='id']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Replace entirety of id to enable max length to keep Xsat Happy.  </xsl:comment> 
    <xs:attribute name="id">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:ownerProducer="USA" ism:classification="U">A unique local identifier
            used for binding and signing purposes. Not guaranteed to be unique across
            multiple TDC/TDOs but must be unique within a single instance of
            either.</xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:simpleType>
        <xs:restriction base="xs:ID">
          <xs:maxLength value="50"/>
        </xs:restriction>
      </xs:simpleType>
    </xs:attribute>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='idRef']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Replace entirety of idRef to enable max length to keep Xsat Happy.  </xsl:comment> 
    <xs:attribute name="idRef">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:ownerProducer="USA" ism:classification="U"> A reference to a 
            unique local identifier.</xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:simpleType>
        <xs:restriction base="xs:IDREF">
          <xs:maxLength value="50"/>
        </xs:restriction>
      </xs:simpleType>
    </xs:attribute>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--replaceElement--><xsl:template match="xs:attribute[@name='uri']">
      <xsl:call-template name="show-old-element"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Replace entirety of uri to enable max length to keep Xsat Happy.  </xsl:comment> 
    <xs:attribute name="uri">
      <xs:annotation>
        <xs:documentation>
          <xhtml:p ism:classification="U" ism:ownerProducer="USA">A uri expressing the
            location of the referenced material.</xhtml:p>
        </xs:documentation>
      </xs:annotation>
      <xs:simpleType>
        <xs:restriction base="xs:anyURI">
          <xs:maxLength value="1024"/>
        </xs:restriction>
      </xs:simpleType>
    </xs:attribute>
  </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <!--injectAttribute--><xsl:template match="xs:element[@name='Binding']">
      <xsl:call-template name="show-old-start-tag"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Restrict to 5 signatures instead of unbounded . </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
      <xsl:copy>
         <xsl:apply-templates select="@*"/>
         <xsl:attribute name="maxOccurs" namespace="">5</xsl:attribute>
         <xsl:apply-templates select="node()"/>
      </xsl:copy>
   </xsl:template>
   <!--injectAttribute--><xsl:template match="xs:attribute[@name='version']/xs:simpleType/xs:restriction/xs:pattern">
      <xsl:call-template name="show-old-start-tag"/>
      <xsl:call-template name="copy-content">
         <xsl:with-param name="rtf" xml:space="preserve">
    <xsl:comment> CdsManifest: Update tdf:version regex to be for CDSM-TDF customization </xsl:comment>
  </xsl:with-param>
      </xsl:call-template>
      <xsl:copy>
         <xsl:apply-templates select="@*"/>
         <xsl:attribute name="value" namespace="">[0-9]{6}(\.[0-9]{6})?\-CDSM\-TDF\.[0-9]{6}(\.[0-9]{6})?(\-.{1,23})?</xsl:attribute>
         <xsl:apply-templates select="node()"/>
      </xsl:copy>
   </xsl:template>
</xsl:stylesheet>
